/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;

public class Util
implements SuffixConstants {
    public static final char C_BOOLEAN = 'Z';
    public static final char C_BYTE = 'B';
    public static final char C_CHAR = 'C';
    public static final char C_DOUBLE = 'D';
    public static final char C_FLOAT = 'F';
    public static final char C_INT = 'I';
    public static final char C_SEMICOLON = ';';
    public static final char C_COLON = ':';
    public static final char C_LONG = 'J';
    public static final char C_SHORT = 'S';
    public static final char C_VOID = 'V';
    public static final char C_TYPE_VARIABLE = 'T';
    public static final char C_STAR = '*';
    public static final char C_EXCEPTION_START = '^';
    public static final char C_EXTENDS = '+';
    public static final char C_SUPER = '-';
    public static final char C_DOT = '.';
    public static final char C_DOLLAR = '$';
    public static final char C_ARRAY = '[';
    public static final char C_RESOLVED = 'L';
    public static final char C_UNRESOLVED = 'Q';
    public static final char C_NAME_END = ';';
    public static final char C_PARAM_START = '(';
    public static final char C_PARAM_END = ')';
    public static final char C_GENERIC_START = '<';
    public static final char C_GENERIC_END = '>';
    public static final char C_CAPTURE = '!';
    private static final int DEFAULT_READING_SIZE = 8192;
    private static final int DEFAULT_WRITING_SIZE = 1024;
    public static final String UTF_8 = "UTF-8";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String EMPTY_STRING = new String(CharOperation.NO_CHAR);
    public static final int[] EMPTY_INT_ARRAY = new int[0];

    public static String buildAllDirectoriesInto(String string, String string2) throws IOException {
        String string3;
        String string4;
        char c = File.separatorChar;
        String string5 = File.separator;
        string = string.replace('/', c);
        int n = (string2 = string2.replace('/', c)).lastIndexOf(c);
        if (n == -1) {
            if (string.endsWith(string5)) {
                string4 = string.substring(0, string.length() - 1);
                string3 = string + string2;
            } else {
                string4 = string;
                string3 = string + string5 + string2;
            }
        } else if (string.endsWith(string5)) {
            string4 = string + string2.substring(0, n);
            string3 = string + string2;
        } else {
            string4 = string + string5 + string2.substring(0, n);
            string3 = string + string5 + string2;
        }
        File file = new File(string4);
        file.mkdirs();
        if (file.isDirectory()) {
            return string3;
        }
        if (string.endsWith(string5)) {
            string = string.substring(0, string.length() - 1);
        }
        file = new File(string);
        boolean bl = false;
        if (file.exists()) {
            bl = true;
        } else if (!file.mkdirs()) {
            if (file.exists()) {
                bl = true;
            } else {
                throw new IOException(Messages.bind(Messages.output_notValidAll, file.getAbsolutePath()));
            }
        }
        if (bl && !file.isDirectory()) {
            throw new IOException(Messages.bind(Messages.output_isFile, file.getAbsolutePath()));
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(string5);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string5);
        String string6 = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            file = new File(stringBuffer.append(string6).append(string5).toString());
            bl = false;
            if (file.exists()) {
                bl = true;
            } else if (!file.mkdir()) {
                if (file.exists()) {
                    bl = true;
                } else {
                    throw new IOException(Messages.bind(Messages.output_notValid, stringBuffer.substring(string.length() + 1, stringBuffer.length() - 1), string));
                }
            }
            if (bl && !file.isDirectory()) {
                throw new IOException(Messages.bind(Messages.output_isFile, file.getAbsolutePath()));
            }
            string6 = stringTokenizer.nextToken();
        }
        return stringBuffer.append(string6).toString();
    }

    public static char[] bytesToChar(byte[] byArray, String string) throws IOException {
        return Util.getInputStreamAsCharArray(new ByteArrayInputStream(byArray), byArray.length, string);
    }

    public static int computeOuterMostVisibility(TypeDeclaration typeDeclaration, int n) {
        while (typeDeclaration != null) {
            switch (typeDeclaration.modifiers & 7) {
                case 2: {
                    n = 2;
                    break;
                }
                case 0: {
                    if (n == 2) break;
                    n = 0;
                    break;
                }
                case 4: {
                    if (n != 1) break;
                    n = 4;
                }
            }
            typeDeclaration = typeDeclaration.enclosingType;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileByteContent(File file) throws IOException {
        byte[] byArray;
        block5: {
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                byArray = Util.getInputStreamAsByteArray(bufferedInputStream, (int)file.length());
                Object var4_3 = null;
                if (bufferedInputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var4_4 = null;
                    if (bufferedInputStream == null) break block6;
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] getFileCharContent(File file, String string) throws IOException {
        char[] cArray;
        block5: {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                cArray = Util.getInputStreamAsCharArray(fileInputStream, (int)file.length(), string);
                Object var5_4 = null;
                if (fileInputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_5 = null;
                    if (fileInputStream == null) break block6;
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return cArray;
    }

    private static FileOutputStream getFileOutputStream(boolean bl, String string, String string2) throws IOException {
        if (bl) {
            return new FileOutputStream(new File(Util.buildAllDirectoriesInto(string, string2)));
        }
        String string3 = null;
        char c = File.separatorChar;
        String string4 = File.separator;
        string = string.replace('/', c);
        int n = string2.lastIndexOf(c);
        if (n == -1) {
            string3 = string.endsWith(string4) ? string + string2 : string + string4 + string2;
        } else {
            int n2 = string2.length();
            string3 = string.endsWith(string4) ? string + string2.substring(n + 1, n2) : string + string4 + string2.substring(n + 1, n2);
        }
        return new FileOutputStream(new File(string3));
    }

    public static byte[] getInputStreamAsByteArray(InputStream inputStream, int n) throws IOException {
        byte[] byArray;
        if (n == -1) {
            byArray = new byte[]{};
            int n2 = 0;
            int n3 = -1;
            do {
                int n4;
                if (n2 + (n4 = Math.max(inputStream.available(), 8192)) > byArray.length) {
                    byte[] byArray2 = byArray;
                    byArray = new byte[n2 + n4];
                    System.arraycopy(byArray2, 0, byArray, 0, n2);
                }
                if ((n3 = inputStream.read(byArray, n2, n4)) <= 0) continue;
                n2 += n3;
            } while (n3 != -1);
            if (n2 < byArray.length) {
                byte[] byArray3 = byArray;
                byArray = new byte[n2];
                System.arraycopy(byArray3, 0, byArray, 0, n2);
            }
        } else {
            byArray = new byte[n];
            int n5 = 0;
            int n6 = 0;
            while (n6 != -1 && n5 != n) {
                n6 = inputStream.read(byArray, n5 += n6, n - n5);
            }
        }
        return byArray;
    }

    public static char[] getInputStreamAsCharArray(InputStream inputStream, int n, String string) throws IOException {
        int n2;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = string == null ? new BufferedReader(new InputStreamReader(inputStream)) : new BufferedReader(new InputStreamReader(inputStream, string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        }
        int n3 = 0;
        char[] cArray = n == -1 ? CharOperation.NO_CHAR : new char[n];
        while (true) {
            int n4;
            if (n3 < n) {
                n2 = n - n3;
            } else {
                n4 = bufferedReader.read();
                if (n4 < 0) break;
                n2 = Math.max(inputStream.available(), 8192);
                if (n3 + 1 + n2 > cArray.length) {
                    char[] cArray2 = cArray;
                    cArray = new char[n3 + 1 + n2];
                    System.arraycopy(cArray2, 0, cArray, 0, n3);
                }
                cArray[n3++] = (char)n4;
            }
            n4 = bufferedReader.read(cArray, n3, n2);
            if (n4 < 0) break;
            n3 += n4;
        }
        n2 = 0;
        if (n3 > 0 && UTF_8.equals(string) && cArray[0] == '\ufeff') {
            --n3;
            n2 = 1;
        }
        if (n3 < cArray.length) {
            char[] cArray3 = cArray;
            cArray = new char[n3];
            System.arraycopy(cArray3, n2, cArray, 0, n3);
        }
        return cArray;
    }

    public static String getExceptionSummary(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        StringBuffer stringBuffer = stringWriter.getBuffer();
        StringBuffer stringBuffer2 = new StringBuffer(50);
        stringBuffer2.append(throwable.toString());
        int n = 0;
        int n2 = stringBuffer.length();
        int n3 = 0;
        block4: for (int i = 0; i < n2; ++i) {
            switch (stringBuffer.charAt(i)) {
                case '\n': 
                case '\r': {
                    if (n3 > 0) {
                        stringBuffer2.append(' ').append(stringBuffer.substring(n3, i));
                        break block4;
                    }
                    ++n;
                    continue block4;
                }
                case '\t': 
                case ' ': {
                    continue block4;
                }
                default: {
                    if (n <= 0) continue block4;
                    n3 = i;
                    n = 0;
                }
            }
        }
        return stringBuffer2.toString();
    }

    public static int getLineNumber(int n, int[] nArray, int n2, int n3) {
        if (nArray == null) {
            return 1;
        }
        if (n3 == -1) {
            return 1;
        }
        int n4 = n2;
        while (n2 <= n3) {
            n4 = n2 + (n3 - n2) / 2;
            int n5 = nArray[n4];
            if (n < n5) {
                n3 = n4 - 1;
                continue;
            }
            if (n > n5) {
                n2 = n4 + 1;
                continue;
            }
            return n4 + 1;
        }
        if (n < nArray[n4]) {
            return n4 + 1;
        }
        return n4 + 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getZipEntryByteContent(ZipEntry zipEntry, ZipFile zipFile) throws IOException {
        byte[] byArray;
        block6: {
            InputStream inputStream = null;
            try {
                InputStream inputStream2 = zipFile.getInputStream(zipEntry);
                if (inputStream2 == null) {
                    throw new IOException("Invalid zip entry name : " + zipEntry.getName());
                }
                inputStream = new BufferedInputStream(inputStream2);
                byArray = Util.getInputStreamAsByteArray(inputStream, (int)zipEntry.getSize());
                Object var6_5 = null;
                if (inputStream == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var6_6 = null;
                    if (inputStream == null) break block7;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return byArray;
    }

    public static int hashCode(Object[] objectArray) {
        int n = 31;
        if (objectArray == null) {
            return 0;
        }
        int n2 = 1;
        for (int i = 0; i < objectArray.length; ++i) {
            n2 = n * n2 + (objectArray[i] == null ? 0 : objectArray[i].hashCode());
        }
        return n2;
    }

    public static final boolean isPotentialZipArchive(String string) {
        int n;
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return false;
        }
        if (string.lastIndexOf(File.separatorChar) > n2) {
            return false;
        }
        int n3 = string.length();
        int n4 = n3 - n2 - 1;
        if (n4 == "java".length()) {
            for (n = n4 - 1; n >= 0 && Character.toLowerCase(string.charAt(n3 - n4 + n)) == "java".charAt(n); --n) {
                if (n != 0) continue;
                return false;
            }
        }
        if (n4 == "class".length()) {
            for (n = n4 - 1; n >= 0; --n) {
                if (Character.toLowerCase(string.charAt(n3 - n4 + n)) == "class".charAt(n)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static final boolean isClassFileName(char[] cArray) {
        int n;
        int n2 = cArray == null ? 0 : cArray.length;
        if (n2 < (n = SuffixConstants.SUFFIX_CLASS.length)) {
            return false;
        }
        int n3 = n2 - n;
        for (int i = 0; i < n; ++i) {
            char c = cArray[n3 + i];
            if (c == SuffixConstants.SUFFIX_class[i] || c == SuffixConstants.SUFFIX_CLASS[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean isClassFileName(String string) {
        int n;
        int n2 = string == null ? 0 : string.length();
        if (n2 < (n = SuffixConstants.SUFFIX_CLASS.length)) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            int n3;
            char c = string.charAt(n2 - i - 1);
            if (c == SuffixConstants.SUFFIX_class[n3 = n - i - 1] || c == SuffixConstants.SUFFIX_CLASS[n3]) continue;
            return false;
        }
        return true;
    }

    public static final boolean isExcluded(char[] cArray, char[][] cArray2, char[][] cArray3, boolean bl) {
        int n;
        int n2;
        block8: {
            if (cArray2 == null && cArray3 == null) {
                return false;
            }
            if (cArray2 != null) {
                n2 = cArray2.length;
                for (n = 0; n < n2; ++n) {
                    int n3;
                    int n4;
                    char[] cArray4;
                    char[] cArray5 = cArray4 = cArray2[n];
                    if (bl && (n4 = CharOperation.lastIndexOf('/', cArray4)) != -1 && n4 != cArray4.length - 1 && ((n3 = CharOperation.indexOf('*', cArray4, n4)) == -1 || n3 >= cArray4.length - 1 || cArray4[n3 + 1] != '*')) {
                        cArray5 = CharOperation.subarray(cArray4, 0, n4);
                    }
                    if (!CharOperation.pathMatch(cArray5, cArray, true, '/')) {
                        continue;
                    }
                    break block8;
                }
                return true;
            }
        }
        if (bl) {
            cArray = CharOperation.concat(cArray, new char[]{'*'}, '/');
        }
        if (cArray3 != null) {
            n2 = cArray3.length;
            for (n = 0; n < n2; ++n) {
                if (!CharOperation.pathMatch(cArray3[n], cArray, true, '/')) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean isJavaFileName(char[] cArray) {
        int n;
        int n2 = cArray == null ? 0 : cArray.length;
        if (n2 < (n = SuffixConstants.SUFFIX_JAVA.length)) {
            return false;
        }
        int n3 = n2 - n;
        for (int i = 0; i < n; ++i) {
            char c = cArray[n3 + i];
            if (c == SuffixConstants.SUFFIX_java[i] || c == SuffixConstants.SUFFIX_JAVA[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean isJavaFileName(String string) {
        int n;
        int n2 = string == null ? 0 : string.length();
        if (n2 < (n = SuffixConstants.SUFFIX_JAVA.length)) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            int n3;
            char c = string.charAt(n2 - i - 1);
            if (c == SuffixConstants.SUFFIX_java[n3 = n - i - 1] || c == SuffixConstants.SUFFIX_JAVA[n3]) continue;
            return false;
        }
        return true;
    }

    public static void reverseQuickSort(char[][] cArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        char[] cArray2 = cArray[n + (n2 - n) / 2];
        while (true) {
            if (CharOperation.compareTo(cArray[n], cArray2) > 0) {
                ++n;
                continue;
            }
            while (CharOperation.compareTo(cArray2, cArray[n2]) > 0) {
                --n2;
            }
            if (n <= n2) {
                char[] cArray3 = cArray[n];
                cArray[n] = cArray[n2];
                cArray[n2] = cArray3;
                ++n;
                --n2;
            }
            if (n > n2) break;
        }
        if (n3 < n2) {
            Util.reverseQuickSort(cArray, n3, n2);
        }
        if (n < n4) {
            Util.reverseQuickSort(cArray, n, n4);
        }
    }

    public static void reverseQuickSort(char[][] cArray, int n, int n2, int[] nArray) {
        int n3 = n;
        int n4 = n2;
        char[] cArray2 = cArray[n + (n2 - n) / 2];
        while (true) {
            if (CharOperation.compareTo(cArray[n], cArray2) > 0) {
                ++n;
                continue;
            }
            while (CharOperation.compareTo(cArray2, cArray[n2]) > 0) {
                --n2;
            }
            if (n <= n2) {
                char[] cArray3 = cArray[n];
                cArray[n] = cArray[n2];
                cArray[n2] = cArray3;
                int n5 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n5;
                ++n;
                --n2;
            }
            if (n > n2) break;
        }
        if (n3 < n2) {
            Util.reverseQuickSort(cArray, n3, n2, nArray);
        }
        if (n < n4) {
            Util.reverseQuickSort(cArray, n, n4, nArray);
        }
    }

    public static final int searchColumnNumber(int[] nArray, int n, int n2) {
        switch (n) {
            case 1: {
                return n2 + 1;
            }
            case 2: {
                return n2 - nArray[0];
            }
        }
        int n3 = n - 2;
        int n4 = nArray.length;
        if (n3 >= n4) {
            return n2 - nArray[n4 - 1];
        }
        return n2 - nArray[n3];
    }

    public static Boolean toBoolean(boolean bl) {
        if (bl) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String toString(Object[] objectArray) {
        return Util.toString(objectArray, new Displayable(){

            public String displayString(Object object) {
                if (object == null) {
                    return "null";
                }
                return object.toString();
            }
        });
    }

    public static String toString(Object[] objectArray, Displayable displayable) {
        if (objectArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(displayable.displayString(objectArray[i]));
        }
        return stringBuffer.toString();
    }

    public static void writeToDisk(boolean bl, String string, String string2, ClassFile classFile) throws IOException {
        FileOutputStream fileOutputStream = Util.getFileOutputStream(bl, string, string2);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 1024);
        try {
            bufferedOutputStream.write(classFile.header, 0, classFile.headerOffset);
            bufferedOutputStream.write(classFile.contents, 0, classFile.contentsOffset);
            bufferedOutputStream.flush();
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            bufferedOutputStream.close();
            throw throwable;
        }
        bufferedOutputStream.close();
    }

    public static void recordNestedType(ClassFile classFile, TypeBinding typeBinding) {
        if (classFile.visitedTypes == null) {
            classFile.visitedTypes = new HashSet(3);
        } else if (classFile.visitedTypes.contains(typeBinding)) {
            return;
        }
        classFile.visitedTypes.add(typeBinding);
        if (typeBinding.isParameterizedType() && (typeBinding.tagBits & 0x800L) != 0L) {
            TypeBinding[] typeBindingArray;
            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding;
            ReferenceBinding referenceBinding = parameterizedTypeBinding.genericType();
            if ((referenceBinding.tagBits & 0x800L) != 0L) {
                Util.recordNestedType(classFile, referenceBinding);
            }
            if ((typeBindingArray = parameterizedTypeBinding.arguments) != null) {
                int n = typeBindingArray.length;
                for (int i = 0; i < n; ++i) {
                    TypeBinding typeBinding2 = typeBindingArray[i];
                    if (typeBinding2.isWildcard()) {
                        ReferenceBinding[] referenceBindingArray;
                        ReferenceBinding referenceBinding2;
                        WildcardBinding wildcardBinding = (WildcardBinding)typeBinding2;
                        TypeBinding typeBinding3 = wildcardBinding.bound;
                        if (typeBinding3 != null && (typeBinding3.tagBits & 0x800L) != 0L) {
                            Util.recordNestedType(classFile, typeBinding3);
                        }
                        if ((referenceBinding2 = wildcardBinding.superclass()) != null && (referenceBinding2.tagBits & 0x800L) != 0L) {
                            Util.recordNestedType(classFile, referenceBinding2);
                        }
                        if ((referenceBindingArray = wildcardBinding.superInterfaces()) == null) continue;
                        int n2 = referenceBindingArray.length;
                        for (int j = 0; j < n2; ++j) {
                            ReferenceBinding referenceBinding3 = referenceBindingArray[j];
                            if ((referenceBinding3.tagBits & 0x800L) == 0L) continue;
                            Util.recordNestedType(classFile, referenceBinding3);
                        }
                        continue;
                    }
                    if ((typeBinding2.tagBits & 0x800L) == 0L) continue;
                    Util.recordNestedType(classFile, typeBinding2);
                }
            }
        } else if (typeBinding.isTypeVariable() && (typeBinding.tagBits & 0x800L) != 0L) {
            TypeBinding[] typeBindingArray;
            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)typeBinding;
            TypeBinding typeBinding4 = typeVariableBinding.upperBound();
            if (typeBinding4 != null && (typeBinding4.tagBits & 0x800L) != 0L) {
                Util.recordNestedType(classFile, typeBinding4);
            }
            if ((typeBindingArray = typeVariableBinding.otherUpperBounds()) != null) {
                int n = typeBindingArray.length;
                for (int i = 0; i < n; ++i) {
                    TypeBinding typeBinding5 = typeBindingArray[i];
                    if ((typeBinding5.tagBits & 0x800L) == 0L) continue;
                    Util.recordNestedType(classFile, typeBinding5);
                }
            }
        } else if (typeBinding.isNestedType()) {
            classFile.recordInnerClasses(typeBinding);
        }
    }

    public static File getJavaHome() {
        File file;
        String string = System.getProperty("java.home");
        if (string != null && (file = new File(string)).exists()) {
            return file;
        }
        return null;
    }

    public static void collectRunningVMBootclasspath(List list) {
        block7: {
            block6: {
                String string = System.getProperty("java.version");
                if (string != null && string.equalsIgnoreCase("1.1.8")) {
                    throw new IllegalStateException();
                }
                String string2 = System.getProperty("sun.boot.class.path");
                if (!(string2 != null && string2.length() != 0 || (string2 = System.getProperty("vm.boot.class.path")) != null && string2.length() != 0)) {
                    string2 = System.getProperty("org.apache.harmony.boot.class.path");
                }
                if (string2 == null || string2.length() == 0) break block6;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    FileSystem.Classpath classpath = FileSystem.getClasspath(string3, null, null);
                    if (classpath == null) continue;
                    list.add(classpath);
                }
                break block7;
            }
            File file = Util.getJavaHome();
            if (file == null) break block7;
            File[] fileArray = null;
            fileArray = System.getProperty("os.name").startsWith("Mac") ? new File[]{new File(file, "../Classes")} : new File[]{new File(file, "lib")};
            File[][] fileArray2 = Main.getLibrariesFiles(fileArray);
            if (fileArray2 != null) {
                int n = fileArray2.length;
                for (int i = 0; i < n; ++i) {
                    File[] fileArray3 = fileArray2[i];
                    if (fileArray3 == null) continue;
                    int n2 = fileArray3.length;
                    for (int j = 0; j < n2; ++j) {
                        FileSystem.Classpath classpath = FileSystem.getClasspath(fileArray3[j].getAbsolutePath(), null, false, null, null);
                        if (classpath == null) continue;
                        list.add(classpath);
                    }
                }
            }
        }
    }

    public static int getParameterCount(char[] cArray) {
        try {
            int n = 0;
            int n2 = CharOperation.indexOf('(', cArray);
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            ++n2;
            while (true) {
                if (cArray[n2] == ')') {
                    return n;
                }
                int n3 = Util.scanTypeSignature(cArray, n2);
                if (n3 < 0) {
                    throw new IllegalArgumentException();
                }
                n2 = n3 + 1;
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static int scanTypeSignature(char[] cArray, int n) {
        if (n >= cArray.length) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        switch (c) {
            case '[': {
                return Util.scanArrayTypeSignature(cArray, n);
            }
            case 'L': 
            case 'Q': {
                return Util.scanClassTypeSignature(cArray, n);
            }
            case 'T': {
                return Util.scanTypeVariableSignature(cArray, n);
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return Util.scanBaseTypeSignature(cArray, n);
            }
            case '!': {
                return Util.scanCaptureTypeSignature(cArray, n);
            }
            case '*': 
            case '+': 
            case '-': {
                return Util.scanTypeBoundSignature(cArray, n);
            }
        }
        throw new IllegalArgumentException();
    }

    public static int scanBaseTypeSignature(char[] cArray, int n) {
        if (n >= cArray.length) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if ("BCDFIJSVZ".indexOf(c) >= 0) {
            return n;
        }
        throw new IllegalArgumentException();
    }

    public static int scanArrayTypeSignature(char[] cArray, int n) {
        int n2 = cArray.length;
        if (n >= n2 - 1) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if (c != '[') {
            throw new IllegalArgumentException();
        }
        c = cArray[++n];
        while (c == '[') {
            if (n >= n2 - 1) {
                throw new IllegalArgumentException();
            }
            c = cArray[++n];
        }
        return Util.scanTypeSignature(cArray, n);
    }

    public static int scanCaptureTypeSignature(char[] cArray, int n) {
        if (n >= cArray.length - 1) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if (c != '!') {
            throw new IllegalArgumentException();
        }
        return Util.scanTypeBoundSignature(cArray, n + 1);
    }

    public static int scanTypeVariableSignature(char[] cArray, int n) {
        if (n >= cArray.length - 2) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if (c != 'T') {
            throw new IllegalArgumentException();
        }
        int n2 = Util.scanIdentifier(cArray, n + 1);
        c = cArray[n2 + 1];
        if (c == ';') {
            return n2 + 1;
        }
        throw new IllegalArgumentException();
    }

    public static int scanIdentifier(char[] cArray, int n) {
        if (n >= cArray.length) {
            throw new IllegalArgumentException();
        }
        int n2 = n;
        do {
            char c;
            if ((c = cArray[n2]) != '<' && c != '>' && c != ':' && c != ';' && c != '.' && c != '/') continue;
            return n2 - 1;
        } while (++n2 != cArray.length);
        return n2 - 1;
    }

    public static int scanClassTypeSignature(char[] cArray, int n) {
        if (n >= cArray.length - 2) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if (c != 'L' && c != 'Q') {
            return -1;
        }
        int n2 = n + 1;
        while (true) {
            int n3;
            if (n2 >= cArray.length) {
                throw new IllegalArgumentException();
            }
            c = cArray[n2];
            if (c == ';') {
                return n2;
            }
            if (c == '<') {
                n2 = n3 = Util.scanTypeArgumentSignatures(cArray, n2);
            } else if (c == '.' || c == '/') {
                n2 = n3 = Util.scanIdentifier(cArray, n2 + 1);
            }
            ++n2;
        }
    }

    public static int scanTypeBoundSignature(char[] cArray, int n) {
        if (n >= cArray.length) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        switch (c) {
            case '*': {
                return n;
            }
            case '+': 
            case '-': {
                if (n < cArray.length - 2) break;
                throw new IllegalArgumentException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        c = cArray[++n];
        switch (c) {
            case '!': {
                return Util.scanCaptureTypeSignature(cArray, n);
            }
            case '+': 
            case '-': {
                return Util.scanTypeBoundSignature(cArray, n);
            }
            case 'L': 
            case 'Q': {
                return Util.scanClassTypeSignature(cArray, n);
            }
            case 'T': {
                return Util.scanTypeVariableSignature(cArray, n);
            }
            case '[': {
                return Util.scanArrayTypeSignature(cArray, n);
            }
            case '*': {
                return n;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int scanTypeArgumentSignatures(char[] cArray, int n) {
        if (n >= cArray.length - 1) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if (c != '<') {
            throw new IllegalArgumentException();
        }
        int n2 = n + 1;
        while (true) {
            if (n2 >= cArray.length) {
                throw new IllegalArgumentException();
            }
            c = cArray[n2];
            if (c == '>') {
                return n2;
            }
            int n3 = Util.scanTypeArgumentSignature(cArray, n2);
            n2 = n3 + 1;
        }
    }

    public static int scanTypeArgumentSignature(char[] cArray, int n) {
        if (n >= cArray.length) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        switch (c) {
            case '*': {
                return n;
            }
            case '+': 
            case '-': {
                return Util.scanTypeBoundSignature(cArray, n);
            }
        }
        return Util.scanTypeSignature(cArray, n);
    }

    public static interface Displayable {
        public String displayString(Object var1);
    }
}

