/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.dispatch;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.apt.dispatch.AnnotationDiscoveryVisitor;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.Factory;
import org.eclipse.jdt.internal.compiler.apt.model.TypeElementImpl;
import org.eclipse.jdt.internal.compiler.apt.util.ManyToMany;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;

public class RoundEnvImpl
implements RoundEnvironment {
    private final BaseProcessingEnvImpl _processingEnv;
    private final boolean _isLastRound;
    private final CompilationUnitDeclaration[] _units;
    private final ManyToMany<TypeElement, Element> _annoToUnit;
    private final ReferenceBinding[] _binaryTypes;
    private final Factory _factory;
    private Set<Element> _rootElements = null;

    public RoundEnvImpl(CompilationUnitDeclaration[] compilationUnitDeclarationArray, ReferenceBinding[] referenceBindingArray, boolean bl, BaseProcessingEnvImpl baseProcessingEnvImpl) {
        this._processingEnv = baseProcessingEnvImpl;
        this._isLastRound = bl;
        this._units = compilationUnitDeclarationArray;
        this._factory = this._processingEnv.getFactory();
        AnnotationDiscoveryVisitor annotationDiscoveryVisitor = new AnnotationDiscoveryVisitor(this._processingEnv);
        if (this._units != null) {
            for (CompilationUnitDeclaration compilationUnitDeclaration : this._units) {
                compilationUnitDeclaration.traverse((ASTVisitor)annotationDiscoveryVisitor, compilationUnitDeclaration.scope);
            }
        }
        this._annoToUnit = annotationDiscoveryVisitor._annoToElement;
        if (referenceBindingArray != null) {
            this.collectAnnotations(referenceBindingArray);
        }
        this._binaryTypes = referenceBindingArray;
    }

    private void collectAnnotations(ReferenceBinding[] referenceBindingArray) {
        for (ReferenceBinding referenceBinding : referenceBindingArray) {
            Element element;
            Object object;
            int n;
            if (referenceBinding instanceof ParameterizedTypeBinding) {
                referenceBinding = ((ParameterizedTypeBinding)referenceBinding).genericType();
            }
            AnnotationBinding[] annotationBindingArray = referenceBinding.getAnnotations();
            Object[] objectArray = annotationBindingArray;
            int n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                AnnotationBinding annotationBinding = objectArray[n];
                object = (TypeElement)this._factory.newElement(annotationBinding.getAnnotationType());
                Object object2 = this._factory.newElement(referenceBinding);
                this._annoToUnit.put((TypeElement)object, (Element)object2);
            }
            Object[] objectArray2 = objectArray = referenceBinding.fields();
            n = objectArray2.length;
            for (int i = 0; i < n; ++i) {
                object = objectArray2[i];
                annotationBindingArray = ((FieldBinding)object).getAnnotations();
                for (AnnotationBinding annotationBinding : annotationBindingArray) {
                    TypeElement typeElement = (TypeElement)this._factory.newElement(annotationBinding.getAnnotationType());
                    element = this._factory.newElement((Binding)object);
                    this._annoToUnit.put(typeElement, element);
                }
            }
            for (Object object2 : objectArray2 = referenceBinding.methods()) {
                for (AnnotationBinding annotationBinding : annotationBindingArray = ((MethodBinding)object2).getAnnotations()) {
                    element = (TypeElement)this._factory.newElement(annotationBinding.getAnnotationType());
                    Element element2 = this._factory.newElement((Binding)object2);
                    this._annoToUnit.put((TypeElement)element, element2);
                }
            }
            Object[] objectArray3 = referenceBinding.memberTypes();
            this.collectAnnotations((ReferenceBinding[])objectArray3);
        }
    }

    public Set<TypeElement> getRootAnnotations() {
        return Collections.unmodifiableSet(this._annoToUnit.getKeySet());
    }

    @Override
    public boolean errorRaised() {
        return this._processingEnv.errorRaised();
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(TypeElement typeElement) {
        if (typeElement.getKind() != ElementKind.ANNOTATION_TYPE) {
            throw new IllegalArgumentException("Argument must represent an annotation type");
        }
        Binding binding = ((TypeElementImpl)typeElement)._binding;
        if (0L != (binding.getAnnotationTagBits() & 0x1000000000000L)) {
            HashSet<Element> hashSet = new HashSet<Element>(this._annoToUnit.getValues(typeElement));
            ReferenceBinding referenceBinding = (ReferenceBinding)binding;
            for (TypeElement typeElement2 : ElementFilter.typesIn(this.getRootElements())) {
                ReferenceBinding referenceBinding2 = (ReferenceBinding)((TypeElementImpl)typeElement2)._binding;
                this.addAnnotatedElements(referenceBinding, referenceBinding2, hashSet);
            }
            return Collections.unmodifiableSet(hashSet);
        }
        return Collections.unmodifiableSet(this._annoToUnit.getValues(typeElement));
    }

    private void addAnnotatedElements(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2, Set<Element> set) {
        if (referenceBinding2.isClass() && this.inheritsAnno(referenceBinding2, referenceBinding)) {
            set.add(this._factory.newElement(referenceBinding2));
        }
        for (ReferenceBinding referenceBinding3 : referenceBinding2.memberTypes()) {
            this.addAnnotatedElements(referenceBinding, referenceBinding3, set);
        }
    }

    private boolean inheritsAnno(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        ReferenceBinding referenceBinding3 = referenceBinding;
        do {
            AnnotationBinding[] annotationBindingArray;
            if (referenceBinding3 instanceof ParameterizedTypeBinding) {
                referenceBinding3 = ((ParameterizedTypeBinding)referenceBinding3).genericType();
            }
            for (AnnotationBinding annotationBinding : annotationBindingArray = referenceBinding3.getAnnotations()) {
                if (annotationBinding.getAnnotationType() != referenceBinding2) continue;
                return true;
            }
        } while (null != (referenceBinding3 = referenceBinding3.superclass()));
        return false;
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(Class<? extends Annotation> clazz) {
        String string = clazz.getCanonicalName();
        if (string == null) {
            throw new IllegalArgumentException("Argument must represent an annotation type");
        }
        TypeElement typeElement = this._processingEnv.getElementUtils().getTypeElement(string);
        return this.getElementsAnnotatedWith(typeElement);
    }

    @Override
    public Set<? extends Element> getRootElements() {
        if (this._units == null) {
            return Collections.emptySet();
        }
        if (this._rootElements == null) {
            HashSet<Element> hashSet = new HashSet<Element>(this._units.length);
            for (CompilationUnitDeclaration object : this._units) {
                if (null == object.scope || null == object.scope.topLevelTypes) continue;
                for (SourceTypeBinding sourceTypeBinding : object.scope.topLevelTypes) {
                    Element element = this._factory.newElement(sourceTypeBinding);
                    if (null == element) {
                        throw new IllegalArgumentException("Top-level type binding could not be converted to element: " + sourceTypeBinding);
                    }
                    hashSet.add(element);
                }
            }
            if (this._binaryTypes != null) {
                for (ReferenceBinding referenceBinding : this._binaryTypes) {
                    TypeElement typeElement = (TypeElement)this._factory.newElement(referenceBinding);
                    if (null == typeElement) {
                        throw new IllegalArgumentException("Top-level type binding could not be converted to element: " + referenceBinding);
                    }
                    hashSet.add(typeElement);
                }
            }
            this._rootElements = hashSet;
        }
        return this._rootElements;
    }

    @Override
    public boolean processingOver() {
        return this._isLastRound;
    }
}

