/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

public class QualifiedTypeReference
extends TypeReference {
    public char[][] tokens;
    public long[] sourcePositions;

    public QualifiedTypeReference(char[][] cArray, long[] lArray) {
        this.tokens = cArray;
        this.sourcePositions = lArray;
        this.sourceStart = (int)(this.sourcePositions[0] >>> 32);
        this.sourceEnd = (int)(this.sourcePositions[this.sourcePositions.length - 1] & 0xFFFFFFFFL);
    }

    public TypeReference copyDims(int n) {
        return new ArrayQualifiedTypeReference(this.tokens, n, this.sourcePositions);
    }

    protected TypeBinding findNextTypeBinding(int n, Scope scope, PackageBinding packageBinding) {
        LookupEnvironment lookupEnvironment = scope.environment();
        try {
            lookupEnvironment.missingClassFileLocation = this;
            if (this.resolvedType == null) {
                this.resolvedType = scope.getType(this.tokens[n], packageBinding);
            } else {
                this.resolvedType = scope.getMemberType(this.tokens[n], (ReferenceBinding)this.resolvedType);
                if (!this.resolvedType.isValidBinding()) {
                    this.resolvedType = new ProblemReferenceBinding(CharOperation.subarray(this.tokens, 0, n + 1), (ReferenceBinding)this.resolvedType.closestMatch(), this.resolvedType.problemId());
                }
            }
            TypeBinding typeBinding = this.resolvedType;
            return typeBinding;
        }
        catch (AbortCompilation abortCompilation) {
            abortCompilation.updateContext(this, scope.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
        finally {
            lookupEnvironment.missingClassFileLocation = null;
        }
    }

    public char[] getLastToken() {
        return this.tokens[this.tokens.length - 1];
    }

    protected TypeBinding getTypeBinding(Scope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        Binding binding = scope.getPackage(this.tokens);
        if (binding != null && !binding.isValidBinding()) {
            if (binding instanceof ProblemReferenceBinding && binding.problemId() == 1) {
                ProblemReferenceBinding problemReferenceBinding = (ProblemReferenceBinding)binding;
                Binding binding2 = scope.getTypeOrPackage(this.tokens);
                return new ProblemReferenceBinding(problemReferenceBinding.compoundName, binding2 instanceof PackageBinding ? null : scope.environment().createMissingType(null, this.tokens), 1);
            }
            return (ReferenceBinding)binding;
        }
        PackageBinding packageBinding = binding == null ? null : (PackageBinding)binding;
        boolean bl = scope.kind == 3;
        ReferenceBinding referenceBinding = null;
        int n = this.tokens.length;
        int n2 = n - 1;
        for (int i = packageBinding == null ? 0 : packageBinding.compoundName.length; i < n; ++i) {
            this.findNextTypeBinding(i, scope, packageBinding);
            if (!this.resolvedType.isValidBinding()) {
                return this.resolvedType;
            }
            if (i == 0 && this.resolvedType.isTypeVariable() && ((TypeVariableBinding)this.resolvedType).firstBound == null) {
                scope.problemReporter().illegalAccessFromTypeVariable((TypeVariableBinding)this.resolvedType, this);
                return null;
            }
            if (i <= n2 && this.isTypeUseDeprecated(this.resolvedType, scope)) {
                this.reportDeprecatedType(this.resolvedType, scope, i);
            }
            if (bl && ((ClassScope)scope).detectHierarchyCycle(this.resolvedType, this)) {
                return null;
            }
            ReferenceBinding referenceBinding2 = (ReferenceBinding)this.resolvedType;
            if (referenceBinding != null) {
                ReferenceBinding referenceBinding3 = referenceBinding2.enclosingType();
                if (referenceBinding3 != null && referenceBinding3.erasure() != referenceBinding.erasure()) {
                    referenceBinding = referenceBinding3;
                }
                if (referenceBinding2.isGenericType()) {
                    referenceBinding = scope.environment().createRawType(referenceBinding2, referenceBinding);
                    continue;
                }
                boolean bl2 = referenceBinding.isRawType();
                if (bl2 && !referenceBinding2.isStatic()) {
                    referenceBinding = scope.environment().createRawType((ReferenceBinding)referenceBinding2.erasure(), referenceBinding);
                    continue;
                }
                if ((bl2 || referenceBinding.isParameterizedType()) && referenceBinding.erasure() == referenceBinding2.enclosingType().erasure()) {
                    referenceBinding = scope.environment().createParameterizedType((ReferenceBinding)referenceBinding2.erasure(), null, referenceBinding);
                    continue;
                }
                referenceBinding = referenceBinding2;
                continue;
            }
            referenceBinding = referenceBinding2.isGenericType() ? (ReferenceBinding)scope.environment().convertToRawType(referenceBinding2, false) : referenceBinding2;
        }
        this.resolvedType = referenceBinding;
        return this.resolvedType;
    }

    public char[][] getTypeName() {
        return this.tokens;
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        for (int i = 0; i < this.tokens.length; ++i) {
            if (i > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(this.tokens[i]);
        }
        return stringBuffer;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        aSTVisitor.visit(this, classScope);
        aSTVisitor.endVisit(this, classScope);
    }
}

