/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.util.Util;

public class CompilationUnit
implements ICompilationUnit {
    public char[] contents;
    public char[] fileName;
    public char[] mainTypeName;
    String encoding;
    public String destinationPath;

    public CompilationUnit(char[] cArray, String string, String string2) {
        this(cArray, string, string2, null);
    }

    public CompilationUnit(char[] cArray, String string, String string2, String string3) {
        this.contents = cArray;
        char[] cArray2 = string.toCharArray();
        switch (File.separatorChar) {
            case '/': {
                if (CharOperation.indexOf('\\', cArray2) == -1) break;
                CharOperation.replace(cArray2, '\\', '/');
                break;
            }
            case '\\': {
                if (CharOperation.indexOf('/', cArray2) == -1) break;
                CharOperation.replace(cArray2, '/', '\\');
            }
        }
        this.fileName = cArray2;
        int n = CharOperation.lastIndexOf(File.separatorChar, cArray2) + 1;
        int n2 = CharOperation.lastIndexOf('.', cArray2);
        if (n2 == -1) {
            n2 = cArray2.length;
        }
        this.mainTypeName = CharOperation.subarray(cArray2, n, n2);
        this.encoding = string2;
        this.destinationPath = string3;
    }

    public char[] getContents() {
        if (this.contents != null) {
            return this.contents;
        }
        try {
            return Util.getFileCharContent(new File(new String(this.fileName)), this.encoding);
        }
        catch (IOException iOException) {
            this.contents = CharOperation.NO_CHAR;
            throw new AbortCompilationUnit(null, iOException, this.encoding);
        }
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public char[] getMainTypeName() {
        return this.mainTypeName;
    }

    public char[][] getPackageName() {
        return null;
    }

    public String toString() {
        return "CompilationUnit[" + new String(this.fileName) + "]";
    }
}

