# Copyright (c) 2000-2009, JPackage Project # All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the JPackage Project nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

%define _jarsign_opts --nocopy

%define with()          %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()       %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
%define bcond_with()    %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}

%bcond_with repolib
%bcond_without mead

%define repodir %{_javadir}/repository.jboss.com/org/jboss/native/mod-cluster/%{namedversion}-brew
%define repodirlib %{repodir}/lib
%define repodirsrc %{repodir}/src

%define reltag .Final
%define brewreltag %{reltag}_redhat_1
%define namedversion %{version}%{reltag}
%define rhnamedversion %{version}%{reltag}-redhat-1
%define jarname mod-cluster

Name:		mod_cluster
Summary: 	JBoss mod_cluster for Apache httpd
Version: 	1.2.3
Release: 	1%{brewreltag}%{?dist}
Epoch:		0
License: 	LGPLv3
Group: 		Applications/System
URL:		http://www.jboss.org/

%if %without mead
# svn export http://anonsvn.jboss.org/repos/mod_cluster/tags/1.2.1.Final mod_cluster-1.2.1.Final
# tar czf mod_cluster-1.2.1.Final mod_cluster-1.2.1.Final
# Exported revision 934.
Source0:	mod_cluster-1.2.1.Final
Source1:        %{name}-jpp-depmap.xml
Source2:	%{name}-component-info.xml
Source3:	%{name}-upload.sh
%endif

BuildArch:      noarch
BuildRoot:      %{_tmppath}/%{name}-buildroot
%if %without mead
BuildRequires:	jboss-parent
BuildRequires:	ant-junit
#BuildRequires:	asm2
#BuildRequires:	codehaus-stax-api
#BuildRequires:	dtdparser
#BuildRequires:	glassfish-jaxb
BuildRequires:  maven2 >= 0:2.0.7-8
BuildRequires:	maven-antrun-plugin
BuildRequires:	maven-assembly-plugin
BuildRequires:  maven-compiler-plugin
# To create content for maven2-brew
BuildRequires:  maven-dependency-plugin
BuildRequires:	maven-deploy-plugin
BuildRequires:	maven-install-plugin
BuildRequires:	maven-jar-plugin
BuildRequires:  maven-resources-plugin
BuildRequires:  maven-release-plugin
BuildRequires:	maven-site-plugin
BuildRequires:	maven-source-plugin
BuildRequires:	maven-release
BuildRequires:  maven-shared-invoker
BuildRequires:  maven-shared-reporting-impl
BuildRequires:	maven-surefire-maven-plugin
BuildRequires:	maven-surefire-provider-junit4
BuildRequires:	mockito
#BuildRequires:	easymock2
BuildRequires:	jboss-logging
#BuildRequires:	jboss-microcontainer2
#BuildRequires:	jboss-naming
#BuildRequires:	jboss-profiler
#BuildRequires:	jboss-security-spi
#BuildRequires:	jboss-test
#BuildRequires:	jbossas
#BuildRequires:  jbosssx2
BuildRequires:	jakarta-commons-codec
BuildRequires:	jakarta-commons-httpclient
BuildRequires:	jbossweb
BuildRequires:	jboss-servlet-api_3.0_spec
BuildRequires:	jcip-annotations
#BuildRequires:	jcommon
BuildRequires:	jfreechart
BuildRequires:	junit4
#BuildRequires:	xerces-j2
#BuildRequires:	dtdparser
#BuildRequires:	gnu-trove
#BuildRequires:	jboss-serialization
BuildRequires:	zip
%endif
Obsoletes: %{name}-jbossas < %{epoch}:%{version}
Provides:  %{name}-jbossas = %{epoch}:%{version}-%{release}

%description
JBoss mod_cluster for Apache httpd

%package demo
Summary:        Sample app for %{name}
Group:          Development/Frameworks

%description demo
Load balancing demo application

%package tomcat6
Summary:        Support for %{name} in Tomcat6
Group:          Development/Libraries/Application Frameworks
Requires:       tomcat6 >= 0:6.0.35
Requires:       %{name} >= %{epoch}:%{version}-%{release}
Requires:	jboss-logging >= 0:3.0.1

%description tomcat6
Links needed for tomcat6

%package tomcat7
Summary:        Support for %{name} in Tomcat7
Group:          Development/Libraries/Application Frameworks
Requires:       tomcat7 >= 0:7.0.27
Requires:       %{name} >= %{epoch}:%{version}-%{release}
Requires:	jboss-logging >= 0:3.0.1

%description tomcat7
Links needed for tomcat7

%if %without mead
%package jbossas
Summary:        Support for %{name} in JBoss AS
Group:          Development/Libraries/Application Frameworks

%description jbossas
Jar and sar files to copy to the lib directory in JBoss AS install to support use of mod_cluster

%package jbossweb2
Summary:        Support for %{name} in JBossWeb
Group:          Development/Libraries/Application Frameworks
Requires:       %{name}-jbossas = %{epoch}:%{version}-%{release}
Requires:	jboss-logging >= 0:3.0.1

%description jbossweb2
Jar files to copy to the lib directory in JBossWeb install to support use of mod_cluster

%package zip
Summary:        %{name} full distribution
Group:          Development/Frameworks

%description zip
Full distribution; includes the jar files to support the use of mod_cluster in JBossWeb or Tomcat and a load balancing demo application. 
%endif

%package src-zip
Summary:        Container for the sources of %{name}
Group:          Development

%description src-zip
Container for the sources of %{name}

%if %with repolib
%package repolib
Summary:        Artifacts to be uploaded to a repository library
Group:          Development/Libraries/Java

%description repolib
Artifacts to be uploaded to a repository library.
This package is not meant to be installed but so its contents
can be extracted through rpm2cpio.
%endif

%prep
%if %without mead
%setup -q -n %{name}-%{namedversion}
%endif

%build
%if %without mead
zip -q -r ../%{name}-%{namedversion}-src.zip *

export MAVEN_REPO_LOCAL=$(pwd)/m2_repo/repository
export CLASSPATH=$(build-classpath jbossweb/servlet-api)

mkdir external_repo
ln -s %{_javadir} external_repo/JPP

mvn-jpp -e \
        -Dmaven2.jpp.depmap.file=%{SOURCE1} \
        -Dmaven.repo.local=$MAVEN_REPO_LOCAL \
        -Dmaven.test.failure.ignore=true \
        -Dmaven2.jpp.signed \
        -PAS7
%endif

%install
## On RHEL-6 the signed JARs are on a different place
#export JPP_SIGNED=2

# jar
install -d -m 755 $RPM_BUILD_ROOT%{_javadir}
%if %without mead
install -p -m 644 target/%{jarname}-%{namedversion}.jar \
           $RPM_BUILD_ROOT%{_javadir}/%{jarname}-%{version}.jar
install -p -m 644 target/%{jarname}-%{namedversion}-sources.jar \
           $RPM_BUILD_ROOT%{_javadir}/%{jarname}-%{version}-sources.jar
%else
pushd %{_sourcedir}
for i in `ls *-%{rhnamedversion}.*ar`; do 
    cp -p $i $RPM_BUILD_ROOT%{_javadir}/`echo $i|sed -s "s/-%{rhnamedversion}//"`
done
popd
%endif

# pom
install -d -m 755 $RPM_BUILD_ROOT%{_datadir}/maven2/poms
%if %without mead
install -m 644 pom.xml $RPM_BUILD_ROOT%{_datadir}/maven2/poms/JPP-%{jarname}.pom
%add_to_maven_depmap org.jboss.native %{jarname} %{namedversion} JPP %{jarname}
%else
pushd %{_sourcedir}
for i in `ls *-%{rhnamedversion}.pom`; do 
    name=`echo $i|sed -s "s/-%{rhnamedversion}//"`
    cp -p $i $RPM_BUILD_ROOT%{_mavenpomdir}/JPP-$name
    %add_to_maven_depmap org.jboss.mod_cluster $name %{rhnamedversion} JPP $name
done
popd
%endif

%if %without mead
# sar
install -d -m 755 $RPM_BUILD_ROOT%{_javadir}/%{jarname}.sar
cp -pR target/mod-cluster.sar/* $RPM_BUILD_ROOT%{_javadir}/%{jarname}.sar

rm $RPM_BUILD_ROOT%{_javadir}/%{jarname}.sar/%{jarname}-%{namedversion}.jar
(cd $RPM_BUILD_ROOT%{_javadir}/%{jarname}.sar; ln -s %{_javadir}/%{jarname}.jar %{jarname}-%{namedversion}.jar)
(cd $RPM_BUILD_ROOT%{_javadir} && for jar in *-%{version}*; do ln -s ${jar} ${jar/-%{version}/}; done)

# JBossWeb / Tomcat
install -d -m 755 $RPM_BUILD_ROOT%{_javadir}/jbossweb2/lib
install -d -m 755 $RPM_BUILD_ROOT%{_javadir}/tomcat6/lib
for i in jbossweb2 tomcat6
do
pushd $RPM_BUILD_ROOT%{_javadir}/$i/lib
ln -s $(build-classpath jboss-logging-jdk)
ln -s $(build-classpath jboss-logging-spi)
ln -s %{_javadir}/mod-cluster.jar .
popd
done

# demo
install -d -m 755 $RPM_BUILD_ROOT%{_datadir}/%{name}-%{version}
rm -f target/demo/client/lib/jcommon.jar target/demo/client/lib/jfreechart.jar
build-jar-repository -s -p target/demo/client/lib \
jcommon \
jfreechart
rm -Rf target/demo/classes
(cd target/demo/server
mkdir load-demo.war.dir
pushd load-demo.war.dir
jar xf ../load-demo.war 
pushd WEB-INF/lib/
rm commons-codec.jar commons-httpclient.jar
ln -s $(build-classpath commons-codec)
ln -s $(build-classpath commons-httpclient)
popd
popd
rm load-demo.war
mv load-demo.war.dir load-demo.war)
cp -pR target/demo $RPM_BUILD_ROOT%{_datadir}/%{name}-%{version}

# docs
install -dm 755 $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}
cp -p JBossORG-EULA.txt $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}
cp -p lgpl.txt $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}
cp -p README.txt $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}
cp -p release.txt $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}

# src zip
install -dm 755 $RPM_BUILD_ROOT%{_javadir}/jbossas-fordev/
cp -pR ../%{name}-%{namedversion}-src.zip $RPM_BUILD_ROOT%{_javadir}/jbossas-fordev/

# zip
mkdir -p tmp/zip
cd tmp/zip
tar xzf ../../target/mod-cluster-%{namedversion}-bin.tar.gz
cp -pR ../../target/mod-cluster.sar/* mod-cluster.sar
install -p -m 644 ../../target/%{jarname}-%{namedversion}.jar \
           %{jarname}.sar/%{jarname}-%{namedversion}.jar
zip -r ../../target/%{name}-%{namedversion}.zip *
cd ../../
rm -Rf target/mod-cluster-%{namedversion}-bin.tar.gz
cp -pR target/%{name}-%{namedversion}.zip $RPM_BUILD_ROOT%{_javadir}/jbossas-fordev/

rm -Rf tmp

# repolib
%if %{with_repolib}
	tag=`echo %{version}-brew`
	sed -i "s/@VERSION@/$tag/g" %{SOURCE2}
	tag=`echo %{name}-%{version}-%{release} | sed 's|\.|_|g'`
	sed -i "s/@TAG@/$tag/g" %{SOURCE2}
        install -d -m 755 $RPM_BUILD_ROOT%{repodir}
        install -d -m 755 $RPM_BUILD_ROOT%{repodirlib}
        install -m 755 %{SOURCE2} $RPM_BUILD_ROOT%{repodir}/component-info.xml
        install -d -m 755 $RPM_BUILD_ROOT%{repodirsrc}
        install -m 755 %{SOURCE0} $RPM_BUILD_ROOT%{repodirsrc}
        install -m 755 %{SOURCE1} $RPM_BUILD_ROOT%{repodirsrc}
        cp -p pom.xml $RPM_BUILD_ROOT%{repodirlib}/%{jarname}.pom
        cp -p $RPM_BUILD_ROOT%{_javadir}/%{jarname}.jar $RPM_BUILD_ROOT%{repodirlib}
        cp -p $RPM_BUILD_ROOT%{_javadir}/%{jarname}-sources.jar $RPM_BUILD_ROOT%{repodirlib}
        install -m 755 %{SOURCE3} $RPM_BUILD_ROOT%{repodir}/upload.sh
        pushd $RPM_BUILD_ROOT%{repodir}
        ./upload.sh $RPM_BUILD_ROOT/usr/share/java/repository.jboss.com/maven2-brew/
        popd
%endif
%endif

#for links needed in tomcat6/7
install -dm 755 $RPM_BUILD_ROOT%{_datadir}/tomcat{6,7}/lib
pushd $RPM_BUILD_ROOT%{_datadir}/tomcat6/lib
ln -s %{_javadir}/jboss-logging.jar .
ln -s %{_javadir}/mod_cluster-core.jar .
ln -s %{_javadir}/mod_cluster-container-catalina.jar .
ln -s %{_javadir}/mod_cluster-container-catalina-standalone.jar .
ln -s %{_javadir}/mod_cluster-container-tomcat6.jar .
ln -s %{_javadir}/mod_cluster-container-spi.jar .
popd
pushd $RPM_BUILD_ROOT%{_datadir}/tomcat7/lib
ln -s %{_javadir}/jboss-logging.jar .
ln -s %{_javadir}/mod_cluster-core.jar .
ln -s %{_javadir}/mod_cluster-container-catalina.jar .
ln -s %{_javadir}/mod_cluster-container-catalina-standalone.jar .
ln -s %{_javadir}/mod_cluster-container-tomcat7.jar .
ln -s %{_javadir}/mod_cluster-container-spi.jar .
popd

install -d -m 755 $RPM_BUILD_ROOT%{_javadir}/jbossas-fordev/
cp -p %{_sourcedir}/org.jboss.mod_cluster-mod_cluster-parent-%{rhnamedversion}-sources.zip $RPM_BUILD_ROOT%{_javadir}/jbossas-fordev/%{name}-%{namedversion}-src.zip
cp -p %{_sourcedir}/org.jboss.mod_cluster-mod_cluster-parent-%{rhnamedversion}-patches.zip $RPM_BUILD_ROOT%{_javadir}/jbossas-fordev/%{name}-%{namedversion}-patches.zip

%clean
rm -Rf $RPM_BUILD_ROOT

%post
%update_maven_depmap

%postun
%update_maven_depmap

%files
%defattr(0644,root,root,0755)
%{_javadir}*/*jar
%exclude %{_javadir}*/*demo*ar
%{_datadir}/maven2/poms/*
%exclude %{_datadir}/maven2/poms/*demo*
%{_mavendepmapfragdir}/*

%files demo
%defattr(0644,root,root,0755)
%{_javadir}*/*demo*ar
%{_datadir}/maven2/poms/*demo*

%files tomcat6
%defattr(0644,root,root,0755)
%{_datadir}/tomcat6/lib/*

%files tomcat7
%defattr(0644,root,root,0755)
%{_datadir}/tomcat7/lib/*

%files src-zip
%defattr(0644,root,root,0755)
%{_javadir}*/jbossas-fordev/%{name}-%{namedversion}-src.zip
%{_javadir}*/jbossas-fordev/%{name}-%{namedversion}-patches.zip

%if %without mead
%files jbossweb2
%defattr(0644,root,root,0755)
%{_javadir}*/jbossweb2/*

%files zip
%defattr(0644,root,root,0755)
%{_javadir}*/jbossas-fordev/%{name}-%{namedversion}.zip

%if %with repolib
%files repolib
%defattr(0644,root,root,0755)
%{_javadir}*/repository.jboss.com
%endif
%endif

%changelog
* Thu Oct 18 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.3-1.Final_redhat_1
- 1.2.3.Final, remove patches as they are all incorporated in the tag

* Fri Oct 12 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.2-5.Final_redhat_3
- Add patch for JBPAPP-10168, redhat-3 build

* Fri Oct 05 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.2-4.Final_redhat_2
- Add patch for JBPAPP-9788, redhat-2 build

* Wed Sep 19 2012 Fernando Nasser <fnasser@redhat.com> - 0:1.2.2-3.Final_redhat_1
- Rebuild for MD5

* Mon Sep 17 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.2-2.Final_redhat_1
- Obsoletes and Provides for the -jbossas subpackage in main package

* Thu Sep 13 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.2-1.2.Final_redhat_1
- Include patches zip from MEAD for src-zip subpackage

* Thu Sep 13 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.2-1.1.Final_redhat_1
- Include source zip from MEAD for src-zip subpackage

* Tue Sep 11 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.2-1.Final_redhat_1
- 1.2.2.Final-redhat-1

* Thu Aug 30 2012 Vladimir Dosoudil <dosoudil@redhat.com> - 0:1.2.1-11.Final_redhat_2.2
- Add jbossweb 2.1.11.GA to local dependency management

* Wed Aug 29 2012 Vladimir Dosoudil <dosoudil@redhat.com> - 0:1.2.1-11.Final_redhat_2.1
- Remove dependency management, use eap bom
- Update poms for eap 6.0.1 boms and parent pom

* Thu Aug 16 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.1-10.Final_redhat_2
- Fix Release: tag

* Tue Aug 14 2012 Fernando Nasser <fnasser@redhat.com> - 0:1.2.1-10.Final.4
- Rebuild unsigned

* Thu Aug 09 2012 Fernando Nasser <fnasser@redhat.com> - 0:1.2.1-10.Final.3
- Rebuild unsigned

* Tue Jul 17 2012 Fernando Nasser <fnasser@redhat.com> - 0:1.2.1-10.Final.2
- Rebuild using cache signing

* Thu Jul 12 2012 Fernando Nasser <fnasser@redhat.com> - 0:1.2.1-10.Final.1
- Rebuild using cache signing

* Wed Jul 04 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.1-10.Final
- Fix links in -tomcat subpackages

* Wed Jul 04 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.1-9.Final
- Fix files in -tomcat subpackages to avoid conflicting with tomcat

* Tue Jul 03 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.1-8.Final
- Fix links in -tomcat subpackages

* Wed May 09 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.1-7.Final
- 1.2.1.Final

* Wed May 02 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.1-5.Beta2
- Fix -tomcat6,7 subpackages

* Wed May 02 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.1-5.Beta2
- Add -tomcat6,7 subpackages

* Mon Apr 30 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.1-4.Beta2
- Build container-catalina-standalone

* Fri Apr 27 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.1-3.Beta2
- Build with TC7 profile

* Thu Apr 27 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.1-2.Beta2
- Build with TC6 profile

* Tue Apr 10 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.1-1.Beta2.1
- 1.2.1.Beta2

* Wed Mar 28 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.1-0.Beta1.2
- Fix install path

* Mon Mar 26 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.1-0.Beta1.1
- 1.2.1.Beta1

* Mon Feb 29 2012 Fernando Nasser <fnasser@redhat.com> - 0:1.2.0-6.Final.2
- Populate java-signed

* Mon Feb 13 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.0-6.Final
- 1.2.0.Final

* Tue Feb 07 2012 Red Hat Release Engineering <release-engineering@redhat.com> - 0:1.2.0-5.Beta4.1
- Rebuild to use new signing key

* Tue Jan 31 2012 Fernando Nasser <fnasser@redhat.com> - 0:1.2.0-4.Beta4.1
- Real wrapper build

* Tue Jan 31 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.0-4.Beta4
- 1.2.0.Beta4

* Fri Jan 27 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.0-3.Beta3
- Fix pom name and include demo war in demo subpackage

* Fri Jan 27 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.0-2.Beta3
- Create wrapper

* Tue Jan 03 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.2.0-1.Beta3
- 1.2.0.Beta3

* Fri Sep 23 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.1.3-1.Final
- 1.1.3.Final

* Fri Jun 10 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.10-2.2.GA_CP01
- Upgrade to 1.0.10.GA_CP01

* Mon May 02 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.10-1.2
- Fix zip

* Mon Apr 18 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.10-1.1
- Upgrade to 1.0.10.GA

* Mon Apr 04 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.9-1.2
- Default to use signed jars

* Fri Mar 18 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.9-1.1
- Upgrade to 1.0.9.GA

* Thu Feb 17 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.8-2.1
- Fix Release tag

* Wed Feb 16 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.8-1.1
- Upgrade to 1.0.8.GA

* Fri Jan 07 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.6-1.1
- Upgrade to 1.0.6.GA

* Wed Nov 24 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.5-1.1
- Upgrade to 1.0.5.GA

* Tue Nov 23 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.4-2.2
- Add pom, upload.sh and content of maven2-brew to repolib
- Fix %%files for signed jars
- Fix License tag
- Build with signed jars

* Fri Aug 20 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.4-2.1
- Fix typo

* Wed Jul 28 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.4-1.1
- Upgrade to 1.0.4.GA
- Remove patches that are already incorporated in the tag

* Fri Jun 18 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.3-9.1
- Add -sources jar

* Thu May 27 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.3-8
- Add patches to repolib

* Tue May 25 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.3-7.1
- Split up mod_cluster into mod_cluster and mod_cluster-native

* Tue May 25 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.3-6.1
- Add patch for JBPAPP-3936, 4046, 4307
- Adjust depmap

* Mon May 17 2010 Martha Benitez <mbenitez@redhat.com> - 0:1.0.3-3.3.1
- rebuilt

* Mon Apr 19 2010 Yiqiao Wang <yiwang@redhat.com> - 0:1.0.3-3.3
- Rebuild

* Thu Apr 01 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.3-3.2
- Build with jars
- Revert the changes to work with httpd instead of httpd22

* Tue Feb 09 2010 Yiqiao Wang <yiwang@redhat.com> - 0:1.0.3-3.1
- Merge with RHEL-4

* Mon Jan 25 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.3-2.1
- Rebuild

* Mon Jan 18 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.3-1
- Upgrade to 1.0.3
- Merge with RHEL-4-EP-5 branch

* Fri Nov 06 2009 Permaine Cheung <pcheung@redhat.com> - 0:1.0.2-5.1
- Do not build jars as we don't have all the dependencies on RHEL 5

* Thu Nov 05 2009 Permaine Cheung <pcheung@redhat.com> - 0:1.0.2-5
- Fix location of zip

* Thu Nov 05 2009 Permaine Cheung <pcheung@redhat.com> - 0:1.0.2-4
- Fix Requires:

* Thu Nov 05 2009 Permaine Cheung <pcheung@redhat.com> - 0:1.0.2-3
- Build native .so for httpd and put them in the main package
- Rename the package that includes jars and sar for jbossas to -jbossas
- Add load-demo.war back in demo/server
- Add .so to zip
- Add src-zip

* Mon Nov 02 2009 Martha Benitez <mbenitez@redhat.com> - 0:1.0.2-2
- Add license and release notes to the main package
- Remove .dir extension from sar directory name
- Add mod_cluster.jar to sar directory
- Change sub-package names to jbossweb2 and tomcat6 to clarify versions
- Explode contents of load-demo.war inside server subdirectory in the demo sub-package

* Tue Sep 15 2009 Martha Benitez <mbenitez@redhat.com> - 0:1.0.2-1
- Brew build
- Relax version for httpd-devel
