/*
 * This file implements the RTP-MIB module.
 * $Id: rtp-mib.c 8676 2008-01-17 23:11:17Z ispringer $
 */
/* General includes */
#include <sys/types.h>

#ifdef WIN32
/* Apache includes */
#include <httpd.h>
#include <http_log.h>
#include <apr_hash.h>
#include <apr_optional.h>
#endif

/* SNMP includes */
#include <ucd-snmp-config.h>
#include "asn1.h"
#include <snmp.h>
#include <snmp_api.h>
#include <snmp_debug.h>
#include <snmp_vars.h>


#include "covalent-snmp-config.h"
#include "rtp-mib/rtp-mib.h"

#ifdef RTP_MIB
void init_rtp_mib(void)
{
#ifdef RTP_SESSION_GROUP
   init_rtp_session_group();
#endif /* RTP_SESSION_GROUP */
#ifdef RTP_SENDER_GROUP
   init_rtp_sender_group();
#endif /* RTP_SESSION_GROUP */
#ifdef RTP_SENDER_GROUP
   init_rtp_receiver_group();
#endif /* RTP_RECEIVER_GROUP */
}
#endif /* RTP_MIB */
