 
/* $Id: subagt-main.c 8676 2008-01-17 23:11:17Z ispringer $ */
/* General includes */
#include <sys/types.h>
#include <signal.h>
#include <sys/socket.h>
 
/* Apache includes */
#include "httpd.h"
#include "http_conf_globals.h"
#include "http_config.h"
#include "http_core.h"
#include "http_log.h"

/* SNMP includes */
#include "ucd-snmp-config.h"
#include "asn1.h"
#include "snmp.h"
#include "snmp_api.h"
#include "snmp_vars.h"
#include "default_store.h"
#include "ds_agent.h"
#include "snmp_debug.h"

#include "covalent-snmp-config.h"
#include "ietf-mibs/snmp-generic.h"
#include "covalent-snmp-logging.h"
#include "covalent-snmp.h"
#include "covalent-snmp-sconfig.h"
#include "apache-restarts.h"
#include "logging.h"
#include "application-mib-modules.h"

/* Is really define somewhere in a library */
extern int errno;
extern server_rec *www_services;

int logpath_fd[2]; /* The 2 file descriptors for the pipe */
extern covalent_snmp_logpath_t logpath;

void covalent_snmp_shutdown(int signal)
{
    snmp_shutdown("subagt");
    exit(0);  
}


void
covalent_snmp_main(server_rec *s, pool *p)
{
int count;
int numfds;
fd_set fdset;
struct timeval timeout, *tvp;
int block;
pid_t snmpagent_pid;
char *confdir;
char *persdir;
#ifdef EVAL_VERSION
struct timeval now;
#endif

    snmpagent_pid = fork();
    if (snmpagent_pid == -1) { /* Fork error */
	ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_ERR, s,
					"SNMP: unable to fork agent");
    } else if (snmpagent_pid > 0) { 
        ap_note_subprocess(p, snmpagent_pid, kill_never);
	return;
    }

    /* SNMP uses its own (module internal) global variable for this. */
    www_services = s;
    confdir = ds_get_string(DS_LIBRARY_ID, DS_LIB_CONFIGURATION_DIR);
    if (confdir == NULL) {
	confdir = ap_server_root_relative(p, COVALENT_SNMP_CONFIGURATION_DIR);
	ds_set_string(DS_LIBRARY_ID, DS_LIB_CONFIGURATION_DIR, strdup(confdir));
    }
    persdir = ds_get_string(DS_LIBRARY_ID, DS_LIB_PERSISTENT_DIR);
    if (persdir == NULL) {
	persdir = ap_server_root_relative(p, COVALENT_SNMP_PERSISTENT_DIR);
	ds_set_string(DS_LIBRARY_ID, DS_LIB_PERSISTENT_DIR, strdup(persdir));
    }
    setenv( "MIBS", "", 1 );

    /* do what we need to do first. */
    ds_set_boolean(DS_APPLICATION_ID, DS_AGENT_ROLE, 1);
    init_agent("subagt");
    /* register/initialize the MIB modules */
    /* application MIB modules */
    init_application_mib_modules(s, p, persdir);

    /* start library */
    init_snmp("subagt");

#ifdef SIGKILL
    signal(SIGKILL, covalent_snmp_shutdown);
#endif

#ifdef SIGTERM
    signal(SIGTERM, covalent_snmp_shutdown);
#endif

#ifdef EVAL_VERSION
    ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_NOTICE, s,
                    "SNMP: This is an evaluation version. Waiting 10 seconds to start.");
    sleep(10);
#endif
    
    while(1){
#ifdef EVAL_VERSION
        gettimeofday(&now, NULL);
	if (timeval_uptime(&now) > EVAL_MAX_SYSUPTIME) {
	    ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_EMERG, s,
                    "SNMP: Evaluation version. Maximum sysUpTime reached (exiting).");
	    exit(-1);
	}
#endif
	tvp =  &timeout;
        tvp->tv_sec = 0;
        tvp->tv_usec = 500000L;

        numfds = logpath.socket+1;
        FD_ZERO(&fdset);
	block = 1;
	snmp_select_info(&numfds, &fdset, tvp, &block);
        FD_SET(logpath.socket, &fdset);

	if (block == 1) {
	    tvp = NULL;
	}

        count = select(numfds, &fdset, 0, 0, tvp);
        if (count > 0){
            snmp_read(&fdset);
            if (FD_ISSET(logpath.socket, &fdset)) {
		snmp_generic_log_sink(logpath.socket);
	    }
        } else switch(count){
            case 0:
                break;
            case -1:
                if (errno == EINTR) {
		    continue;
                } else {
		    ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_NOTICE, s,
				"SNMP: select error '%s'\n", strerror(errno));
                }
            default:
		ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_NOTICE, s,
                		"SNMP: select returned %d\n", count);
        }
    }
}

