/* $Date: 2008-01-18 07:11:17 +0800 (Fri, 18 Jan 2008) $ $Id: www-mib-document.h 8676 2008-01-17 23:11:17Z ispringer $ harrie@covalent.net
 */
#ifndef	__WWW_MIB_DOCUMENT_H__
#define	__WWW_MIB_DOCUMENT_H__

#ifndef MAX_WWWDOCNAME
#define MAX_WWWDOCNAME MAX_DISPLAYSTRING
#endif

#ifndef MAX_WWWDOCLASTNSTATUSMSG
#define MAX_WWWDOCLASTNSTATUSMSG MAX_DISPLAYSTRING
#endif

#ifndef DEFAULT_WWWDOCLASTNSIZE
#define DEFAULT_WWWDOCLASTNSIZE                 25
#endif

#ifndef MAX_WWWDOCLASTNSIZE
#define MAX_WWWDOCLASTNSIZE                     DEFAULT_WWWDOCLASTNSIZE
#endif

#ifndef DEFAULT_WWWDOCBUCKETTIMEINTERVAL
#define DEFAULT_WWWDOCBUCKETTIMEINTERVAL        900 /* in seconds */
#endif

#ifndef DEFAULT_WWWDOCBUCKETS
#define DEFAULT_WWWDOCBUCKETS                   2
#endif

#ifndef MAX_WWWDOCBUCKETS
#define MAX_WWWDOCBUCKETS                       DEFAULT_WWWDOCBUCKETS
#endif

#ifndef DEFAULT_WWWDOCTOPNSIZE
#define DEFAULT_WWWDOCTOPNSIZE        25
#endif

#ifndef MAX_WWWDOCTOPNSIZE
#define MAX_WWWDOCTOPNSIZE            DEFAULT_WWWDOCTOPNSIZE
#endif


/* columnar objects of the wwwDocCtrlEntry */
#define	WWWDOCCTRLNSIZE                   1
#define	WWWDOCCTRLNLOCK                   2
#define	WWWDOCCTRLBUCKETS                 3
#define	WWWDOCCTRLBUCKETSTIMEINTERVAL     4
#define	WWWDOCCTRLTOPNSIZE                5

/* columnar objects of the wwwDocLastNEntry */
#define	WWWDOCLASTNNAME                   2
#define	WWWDOCLASTNTIMESTAMP              3
#define	WWWDOCLASTNREQUESTTYPE            4
#define	WWWDOCLASTNRESPONSETYPE           5
#define	WWWDOCLASTNSTATUSMSG              6
#define	WWWDOCLASTNBYTES                  7

/* columnar objects of the wwwDocBucketEntry */
#define	WWWDOCBUCKETTIMESTAMP             2
#define	WWWDOCBUCKETACCESSES              3
#define	WWWDOCBUCKETDOCUMENTS             4
#define	WWWDOCBUCKETBYTES                 5

/* columnar objects of the wwwDocAccessTopNEntry */
#define	WWWDOCACCESSTOPNNAME              2
#define	WWWDOCACCESSTOPNACCESSES          3
#define	WWWDOCACCESSTOPNBYTES             4
#define	WWWDOCACCESSTOPNLASTRESPONSETYPE  5

/* columnar objects of the wwwDocBytesTopNEntry */
#define	WWWDOCBYTESTOPNNAME               2
#define	WWWDOCBYTESTOPNACCESSES           3
#define	WWWDOCBYTESTOPNBYTES              4
#define	WWWDOCBYTESTOPNLASTNRESPONSETYPE  5



/* Here we define for the various systems the DBM-system to be used. */
#ifdef HAVE_DB_185_H
#include <db_185.h>
#define DB_TYPE         DB*
#define RECORD_INSERT   0
#define RECORD_REPLACE  0
#define FIRST_RECORD    R_FIRST
#define NEXT_RECORD     R_NEXT
#elif HAVE_DB_H
#include <db.h>
#define DB_TYPE         DB*
#define RECORD_INSERT   0
#define RECORD_REPLACE  0
#define FIRST_RECORD    R_FIRST
#define NEXT_RECORD     R_NEXT
#elif HAVE_NDBM_H
#include <ndbm.h>
#define USE_NDBM_BUCKET
#define DB_TYPE         DBM*
#define RECORD_INSERT   DBM_INSERT
#define RECORD_REPLACE  DBM_REPLACE
#define FIRST_RECORD    0
#define NEXT_RECORD     1
#elif BUCKETTYPE_IS_SDBM
#include <covalent_sdbm.h>
#define USE_NDBM_BUCKET
#define DB_TYPE         DBM*
#define RECORD_INSERT   0
#define RECORD_REPLACE  1
#define FIRST_RECORD    0
#define NEXT_RECORD     1
#endif


typedef struct {
    char name[ MAX_WWWDOCNAME ];
    apr_time_t timestamp;
    int requestType;
    int responseType;
#ifndef NO_WWW_DOCUMENTS_GROUP
    char statusMsg[ MAX_WWWDOCLASTNSTATUSMSG ];
    unsigned long bytes;
#endif /* NO_WWW_DOCUMENTS_GROUP */
} wwwDocLastN_t;

typedef struct {
    char  name[ MAX_WWWDOCNAME ];
    unsigned long  accesses;
    unsigned long  bytes;
    int lastResponseType;
} wwwDocTopN_t;

typedef struct {
    apr_time_t timestamp;
    unsigned long accesses;
    unsigned long documents;
    unsigned long bytes;
    wwwDocTopN_t accessTopNTable[ MAX_WWWDOCTOPNSIZE ];
    wwwDocTopN_t bytesTopNTable[ MAX_WWWDOCTOPNSIZE ];
} wwwDocBucket_t;

typedef struct {
    www_protocol_t *protocol;
    unsigned long wwwDocCtrlLastNSize;
    unsigned long temp_wwwDocCtrlLastNSize;
    unsigned long wwwDocCtrlLastNLock;
    unsigned long temp_wwwDocCtrlLastNLock;
    unsigned long wwwDocCtrlBuckets;
    unsigned long temp_wwwDocCtrlBuckets;
    unsigned long wwwDocCtrlBucketTimeInterval;
    unsigned long temp_wwwDocCtrlBucketTimeInterval;
    unsigned long wwwDocCtrlTopNSize;
    unsigned long temp_wwwDocCtrlTopNSize;
    /* wwwDocLastNtable */
    wwwDocLastN_t wwwDocLastNTable[ MAX_WWWDOCLASTNSIZE ];
    unsigned long wwwDocLastNIndex;
    /* wwwDocBucketTables */
    wwwDocBucket_t wwwDocBucketTable[ MAX_WWWDOCBUCKETS ];
    unsigned long wwwDocBucketIndex;
    DB_TYPE wwwDocBucket;
    char *wwwDocBucketName;
} wwwDocStatistics_t;

DB_TYPE covalent_snmp_wwwDocBucket_open(char *name);
void covalent_snmp_wwwDocBucket_close(DB_TYPE wwwdocbucket);
int covalent_snmp_wwwDocBucket_store(DB_TYPE wwwdocbucket, char *keystr, wwwDocTopN_t *record, int action);
wwwDocTopN_t *covalent_snmp_wwwDocBucket_fetch(DB_TYPE wwwdocbucket, char *keystr);
wwwDocTopN_t *covalent_snmp_wwwDocBucket_seqfetch(DB_TYPE wwwdocbucket, int action);
const char *covalent_snmp_get_wwwDocBucket_strerror(void);
int covalent_snmp_get_wwwDocBucket_errno(void);
const char *update_www_mib_document_statistics(unsigned int wwwServiceIndex,
                                   unsigned int wwwProtocol,
                                   apr_time_t wwwRequestTime,
                                   unsigned long wwwRequestInType,
                                   unsigned long wwwBytesIn,
                                   unsigned long wwwResponseOutType,
                                   unsigned long wwwBytesOut,
                                   char *wwwDocName,
                                   char *wwwStatusMsg);
void init_www_mib_documents(apr_pool_t *p, const char *bucket_directory);


#endif /* __WWW_MIB_DOCUMENT_H__ */
