/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.collections;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.tomcat.dbcp.collections.SequencedHashMap;

public class LRUMap
extends SequencedHashMap
implements Externalizable {
    private int maximumSize = 0;
    private static final long serialVersionUID = 2197433140769957051L;

    public LRUMap() {
        this(100);
    }

    public LRUMap(int n) {
        super(n);
        this.maximumSize = n;
    }

    @Override
    public Object get(Object object) {
        if (!this.containsKey(object)) {
            return null;
        }
        Object object2 = this.remove(object);
        super.put(object, object2);
        return object2;
    }

    @Override
    public Object put(Object object, Object object2) {
        int n = this.size();
        Object object3 = null;
        if (n >= this.maximumSize && !this.containsKey(object)) {
            this.removeLRU();
        }
        object3 = super.put(object, object2);
        return object3;
    }

    protected void removeLRU() {
        Object object = this.getFirstKey();
        Object object2 = super.get(object);
        this.remove(object);
        this.processRemovedLRU(object, object2);
    }

    protected void processRemovedLRU(Object object, Object object2) {
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.maximumSize = objectInput.readInt();
        int n = objectInput.readInt();
        for (int i = 0; i < n; ++i) {
            Object object = objectInput.readObject();
            Object object2 = objectInput.readObject();
            this.put(object, object2);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.maximumSize);
        objectOutput.writeInt(this.size());
        for (Object e : this.keySet()) {
            objectOutput.writeObject(e);
            Object object = super.get(e);
            objectOutput.writeObject(object);
        }
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int n) {
        this.maximumSize = n;
        while (this.size() > n) {
            this.removeLRU();
        }
    }
}

