<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1494953 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="apxs.xml.meta">
<parentdocument href="./">Programmes</parentdocument>

<title>apxs - Utilitaire pour les extensions d'Apache</title>

<summary>
    <p><code>apxs</code> est un utilitaire permettant de compiler et
    d'installer des modules en tant qu'extensions du serveur HTTP
    Apache. A cet effet, un objet dynamique partag&eacute; (DSO) est compil&eacute; &agrave;
    partir d'un ou plusieurs <var>fichiers</var> sources ou objets et
    peut &ecirc;tre charg&eacute; pendant l'ex&eacute;cution du serveur Apache via la
    directive <directive module="mod_so">LoadModule</directive> du
    module <module>mod_so</module>.</p>

    <p>Pour pouvoir utiliser ce m&eacute;canisme d'extensions, votre
    plate-forme doit supporter la fonctionnalit&eacute; DSO, et votre binaire
    <program>httpd</program> Apache doit &ecirc;tre compil&eacute; avec le module
    <module>mod_so</module>. Si ce n'est pas le cas, l'utilitaire
    <code>apxs</code> vous le signalera. Vous pouvez aussi v&eacute;rifier
    vous-m&ecirc;me ces pr&eacute;requis en ex&eacute;cutant manuellement la commande :</p>

    <example>
      $ httpd -l
    </example>

    <p>Le module <module>mod_so</module> doit faire partie de la liste
    des modules affich&eacute;e. Si ces pr&eacute;requis sont pr&eacute;sents, vous pouvez
    facilement &eacute;tendre les fonctionnalit&eacute;s de votre serveur Apache en
    installant vos propres modules &agrave; l'aide de l'utilitaire
    <code>apxs</code>, via le m&eacute;canisme DSO :</p>

    <example>
      $ apxs -i -a -c mod_foo.c<br />
      gcc -fpic -DSHARED_MODULE -I/chemin/vers/apache/include -c mod_foo.c<br />
      ld -Bshareable -o mod_foo.so mod_foo.o<br />
      cp mod_foo.so /chemin/vers/apache/modules/mod_foo.so<br />
      chmod 755 /chemin/vers/apache/modules/mod_foo.so<br />
      [activation du module `foo' dans /chemin/vers/apache/etc/httpd.conf]<br />
      $ apachectl restart<br />
      /chemin/vers/apache/sbin/apachectl restart: httpd not running, trying to start<br />
      [Tue Mar 31 11:27:55 1998] [debug] mod_so.c(303): loaded module foo_module<br />
      /chemin/vers/apache/sbin/apachectl restart: httpd started<br />
      $ _
    </example>

    <p>Les arguments <var>fichiers</var> peuvent correspondre &agrave; un
    fichier source C (.c), un fichier objet (.o) ou m&ecirc;me une archive de
    biblioth&egrave;ques (.a). L'utilitaire <code>apxs</code> reconna&icirc;t
    automatiquement ces extensions et utilise automatiquement les
    fichiers source C pour la compilation, et les fichiers objets et
    archives pour l'&eacute;dition de liens. Cependant, si vous utilisez des
    fichiers objets pr&eacute;compil&eacute;s, assurez-vous que leur code soit
    ind&eacute;pendant de la position (PIC), afin de pouvoir les utiliser avec
    un objet partag&eacute; charg&eacute; dynamiquement. Avec GCC, par exemple, il
    vous suffit de toujours utiliser l'option de compilation
    <code>-fpic</code>. Pour les autres compilateurs C, consultez leur
    page de manuel, ou v&eacute;rifiez les drapeaux qu'<code>apxs</code>
    utilise pour compiler les fichiers objets.</p>

    <p>Pour plus de d&eacute;tails &agrave; propos du support DSO dans Apache, lire la
    documentation du module <module>mod_so</module>, ou m&ecirc;me, consultez
    le fichier source <code>src/modules/standard/mod_so.c</code>.</p>
</summary>
<seealso><program>apachectl</program></seealso>
<seealso><program>httpd</program></seealso>

<section id="synopsis"><title>Syntaxe</title>
    <p><code><strong>apxs</strong> -<strong>g</strong>
    [ -<strong>S</strong> <var>nom</var>=<var>valeur</var> ]
    -<strong>n</strong> <var>nom-module</var></code></p>

    <p><code><strong>apxs</strong> -<strong>q</strong>
    [ -<strong>v</strong> ]
    [ -<strong>S</strong> <var>nom</var>=<var>valeur</var> ]
    <var>requ&ecirc;te</var> ...</code></p>

    <p><code><strong>apxs</strong> -<strong>c</strong>
    [ -<strong>S</strong> <var>nom</var>=<var>valeur</var> ]
    [ -<strong>o</strong> <var>fichier-dso</var> ]
    [ -<strong>I</strong> <var>r&eacute;pertoire-inc</var> ]
    [ -<strong>D</strong> <var>nom</var>=<var>valeur</var> ]
    [ -<strong>L</strong> <var>r&eacute;pertoire-lib</var> ]
    [ -<strong>l</strong> <var>nom-biblioth&egrave;que</var> ]
    [ -<strong>Wc,</strong><var>options-compilation</var> ]
    [ -<strong>Wl,</strong><var>options-edition-liens</var> ]
    <var>fichiers</var> ...</code></p>

    <p><code><strong>apxs</strong> -<strong>i</strong>
    [ -<strong>S</strong> <var>nom</var>=<var>valeur</var> ]
    [ -<strong>n</strong> <var>nom-module</var> ]
    [ -<strong>a</strong> ]
    [ -<strong>A</strong> ]
    <var>fichier-dso</var> ...</code></p>

    <p><code><strong>apxs</strong> -<strong>e</strong>
    [ -<strong>S</strong> <var>nom</var>=<var>valeur</var> ]
    [ -<strong>n</strong> <var>nom-module</var> ]
    [ -<strong>a</strong> ]
    [ -<strong>A</strong> ]
    <var>fichier-dso</var> ...</code></p>
</section>

<section id="options"><title>Options</title>
    <section id="options.common"><title>Options courantes</title>
      <dl>
      <dt><code>-n <var>nom-module</var></code></dt>
      <dd>D&eacute;finit explicitement le nom du module pour les options
      <code>-i</code> (install) et <code>-g</code> (g&eacute;n&eacute;ration de
      mod&egrave;les). Utilisez cette option pour sp&eacute;cifier de mani&egrave;re
      explicite le nom du module. Pour l'option <code>-g</code>, cette
      option est n&eacute;cessaire ; pour l'option <code>-i</code>,
      l'utilitaire <code>apxs</code> tente de d&eacute;terminer le nom du
      module &agrave; partir des sources, ou (&agrave; d&eacute;faut) en le d&eacute;duisant du nom
      de fichier.</dd>
      </dl>
    </section>

    <section id="options.query"><title>Options de requ&ecirc;te</title>
      <dl>
      <dt><code>-q</code></dt>
      <dd>Effectue une requ&ecirc;te &agrave; propos des variables et de
      l'environnement utilis&eacute;s pour compiler <code>httpd</code>.
      Lorsqu'elle est invoqu&eacute;e sans param&egrave;tre <var>requ&ecirc;te</var>, cette
      option affiche toutes les variables connues, ainsi que leurs
      valeurs. Le param&egrave;tre optionnel <code>-v</code> formate la liste
      affich&eacute;e.

      <p>Utilisez cette option pour d&eacute;terminer manuellement les options
      utilis&eacute;es pour compiler le binaire <code>httpd</code> qui chargera
      votre module. Ajoutez par exemple</p>
      <example>
        INC=-I`apxs -q INCLUDEDIR`
      </example>

      <p>dans vos propres Makefiles si vous devez acc&eacute;der manuellement
      aux fichiers d'en-t&ecirc;tes C d'Apache.</p></dd>
      </dl>
    </section>

    <section id="options.conf"><title>Options de configuration</title>
      <dl>
      <dt><code>-S <var>nom</var>=<var>valeur</var></code></dt>
      <dd>Cette option permet de modifier la configuration d'apxs
      d&eacute;crite ci-dessus.</dd>
      </dl>
    </section>

    <section id="options.template"><title>Option de g&eacute;n&eacute;ration des
    mod&egrave;les</title>
      <dl>
      <dt><code>-g</code></dt>
      <dd>Cette option permet de g&eacute;n&eacute;rer un sous-r&eacute;pertoire
      <var>nom</var> (voir option <code>-n</code>) contenant deux
      fichiers : le premier fichier est un exemple de fichier source de
      module nomm&eacute; <code>mod_<var>nom</var>.c</code> que l'on peut
      utiliser comme mod&egrave;le pour cr&eacute;er ses propres modules, ou comme
      point de d&eacute;part pour se familiariser avec le m&eacute;canisme apxs ; le
      second fichier est le <code>Makefile</code> correspondant
      facilitant la compilation et l'installation de ce module.</dd>
      </dl>
    </section>
    <section id="options.dso"><title>Options de compilation DSO</title>
      <dl>
      <dt><code>-c</code></dt>
      <dd>Cette option indique une op&eacute;ration de compilation. Tout
      d'abord, les fichiers sources (.c) sp&eacute;cifi&eacute;s par
      <var>fichiers</var> sont compil&eacute;s en fichiers objets
      correspondants (.o), puis un objet dynamiquement partag&eacute;
      <var>fichier-dso</var> est compil&eacute; via une &eacute;dition de liens de ces
      fichiers objets avec les autres fichiers objets (.o and .a)
      sp&eacute;cifi&eacute;s par <var>fichiers</var>. Si l'option <code>-o</code>
      n'est pas sp&eacute;cifi&eacute;e, le nom du fichier r&eacute;sultant est d&eacute;duit du
      premier nom de fichier sp&eacute;cifi&eacute; par <var>fichiers</var>, et ainsi
      prend en g&eacute;n&eacute;ral pour valeur par d&eacute;faut
      <code>mod_<var>nom</var>.so</code>.</dd>

      <dt><code>-o <var>fichier-dso</var></code></dt>
      <dd>Sp&eacute;cifie de mani&egrave;re explicite le nom de fichier de l'objet
      partag&eacute; dynamiquement cr&eacute;&eacute;. Sans cette option, et si le nom ne
      peut pas &ecirc;tre d&eacute;duit de la liste <var>fichiers</var>, c'est le nom
      par d&eacute;faut <code>mod_unknown.so</code> qui sera utilis&eacute;.</dd>

      <dt><code>-D <var>nom</var>=<var>valeur</var></code></dt>
      <dd>Cette option est transmise directement &agrave; la commande de
      compilation. Vous pouvez l'utiliser pour ajouter vos propres
      d&eacute;finitions au processus de compilation. </dd>

      <dt><code>-I <var>r&eacute;pertoire-inc</var></code></dt>
      <dd>Cette option est transmise directement &agrave; la commande de
      compilation. Vous pouvez l'utiliser pour ajouter vos propres
      chemins de recherche des r&eacute;pertoires <code>include</code> au processus de
      compilation.</dd>

      <dt><code>-L <var>r&eacute;pertoire-lib</var></code></dt>
      <dd>Cette option est transmise directement &agrave; la commande d'&eacute;dition
      de liens. Vous pouvez l'utiliser pour ajouter vos propres
      chemins de recherche des r&eacute;pertoires de biblioth&egrave;ques au processus
      de compilation.</dd>

      <dt><code>-l <var>nom-biblioth&egrave;que</var></code></dt>
      <dd>Cette option est transmise directement &agrave; la commande d'&eacute;dition
      de liens. Vous pouvez l'utiliser pour ajouter vos propres
      biblioth&egrave;ques &agrave; rechercher au processus de compilation.</dd>

      <dt><code>-Wc,<var>options-compilation</var></code></dt>
      <dd>Cette option transmet les <var>options-compilation</var> en
      tant qu'options suppl&eacute;mentaires &agrave; la commande <code>libtool
      --mode=compile</code>. Vous pouvez l'utiliser pour ajouter des
      options locales sp&eacute;cifiques au compilateur.</dd>

      <dt><code>-Wl,<var>options-edition-liens</var></code></dt>
      <dd>Cette option transmet les <var>options-edition-liens</var> en
      tant qu'options suppl&eacute;mentaires &agrave; la commande <code>libtool
      --mode=link</code>. Vous pouvez l'utiliser pour ajouter des
      options locales sp&eacute;cifiques &agrave; l'&eacute;diteur de liens.</dd>
      
      <dt><code>-p</code></dt>
      <dd>Avec cette option, apxs effectue l'&eacute;dition de liens avec les
      biblioth&egrave;ques apr/apr-util. Elle permet de compiler les programmes
      helper qui utilisent les biblioth&egrave;ques apr/apr-util.</dd>
      </dl>
    </section>

    <section id="options.dsoinstall">
    <title>Options d'installation et de configuration DSO</title>
      <dl>
      <dt><code>-i</code></dt>
      <dd>Cette option indique une op&eacute;ration d'installation et installe
      un ou plusieurs objets dynamiquement partag&eacute;s dans le r&eacute;pertoire
      <var>modules</var> du serveur.</dd>

      <dt><code>-a</code></dt>
      <dd>Cette option active le module en ajoutant automatiquement une
      directive <directive module="mod_so">LoadModule</directive>
      correspondante au fichier de configuration d'Apache
      <code>httpd.conf</code>, ou en l'activant s'il existe d&eacute;j&agrave;.</dd>

      <dt><code>-A</code></dt>
      <dd>Identique &agrave; l'option <code>-a</code>, &agrave; la diff&eacute;rence que la
      directive <directive module="mod_so">LoadModule</directive> cr&eacute;&eacute;e
      est pr&eacute;fix&eacute;e par un caract&egrave;re di&egrave;se (<code>#</code>) ; le module
      est ainsi pr&eacute;par&eacute; pour une activation ult&eacute;rieure, mais est
      d&eacute;sactiv&eacute; dans un premier temps.</dd>

      <dt><code>-e</code></dt>
      <dd>Cette option indique une op&eacute;ration d'&eacute;dition de liens et peut
      &ecirc;tre utilis&eacute;e avec les options <code>-a</code> et <code>-A</code>
      de la m&ecirc;me mani&egrave;re qu'au cours de l'op&eacute;ration d'installation pour
      &eacute;diter le fichier de configuration d'Apache
      <code>httpd.conf</code>, sans toutefois installer le module.</dd>
      </dl>
    </section>
</section>

<section id="examples"><title>Exemples</title>
    <p>Supposons que vous disposiez d'un module Apache nomm&eacute;
    <code>mod_foo.c</code> et destin&eacute; &agrave; &eacute;tendre les fonctionnalit&eacute;s du
    serveur. Pour ce faire, vous devez tout d'abord compiler le fichier
    source C en un objet partag&eacute; pouvant &ecirc;tre charg&eacute; dans le serveur
    Apache &agrave; l'ex&eacute;cution, via la commande suivante :</p>

    <example>
      $ apxs -c mod_foo.c<br />
      /chemin/vers/libtool --mode=compile gcc ... -c mod_foo.c<br />
      /chemin/vers/libtool --mode=link gcc ... -o mod_foo.la mod_foo.slo<br />
      $ _
    </example>

    <p>Vous devez ensuite v&eacute;rifier la configuration d'Apache en vous
    assurant qu'une directive <directive
    module="mod_so">LoadModule</directive> est bien pr&eacute;sente pour
    charger cet objet partag&eacute;. Pour simplifier cette &eacute;tape,
    <code>apxs</code> propose une m&eacute;thode automatique d'installation de
    l'objet partag&eacute; dans son r&eacute;pertoire "modules", et de mise &agrave; jour du
    fichier <code>httpd.conf</code> en cons&eacute;quence. Pour b&eacute;n&eacute;ficier de
    cette automatisation, utilisez la commande suivante :</p>

    <example>
      $ apxs -i -a mod_foo.la<br />
      /chemin/vers/instdso.sh mod_foo.la /chemin/vers/apache/modules<br />
      /chemin/vers/libtool --mode=install cp mod_foo.la /chemin/vers/apache/modules
      ...
      chmod 755 /chemin/vers/apache/modules/mod_foo.so<br />
      [activation du module `foo' dans /chemin/vers/apache/conf/httpd.conf]<br />
      $ _
    </example>

    <p>Une ligne contenant</p>

    <example>
      LoadModule foo_module modules/mod_foo.so
    </example>

    <p>est alors ajout&eacute;e au fichier de configuration si ce n'est pas
    d&eacute;j&agrave; fait. Si vous voulez que le module soit d&eacute;sactiv&eacute; par d&eacute;faut,
    utilisez l'option <code>-A</code> comme suit :</p>

    <example>
      $ apxs -i -A mod_foo.c
    </example>

    <p>Pour un test rapide du m&eacute;canisme apxs, vous pouvez cr&eacute;er un
    exemple de mod&egrave;le de module Apache, ainsi que le Makefile
    correspondant via :</p>

    <example>
      $ apxs -g -n foo<br />
      Creating [DIR]  foo<br />
      Creating [FILE] foo/Makefile<br />
      Creating [FILE] foo/modules.mk<br />
      Creating [FILE] foo/mod_foo.c<br />
      Creating [FILE] foo/.deps<br />
      $ _
    </example>

    <p>Vous pouvez ensuite compiler imm&eacute;diatement ce module exemple en
    objet partag&eacute; et le charger dans le serveur Apache :</p>

    <example>
      $ cd foo<br />
      $ make all reload<br />
      apxs -c mod_foo.c<br />
      /chemin/vers/libtool --mode=compile gcc ... -c mod_foo.c<br />
      /chemin/vers/libtool --mode=link gcc ... -o mod_foo.la mod_foo.slo<br />
      apxs -i -a -n "foo" mod_foo.la<br />
      /chemin/vers/instdso.sh mod_foo.la /chemin/vers/apache/modules<br />
      /chemin/vers/libtool --mode=install cp mod_foo.la /chemin/vers/apache/modules
      ...
      chmod 755 /chemin/vers/apache/modules/mod_foo.so<br />
      [activation du module `foo' dans /chemin/vers/apache/conf/httpd.conf]<br />
      apachectl restart<br />
      /chemin/vers/apache/sbin/apachectl restart: httpd not running, trying to start<br />
      [Tue Mar 31 11:27:55 1998] [debug] mod_so.c(303): loaded module foo_module<br />
      /chemin/vers/apache/sbin/apachectl restart: httpd started<br />
      $ _
    </example>

</section>
</manualpage>
