<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1437838 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mpm_winnt.xml.meta">

<name>mpm_winnt</name>
<description>Module multi-processus optimis&eacute; pour Windows
NT.</description>
<status>MPM</status>
<sourcefile>mpm_winnt.c</sourcefile>
<identifier>mpm_winnt_module</identifier>

<summary>
    <p>Ce module multi-processus (MPM) est le module par d&eacute;faut pour les
    syst&egrave;mes d'exploitation de style Windows NT. Il consiste en un
    processus de contr&ocirc;le unique qui lance un processus enfant unique,
    ce dernier cr&eacute;ant &agrave; son tour des threads pour traiter les
    requ&ecirc;tes.</p>

    <p>La directive <directive
    module="mpm_common">ThreadsPerChild</directive> d&eacute;finit le
    nombre maximal de connexions clientes simultan&eacute;es.</p>

    <p>Ce MPM utilise par d&eacute;faut les APIs Windows avanc&eacute;es pour accepter
    les nouvelles connexions des clients. Avec certaines configurations,
    des produits tiers peuvent interf&eacute;rer avec cette impl&eacute;mentation, et
    provoquer l'enregistrement des messages suivants dans les journaux
    du serveur :</p>

    <example>
        Child: Encountered too many AcceptEx faults accepting client connections.<br />
        winnt_mpm: falling back to 'AcceptFilter none'.
    </example>

    <p>Le MPM se rabat sur une impl&eacute;mentation plus s&ucirc;re, mais certaines
    requ&ecirc;tes n'ont pas &eacute;t&eacute; trait&eacute;es correctement. Pour &eacute;viter cette
    erreur, d&eacute;finissez la directive <directive
    module="core">AcceptFilter</directive> &agrave; <code>none</code>.</p>

    <example>
        AcceptFilter none
    </example>

    <p><em>Avec les versions 2.0 et 2.2 d'Apache httpd, c'est la directive
    <directive>Win32DisableAcceptEx</directive> qui &eacute;tait utilis&eacute;e &agrave; cet
    effet.</em></p>

    <p>Le MPM WinNT diff&egrave;re des autres MPMs Unix comme worker et event
    &agrave; bien des &eacute;gards :</p>

    <ul>
      <li>Lorsqu'un processus enfant s'arr&ecirc;te suite &agrave; un arr&ecirc;t ou
      red&eacute;marrage du serveur, ou lorsque que la limite <directive
      module="mpm_common">MaxConnectionsPerChild</directive> est
      atteinte, les requ&ecirc;tes en cours de traitement par ce processus en
      cours d'arr&ecirc;t n'ont que <directive
      module="core">TimeOut</directive> secondes pour s'ex&eacute;cuter avant
      l'arr&ecirc;t du processus. Les autres types de red&eacute;marrage ou arr&ecirc;t ne
      sont pas impl&eacute;ment&eacute;s.</li>

      <li>Les nouveau processus enfants relisent les fichiers de
      configuration au lieu d'en h&eacute;riter du parent. Ce comportement ne
      pose pas de probl&egrave;me si le processus enfant est cr&eacute;&eacute; au d&eacute;marrage
      ou red&eacute;marrage, mais dans le cas o&ugrave; un processus enfant est cr&eacute;&eacute;
      parce qu'un autre processus enfant s'est arr&ecirc;t&eacute; ou a atteint la
      limite <directive
      module="mpm_common">MaxConnectionsPerChild</directive>, tout
      changement survenu entre temps dans la configuration sera alors
      pris en compte dans le processus enfant, et parent et enfant
      utiliseront une configuration diff&eacute;rente. Si des modifications
      planifi&eacute;es de la configuration ont &eacute;t&eacute; partiellement effectu&eacute;es,
      et si la configuration courante n'est pas interpr&eacute;table, le
      processus enfant de remplacement ne pourra pas d&eacute;marrer, et le
      serveur s'arr&ecirc;tera. En cons&eacute;quence, toute modification des
      fichiers de configuration doit &ecirc;tre accompagn&eacute;e d'un red&eacute;marrage
      du serveur.</li>

      <li>Les hooks <code>monitor</code> et <code>fatal_exception</code>
      ne sont pas encore impl&eacute;ment&eacute;s.</li>

      <li>La directive <directive>AcceptFilter</directive> est
      impl&eacute;ment&eacute;e par le MPM et fournit un type de contr&ocirc;le diff&eacute;rent
      sur le traitement des nouvelles connexions (Voir la documentation
      de la directive <directive module="core">AcceptFilter</directive>
      pour plus de d&eacute;tails).</li>
    </ul>

</summary>

<seealso><a href="../platform/windows.html">Utiliser le serveur HTTP
Apache sous Microsoft Windows</a></seealso>

<directivesynopsis location="core"><name>AcceptFilter</name>
</directivesynopsis>

<directivesynopsis location="mpm_common"><name>CoreDumpDirectory</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>PidFile</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>Listen</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>ListenBacklog</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>MaxConnectionsPerChild</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>MaxMemFree</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>ScoreBoardFile</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>ReceiveBufferSize</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>SendBufferSize</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>ThreadLimit</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>ThreadsPerChild</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>ThreadStackSize</name>
</directivesynopsis>

</modulesynopsis>
