<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1479866 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="avoid.xml.meta">
  <parentdocument href="./">Rewrite</parentdocument>

<title>Quand ne pas utiliser mod_rewrite</title>

<summary>

<p>Ce document est un compl&eacute;ment &agrave; la <a
href="../mod/mod_rewrite.html">Documentation de r&eacute;f&eacute;rence</a> de
<module>mod_rewrite</module>. Il d&eacute;crit peut-&ecirc;tre un des concepts les
plus importants &agrave; propos de mod_rewrite - &agrave; savoir, quand doit-on &eacute;viter
de l'utiliser.</p>

<p>mod_rewrite doit &ecirc;tre consid&eacute;r&eacute; comme un dernier recours,
lorsqu'aucune alternative n'est possible. Utiliser mod_rewrite lorsqu'il
existe des alternatives plus simples conduit &agrave; des configurations
confuses, fragiles, et difficiles &agrave; maintenir. La compr&eacute;hension des
autres alternatives disponibles est une &eacute;tape tr&egrave;s importante sur le
chemin de la ma&icirc;trise de mod_rewrite.</p>

<p>Vous devez vous attacher &agrave; comprendre le
fonctionnement des exemples, car la plupart d'entre eux ne
fonctionneront pas sur votre syst&egrave;me si vous vous contentez de les
copier/coller dans vos fichiers de configuration.</p>

<p>Le cas le plus courant dans lequel <module>mod_rewrite</module> est
l'outil appropri&eacute; est la situation o&ugrave; la seule solution envisageable
n&eacute;cessite l'acc&egrave;s aux fichiers de configuration du serveur, alors que
cet acc&egrave;s ne vous est pas accord&eacute;. Certaines directives de configuration
ne sont disponibles que dans le fichier de configuration du serveur. Si
vous ne pouvez agir que sur les fichiers .htaccess, vous devrez donc
vous tourner vers <module>mod_rewrite</module>.</p>

</summary>
<seealso><a href="../mod/mod_rewrite.html">Documentation du module mod_rewrite</a></seealso>
<seealso><a href="intro.html">Introduction &agrave; mod_rewrite</a></seealso>
<seealso><a href="remapping.html">Redirection et remise en
correspondance</a></seealso>
<seealso><a href="access.html">Contr&ocirc;le d'acc&egrave;s</a></seealso>
<seealso><a href="vhosts.html">Serveurs virtuels</a></seealso>
<seealso><a href="proxy.html">Serveurs mandataires</a></seealso>
<seealso><a href="rewritemap.html">Utilisation de RewriteMap</a></seealso>
<seealso><a href="advanced.html">Techniques avanc&eacute;es</a></seealso>
<!--<seealso><a href="avoid.html">Quand ne pas utiliser mod_rewrite</a></seealso>-->

<section id="redirect">
<title>Redirection simple</title>

<p><module>mod_alias</module> fournit les directives <directive
module="mod_alias">Redirect</directive> et <directive
module="mod_alias">RedirectMatch</directive> qui permettent de
rediriger une URL vers une autre. Plut&ocirc;t que d'utiliser la directive
<directive module="mod_rewrite">RewriteRule</directive> pour ce genre de
redirection simple d'une URL ou d'une classe d'URLs vers une autre, on
pr&eacute;f&egrave;rera l'utilisation de ces directives. En outre, avec
<code>RedirectMatch</code>, vous pouvez inclure une expression
rationnelle dans votre crit&egrave;re de redirection, ce qui vous permet de
b&eacute;n&eacute;ficier de nombreux avantages de la directive
<code>RewriteRule</code>.</p>

<p>Une utilisation courante de la directive <code>RewriteRule</code> est
la redirection de toute une classe d'URLs. Par exemple, toutes les URLs
faisant r&eacute;f&eacute;rence au r&eacute;pertoire <code>/un</code> doivent &ecirc;tre
redirig&eacute;es vers <code>http://un.example.com/</code>, ou toutes les
requ&ecirc;tes <code>http</code> doivent &ecirc;tre redirig&eacute;es vers
<code>https</code>.</p>

<p>Pour ce faire, il est pr&eacute;f&eacute;rable d'utiliser la directive
<code>Redirect</code>. Souvenez-vous que la directive
<code>Redirect</code> conserve les informations relatives au chemin. En
d'autres termes, la redirection d'une URL <code>/un</code> va aussi
rediriger toutes les URLs de niveaux inf&eacute;rieurs comme
<code>/un/deux.html</code> et <code>/un/trois/quatre.html</code>.</p>

<p>Pour rediriger les URLs sous <code>/un</code> vers
<code>http://un.example.com/</code>, utilisez cette d&eacute;finition :</p>

<highlight language="config">Redirect /one/ http://one.example.com/</highlight>

<p>Pour rediriger les URLs <code>http</code> vers <code>https</code>,
utilisez cette d&eacute;finition :</p>

<highlight language="config">
&lt;VirtualHost *:80&gt;
ServerName www.example.com
Redirect / https://www.example.com/
&lt;/VirtualHost &gt;

&lt;VirtualHost *:443&gt;
ServerName www.example.com
#  ... ins&eacute;rer ici la configuration SSL
&lt;/VirtualHost &gt;
</highlight>

<p>L'utilisation de la directive <code>RewriteRule</code> pour accomplir
cette t&acirc;che peut se justifier s'il existe d'autres directives
<code>RewriteRule</code> dans la m&ecirc;me port&eacute;e. En effet, lorsque des
directives <code>Redirect</code> et <code>RewriteRule</code> se trouvent
dans la m&ecirc;me port&eacute;e, les directives <code>RewriteRule</code> sont
ex&eacute;cut&eacute;es en premier, sans tenir compte de leur ordre d'apparition dans
le fichier de configuration.</p>

<p>Dans le cas de la redirection <em>http-vers-https</em>, l'utilisation
de r&egrave;gles <code>RewriteRule</code> se justifie si vous n'avez pas acc&egrave;s
au fichier de configuration principal, et devez donc accomplir cette
t&acirc;che au sein d'un fichier <code>.htaccess</code>.</p>

</section>

<section id="alias"><title>Alias d'URL</title>
<p>La directive <directive module="mod_alias">Alias</directive> permet
de mettre en correspondance un URI avec un r&eacute;pertoire, ce dernier &eacute;tant
en g&eacute;n&eacute;ral situ&eacute; en dehors de l'arborescence d&eacute;finie par la directive
<directive module="core">DocumentRoot</directive>. Bien qu'il soit
possible d'effectuer cette mise en correspondance avec
<code>mod_rewrite</code>, il est pr&eacute;f&eacute;rable d'utiliser la directive
<code>Alias</code> pour des raisons de simplicit&eacute; et de performances.</p>

<example><title>Utilisation de la directive Alias</title>
<highlight language="config">Alias /cats
/var/www/virtualhosts/felines/htdocs</highlight>
</example>

<p>
Pour effectuer cette mise en correspondance, <code>mod_rewrite</code>
s'impose si vous n'avez pas acc&egrave;s aux fichiers de configuration du
serveur. En effet, la directive Alias ne peut pas &ecirc;tre utilis&eacute;e dans un
fichier <code>.htaccess</code>, mais seulement dans un contexte de
serveur principal ou de serveur virtuel.
</p>

<p>En outre, vous pouvez arriver au m&ecirc;me r&eacute;sultat avec les liens
symboliques, pourvu que <code>Options FollowSymLinks</code> soit activ&eacute;
sur votre serveur.</p>
</section>

<section id="vhosts"><title>H&eacute;bergement virtuel</title>
<p>Bien qu'il soit possible de g&eacute;rer les <a href="vhosts.html">serveurs
virtuels avec mod_rewrite</a>, il s'agit rarement de la bonne m&eacute;thode.
Il est pratiquement toujours pr&eacute;f&eacute;rable de cr&eacute;er des blocs
&lt;VirtualHost&gt; individuels. Dans l'&eacute;ventualit&eacute; o&ugrave; vous devez g&eacute;rer
un grand nombre de serveurs virtuels, vous devez vous tourner vers
<module>mod_vhost_alias</module> pour cr&eacute;er ces serveurs
automatiquement.</p>

<p>Il est aussi possible d'utiliser des modules comme <module>mod_macro</module> pour
cr&eacute;er un grand nombre de serveurs virtuels dynamiquement.</p>

<p>L'utilisation de <module>mod_rewrite</module> pour la cr&eacute;ation de
serveurs virtuels peut se r&eacute;v&eacute;ler appropri&eacute;e si votre service
d'h&eacute;bergement ne vous permet pas d'acc&eacute;der aux fichiers de configuration
du serveur, et que vous soyez par cons&eacute;quent oblig&eacute; de passer par les
fichiers <code>.htaccess</code>.</p>

<p>Voir le document <a href="vhosts.html">cr&eacute;ation de serveurs virtuels
avec mod_rewrite</a> pour plus de d&eacute;tails sur la mani&egrave;re d'y parvenir si
cela semble &ecirc;tre tout de m&ecirc;me la meilleure approche.</p>

</section>

<section id="proxy"><title>Mandat simple</title>

<p>La directive <code>RewriteRule</code> fournit le drapeau <a
href="flags.html#flag_p">[P]</a> qui permet de faire passer les URIs
r&eacute;&eacute;crits par <module>mod_proxy</module>.</p>

<highlight language="config">
RewriteRule ^/?images(.*) http://serveur-images.local/images$1 [P]
</highlight>

<p>Cependant, dans les nombreux cas o&ugrave; aucune correspondance au mod&egrave;le
n'est vraiment n&eacute;cessaire, comme dans l'exemple ci-dessus, il est
pr&eacute;f&eacute;rable d'utiliser la directive <directive
module="mod_proxy">ProxyPass</directive>. L'exemple pr&eacute;c&eacute;dent pourrait
&ecirc;tre remplac&eacute; par :</p>

<highlight language="config">
ProxyPass /images/ http://serveur-images.local/images/
</highlight>

<p>Que vous utilisiez <directive
module="mod_rewrite">RewriteRule</directive> ou <directive
module="mod_proxy">ProxyPass</directive>, vous devrez dans tous les cas
utiliser aussi la directive <directive
module="mod_proxy">ProxyPassReverse</directive> pour intercepter les
redirections en provenance du serveur d'arri&egrave;re-plan :</p>

<highlight language="config">
ProxyPassReverse /images/ http://serveur-images.local/images/
</highlight>

<p>Vous devrez cependant tout de m&ecirc;me utiliser <code>RewriteRule</code>
lorsque d'autres <code>RewriteRule</code>s se trouvent dans la m&ecirc;me port&eacute;e,
car elles agissent en g&eacute;n&eacute;ral avant les directives
<code>ProxyPass</code>, et peuvent ainsi les court-circuiter.</p>

</section>

<section id="setenv"><title>Test de variables d'environnement</title>

<p><module>mod_rewrite</module> est souvent utilis&eacute; pour effectuer une
action en fonction de la pr&eacute;sence ou de l'absence d'une variable
d'environnement particuli&egrave;re ou d'un en-t&ecirc;te de requ&ecirc;te, ce qui peut
&ecirc;tre accompli de mani&egrave;re plus efficace via la directive <directive
module="core" type="section">If</directive>.</p>

<p>Consid&eacute;rons par exemple le sc&eacute;nario courant o&ugrave; la directive
<directive>RewriteRule</directive> est utilis&eacute;e pour forcer un nom
d'h&ocirc;te canonique, tel que <code>www.example.com</code> au lieu de
<code>example.com</code>. Il est possible d'utiliser &agrave; la place la
directive <directive module="core" type="section">If</directive> comme
suit :</p>

<highlight language="config">
&lt;If "req('Host') != 'www.example.com'"&gt;
    Redirect / http://www.example.com
&lt;/If&gt;
</highlight>

<p>On peut utiliser cette technique dans de nombreux sc&eacute;narios courant
pour remplacer <module>mod_rewrite</module> pour effectuer des actions
en fonction d'en-t&ecirc;tes de requ&ecirc;tes ou de r&eacute;ponses, ou de variables
d'environnement.</p>

<p>Voir en particulier la <a href="../expr.html">documentation sur
l'&eacute;valuation des expressions</a> pour une vue d'ensemble des types
d'expressions que vous pouvez utiliser dans les sections &lt;If&gt;,
ainsi que dans certaines directives.</p>

</section>

</manualpage>

