<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1363237 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="remapping.xml.meta">
  <parentdocument href="./">Rewrite</parentdocument>

<title>Redirection et remise en correspondance avec mod_rewrite</title>

<summary>

<p>Ce document est un compl&eacute;ment &agrave; la <a
href="../mod/mod_rewrite.html">Documentation de r&eacute;f&eacute;rence</a> de
<module>mod_rewrite</module>. Il montre comment utiliser
<module>mod_rewrite</module> pour rediriger et remettre en
correspondance une requ&ecirc;te. Il contient de
nombreux exemples d'utilisation courante de mod_rewrite avec une
description d&eacute;taill&eacute;e de leur fonctionnement.</p>

<note type="warning">Vous devez vous attacher &agrave; comprendre le
fonctionnement des exemples, car la plupart d'entre eux ne
fonctionneront pas sur votre syst&egrave;me si vous vous contentez de les
copier/coller dans vos fichiers de configuration.</note>

</summary>
<seealso><a href="../mod/mod_rewrite.html">Documentation du module mod_rewrite</a></seealso>
<seealso><a href="intro.html">Introduction &agrave; mod_rewrite</a></seealso>
<!--<seealso><a href="remapping.html">Redirection et remise en
correspondance</a></seealso>-->
<seealso><a href="access.html">Contr&ocirc;ler l'acc&egrave;s</a></seealso>
<seealso><a href="vhosts.html">Serveurs virtuels</a></seealso>
<seealso><a href="proxy.html">Serveurs mandataires</a></seealso>
<seealso><a href="rewritemap.html">Utilisation de RewriteMap</a></seealso>
<seealso><a href="advanced.html">Techniques avanc&eacute;es</a></seealso>
<seealso><a href="avoid.html">Quand ne pas utiliser mod_rewrite</a></seealso>

<section id="old-to-new">

      <title>De l'ancienne &agrave; la nouvelle URL (en interne)</title>

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Supposons que nous ayons r&eacute;cemment renomm&eacute; la page
	  <code>foo.html</code> en <code>bar.html</code>, et voulions
	  maintenant que l'ancienne URL soit toujours valide &agrave; des fins
	  de compatibilit&eacute; ascendante. En fait, on voudrait que le
	  changement de nom soit transparent aux utilisateurs de
	  l'ancienne URL.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>On r&eacute;&eacute;crit l'ancienne URL en interne vers la nouvelle via
	  la r&egrave;gle suivante :</p>

<highlight language="config">
RewriteEngine  on
RewriteRule    ^<strong>/foo</strong>\.html$  <strong>/bar</strong>.html [PT]
</highlight>
    </dd>
  </dl>

</section>

<section id="old-to-new-extern">

      <title>De l'ancien au nouveau (en externe)</title>

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Supposons toujours que nous ayons r&eacute;cemment renomm&eacute; la page
	  <code>foo.html</code> en <code>bar.html</code>, et voulions
	  maintenant que l'ancienne URL soit toujours valide &agrave; des fins
	  de compatibilit&eacute; ascendante. En revanche, nous voulons cette
	  fois que la nouvelle URL soit sugg&eacute;r&eacute;e aux utilisateurs de
	  l'ancienne URL, c'est &agrave; dire que l'adresse vue depuis leur
	  navigateur doit &eacute;galement &ecirc;tre modifi&eacute;e.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>On force une redirection HTTP vers la nouvelle URL, ce qui
	  entra&icirc;ne une modification de celle du navigateur et aussi de ce
	  que voit l'utilisateur :</p>

<highlight language="config">
RewriteEngine  on
RewriteRule    ^<strong>foo</strong>\.html$  <strong>bar</strong>.html  [<strong>R</strong>]
</highlight>
</dd>

<dt>Discussion</dt>

    <dd>
    <p>Dans l'exemple <a
    href="#old-to-new-intern">interne</a>, on a utilis&eacute; mod_rewrite afin
    de dissimuler la redirection au client. Dans cet exemple, en
    revanche, on aurait pu se contenter d'une directive Redirect :</p>

    <highlight language="config">Redirect /foo.html /bar.html</highlight>

    </dd>
  </dl>

</section>

<section id="movehomedirs">

  <title>Ressource d&eacute;plac&eacute;e vers un autre serveur</title>

  <dl>
    <dt>Description :</dt>

    <dd>
      <p>Si une ressource a &eacute;t&eacute; d&eacute;plac&eacute;e vers un autre serveur, vous
      pouvez faire en sorte que les URLs de l'ancien serveur continuent
      de fonctionner pendant un certain temps, afin de laisser au
      utilisateurs le temps de modifier leurs favoris.</p>
    </dd>

    <dt>Solution :</dt>

    <dd>
      <p>Vous pouvez utiliser <module>mod_rewrite</module> pour
      rediriger ces URLs vers le nouveau serveur, mais vous pouvez aussi
      utiliser les directives Redirect ou RedirectMatch.</p>

<highlight language="config">#Avec mod_rewrite
RewriteEngine on
RewriteRule   ^/docs/(.+)  http://nouveau.example.com/docs/$1  [R,L]
</highlight>

<highlight language="config">#Avec RedirectMatch
RedirectMatch ^/docs/(.*) http://nouveau.example.com/docs/$1
</highlight>

<highlight language="config">#Avec Redirect
Redirect /docs/ http://nouveau.example.com/docs/
</highlight>
    </dd>
  </dl>

</section>



<section id="static-to-dynamic">

      <title>De statique &agrave; dynamique</title>

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Comment transformer une page statique <code>foo.html</code>
	  en sa variante dynamique <code>foo.cgi</code> de mani&egrave;re
	  transparente, c'est &agrave; dire sans en avertir le
	  navigateur/utilisateur.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>On r&eacute;&eacute;crit simplement l'URL en script CGI et force le
	  gestionnaire de contenu &agrave; <strong>cgi-script</strong> de fa&ccedil;on
	  &agrave; ce que le script s'ex&eacute;cute en tant que programme CGI.
	  Ainsi, une requ&ecirc;te vers <code>/~quux/foo.html</code> conduit
	  en interne &agrave; l'invocation de
	  <code>/~quux/foo.cgi</code>.</p>

<highlight language="config">
RewriteEngine  on
RewriteBase    /~quux/
RewriteRule    ^foo\.html$  foo.cgi &nbsp; [H=<strong>cgi-script</strong>]
</highlight>
        </dd>
      </dl>

    </section>

<section id="backward-compatibility">

      <title>Compatibilit&eacute; ascendante dans le cadre d'une modification
      d'extension de nom de fichier</title>

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Comment conf&eacute;rer une compatibilit&eacute; ascendante aux URLs
	  (existant encore virtuellement) apr&egrave;s avoir migr&eacute;
	  <code>document.YYYY</code> vers <code>document.XXXX</code>,
	  c'est &agrave; dire apr&egrave;s avoir par exemple traduit un lot de
	  fichiers <code>.html</code> en fichiers <code>.php</code>
	  ?</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>On r&eacute;&eacute;crit simplement le nom du fichier en son nom
	  de base et v&eacute;rifie s'il existe aussi avec la nouvelle
	  extension. Si c'est le cas, on utilise ce nom, sinon on
	  r&eacute;&eacute;crit l'URL sous sa forme originale.</p>


<highlight language="config">
#   jeu de r&egrave;gles assurant une compatibilit&eacute; ascendante en r&eacute;&eacute;crivant<br />
#   document.html en document.php si et seulement si document.php<br />
#   existe
&lt;Directory /var/www/htdocs&gt;
    RewriteEngine on
    RewriteBase /var/www/htdocs

    RewriteCond $1.php -f
    RewriteCond $1.html !-f
    RewriteRule ^(.*).html$ $1.php
&lt;/Directory&gt;
</highlight>
    </dd>

    <dt>Discussion</dt>
    <dd>
    <p>Cet exemple utilise une fonctionnalit&eacute; souvent m&eacute;connue de
    mod_rewrite, en tirant avantage de l'ordre d'ex&eacute;cution du jeu de
    r&egrave;gles. En particulier, mod_rewrite &eacute;value la partie gauche des
    r&egrave;gles de r&eacute;&eacute;criture avant d'&eacute;valuer les directives RewriteCond. En
    cons&eacute;quence, $1 est d&eacute;j&agrave; d&eacute;fini au moment o&ugrave; les directives
    RewriteCond sont &eacute;valu&eacute;es. Ceci nous permet de tester l'existence du
    fichier original (<code>document.html</code>) et du fichier cible
    (<code>document.php</code>) en utilisant le m&ecirc;me nom de base.</p>

    <p>Ce jeu de r&egrave;gles est con&ccedil;u pour une utilisation dans un contexte
    de r&eacute;pertoire (au sein d'une section &lt;Directory&gt; ou d'un
    fichier .htaccess), de fa&ccedil;on &agrave; ce que les v&eacute;rifications
    <code>-f</code> effectuent leurs recherches dans le bon r&eacute;pertoire.
    Vous serez peut-&ecirc;tre amen&eacute; &agrave; d&eacute;finir une directive <directive
    module="mod_rewrite">RewriteBase</directive> pour sp&eacute;cifier le
    r&eacute;pertoire de base &agrave; partir duquel vous travaillez.</p>
    </dd>
  </dl>

</section>

<section id="canonicalhost">

<title>Noms d'h&ocirc;tes canoniques</title>

      <dl>
        <dt>Description :</dt>

        <dd>Le but de cette r&egrave;gle est de pr&eacute;f&eacute;rer l'utilisation d'un nom
	d'h&ocirc;te particulier &agrave; d'autres noms d'h&ocirc;te utilisables
	pour atteindre le m&ecirc;me site. Par exemple, si vous voulez
	utiliser <strong>www.example.com</strong> &agrave; la place de
	<strong>example.com</strong>, vous pouvez utiliser une solution
	du style :</dd>

        <dt>Solution :</dt>

        <dd>

<p>Pour y parvenir, il vaut mieux se passer de mod_rewrite, et utiliser
plut&ocirc;t la directive <directive module="mod_alias">Redirect</directive> dans
une section de serveur virtuel pour le/les noms d'h&ocirc;te non canoniques.</p>

<highlight language="config">
&lt;VirtualHost *:80&gt;
  ServerName undesired.example.com
  ServerAlias example.com notthis.example.com

  Redirect / http://www.example.com/
&lt;/VirtualHost&gt;

&lt;VirtualHost *:80&gt;
  ServerName www.example.com
&lt;/VirtualHost&gt;
</highlight>

<p>Vous pouvez aussi utiliser la directive <directive module="core"
type="section">If</directive> :</p>

<highlight language="config">
&lt;If "%{HTTP_HOST} != 'www.example.com'"&gt;
	Redirect / http://www.example.com/
&lt;/If&gt;
</highlight>

<p>Ou, par exemple, pour rediriger une portion de votre site vers HTTPS
:</p>

<highlight language="config">
&lt;If "%{SERVER_PROTOCOL} != 'HTTPS'"&gt;
	Redirect /admin/ https://www.example.com/admin/
&lt;/If&gt;
</highlight>

<p>Si, pour une raison particuli&egrave;re, vous voulez tout de m&ecirc;me utiliser
<code>mod_rewrite</code> - dans le cas, par exemple, o&ugrave; vous avez besoin
d'un jeu plus important de r&egrave;gles de r&eacute;&eacute;critures - vous pouvez utiliser
la recette suivante :</p>

<p>Pour les sites &eacute;coutant sur un port autre que 80:</p>
<highlight language="config">
RewriteCond %{HTTP_HOST}   !^www\.example\.com [NC]
RewriteCond %{HTTP_HOST}   !^$
RewriteCond %{SERVER_PORT} !^80$
RewriteRule ^/?(.*)         http://www.example.com:%{SERVER_PORT}/$1 [L,R,NE]
</highlight>

<p>Et pour un site &eacute;coutant sur le port 80</p>
<highlight language="config">
RewriteCond %{HTTP_HOST}   !^www\.example\.com [NC]
RewriteCond %{HTTP_HOST}   !^$
RewriteRule ^/?(.*)         http://www.example.com/$1 [L,R,NE]
</highlight>
	<p>
	Si vous souhaitez que cette r&egrave;gle s'applique &agrave; tous les noms de
	domaine - en d'autres termes, si vous voulez rediriger
	<strong>example.com</strong> vers
	<strong>www.example.com</strong> pour toutes les valeurs
	possibles de <strong>example.com</strong>, vous pouvez utiliser
	le jeu de r&egrave;gles suivants :</p>

<highlight language="config">
RewriteCond %{HTTP_HOST} !^www\. [NC]
RewriteCond %{HTTP_HOST} !^$
RewriteRule ^/?(.*) http://www.%{HTTP_HOST}/$1 [L,R,NE]
</highlight>
	<p>
	Vous pouvez utiliser ce jeu de r&egrave;gles aussi bien dans le fichier
	de configuration de votre serveur principal que dans un fichier
	<code>.htaccess</code> plac&eacute; dans le r&eacute;pertoire d&eacute;fini par la
	directive <directive
	module="core">DocumentRoot</directive> du serveur.</p>
        </dd>
      </dl>

    </section>

<section id="multipledirs">

  <title>Recherche de pages dans plus d'un r&eacute;pertoire</title>

  <dl>
    <dt>Description:</dt>

    <dd>
      <p>Une ressource peut exister dans plusieurs r&eacute;pertoires, et nous
      voulons rechercher cette ressource dans ces r&eacute;pertoires
      lorsqu'elle fait l'objet d'une requ&ecirc;te. Il est possible que nous
      ayons r&eacute;cemment r&eacute;organis&eacute; la structure de notre site en
      r&eacute;partissant son contenu dans plusieurs r&eacute;pertoires.</p>
    </dd>

    <dt>Solution :</dt>

    <dd>
      <p>Le jeu de r&egrave;gles suivant recherche la ressource dans deux
      r&eacute;pertoires, et s'il ne la trouve dans aucun des deux, il tentera
      simplement de la servir &agrave; partir de l'adresse fournie dans la
      requ&ecirc;te.</p>

<highlight language="config">
RewriteEngine on

#   on cherche tout d'abord dans dir1/...
#   ... et si on trouve, on est content et on arr&ecirc;te :
RewriteCond         %{DOCUMENT_ROOT}/<strong>dir1</strong>/%{REQUEST_URI}  -f
RewriteRule  ^(.+)  %{DOCUMENT_ROOT}/<strong>dir1</strong>/$1  [L]

#   on cherche ensuite dans dir2/...
#   ... et si on trouve, on est content et on arr&ecirc;te :
RewriteCond         %{DOCUMENT_ROOT}/<strong>dir2</strong>/%{REQUEST_URI}  -f
RewriteRule  ^(.+)  %{DOCUMENT_ROOT}/<strong>dir2</strong>/$1  [L]

#   sinon, on continue la recherche avec d'autres directives Alias
#   ou ScriptAlias, etc...
RewriteRule   ^  -  [PT]
</highlight>
        </dd>
      </dl>

    </section>

<section id="archive-access-multiplexer">

  <title>Redirection vers des serveurs g&eacute;ographiquement distribu&eacute;s</title>

  <dl>
    <dt>Description :</dt>

    <dd>
    <p>Notre site web poss&egrave;de de nombreux miroirs, et nous voulons
    rediriger les utilisateurs vers celui qui se situe dans le pays o&ugrave;
    ils se trouvent. </p>
    </dd>

    <dt>Solution :</dt>

    <dd>
    <p>En consultant le nom d'h&ocirc;te du client demandeur, on d&eacute;termine le
    pays dans lequel il se trouve. S'il est impossible d'effectuer une
    recherche sur leur adresse IP, on se rabat sur un serveur par
    d&eacute;faut.</p>
    <p>Nous allons utiliser une directive <directive
    module="mod_rewrite">RewriteMap</directive> afin de construire une
    liste des serveurs que nous voulons utiliser.</p>

<highlight language="config">
HostnameLookups on
RewriteEngine on
RewriteMap    multiplex         txt:/path/to/map.mirrors
RewriteCond  %{REMOTE_HOST}     ([a-z]+)$ [NC]
RewriteRule   ^/(.*)$  ${multiplex:<strong>%1</strong>|http://www.example.com/}$1  [R,L]
</highlight>

<example>
##  liste_miroirs -- Table de correspondance pays - serveurs<br />
<br />
de        http://www.exemple.de/<br />
uk        http://www.exemple.uk/<br />
com       http://www.example.com/<br />
##EOF##
</example>
    </dd>

    <dt>Discussion</dt>
    <dd>
    <note type="warning">Ce jeu de r&egrave;gles n&eacute;cessite la d&eacute;finition &agrave;
    <code>on</code> de la directive <directive
    module="core">HostNameLookups</directive>, ce qui peut induire une
    baisse de performance significative.</note>

    <p>La directive <directive
    module="mod_rewrite">RewriteCond</directive> extrait la derni&egrave;re
    partie du nom d'h&ocirc;te du client demandeur - le code du pays - et la
    r&egrave;gle de r&eacute;&eacute;criture qui suit utilise cette valeur pour rechercher le
    serveur miroir appropri&eacute; dans le fichier de correspondances.</p>
    </dd>
  </dl>

</section>

<section id="browser-dependent-content">

      <title>Contenu d&eacute;pendant du navigateur</title>

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Nous voulons fournir des contenus diff&eacute;rents en fonction du
	  navigateur (user-agent) qui effectue la requ&ecirc;te.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>Nous devons d&eacute;terminer quel contenu servir, en nous basant
	  sur l'en-t&ecirc;te HTTP "User-Agent". La
	  configuration suivante effectue ceci : si l'en-t&ecirc;te HTTP
	  "User-Agent" commence par "Mozilla/3", le nom de la page
	  <code>foo.html</code> est r&eacute;&eacute;crit en <code>foo.NS.html</code>
	  et la r&eacute;&eacute;criture s'arr&ecirc;te. Si le navigateur est "Lynx" ou
	  "Mozilla" version 1 ou 2, l'URL devient
	  <code>foo.20.html</code>. Tous les autres navigateurs
	  re&ccedil;oivent la page <code>foo.32.html</code>. Tout ceci est
	  effectu&eacute; par le jeu de r&egrave;gles suivant :</p>
<highlight language="config">
RewriteCond %{HTTP_USER_AGENT}  ^<strong>Mozilla/3</strong>.*
RewriteRule ^foo\.html$         foo.<strong>NS</strong>.html          [<strong>L</strong>]

RewriteCond %{HTTP_USER_AGENT}  ^Lynx/ [OR]
RewriteCond %{HTTP_USER_AGENT}  ^Mozilla/[12]
RewriteRule ^foo\.html$         foo.<strong>20</strong>.html          [<strong>L</strong>]

RewriteRule ^foo\.html$         foo.<strong>32</strong>.html          [<strong>L</strong>]
</highlight>
        </dd>
      </dl>

    </section>

<section id="canonicalurl">

<title>URLs canoniques</title>

<dl>
 <dt>Description :</dt>

   <dd>
     <p>Sur certains serveurs, une ressource peut poss&eacute;der plusieurs
     URLs. Il y a en g&eacute;n&eacute;ral les URLs canoniques (celles qui sont
     r&eacute;ellement distribu&eacute;es et utilis&eacute;es), et celles qui correspondent &agrave;
     des raccourcis, les URLs internes, etc... Quelle que soit l'adresse
     que l'utilisateur fournit dans la requ&ecirc;te, il devrait finalement
     voir l'URL canonique dans la barre d'adresse de son navigateur.</p>
   </dd>

   <dt>Solution :</dt>

     <dd>
       <p>Nous effectuons une redirection HTTP externe pour toutes les
       URLs non canoniques afin de les corriger dans la barre d'adresse
       du navigateur, et ceci pour toutes les requ&ecirc;tes futures. Dans le
       jeu de r&egrave;gles suivant, nous rempla&ccedil;ons <code>/matous</code> et
       <code>/minettes</code> par le canonique <code>/chats</code>.</p>

	<highlight language="config">RewriteRule   ^/(matous|minettes)/(.*)    /chats/$2  [R]</highlight>
        </dd>

     <dt>Discussion :</dt>
     <dd>On serait mieux inspir&eacute; d'utiliser ici les directives Redirect ou
     RedirectMatch :

     <highlight language="config"> RedirectMatch ^/(matous|minettes)/(.*) /chats/$2 </highlight>
     </dd>
      </dl>

</section>

<section id="moveddocroot">

  <title>D&eacute;placement du r&eacute;pertoire <code>DocumentRoot</code></title>

  <dl>
    <dt>Description :</dt>

    <dd>
<p>En g&eacute;n&eacute;ral, le r&eacute;pertoire <directive
module="core">DocumentRoot</directive> du serveur web correspond &agrave; l'URL
"<code>/</code>". Ce r&eacute;pertoire ne contient cependant pas forc&eacute;ment des
ressources de premi&egrave;re importance pour l'utilisateur. Par exemple, vous
pr&eacute;f&eacute;rerez peut-&ecirc;tre que le r&eacute;pertoire d'accueil d'un visiteur acc&eacute;dant
pour la premi&egrave;re fois &agrave; votre site soit un r&eacute;pertoire particulier
<code>/a-propos-de/</code>. Pour y parvenir, utilisez le jeu de r&egrave;gles
suivant :</p>
</dd>

    <dt>Solution :</dt>

    <dd>
      <p>On redirige l'URL <code>/</code> vers
      <code>/a-propos-de/</code> :
      </p>

<highlight language="config">
RewriteEngine on
RewriteRule   ^/$  /a-propos-de/  [<strong>R</strong>]
</highlight>

<p>Notez que l'on peut aussi y parvenir en utilisant la directive
<directive module="mod_alias">RedirectMatch</directive> :</p>

<highlight language="config">RedirectMatch ^/$
http://example.com/a-propos-de/</highlight>

<p>Notez aussi que cet exemple ne r&eacute;&eacute;crit que l'URL racine. En d'autres
termes, il r&eacute;&eacute;crit une requ&ecirc;te pour <code>http://example.com/</code>,
mais pas pour une requ&ecirc;te <code>http://example.com/page.html</code>. Si
vous avez effectivement modifi&eacute; la racine de vos documents - c'est &agrave; dire
si <strong>tous</strong> vos contenus se trouvent dans un
sous-r&eacute;pertoire, il est largement pr&eacute;f&eacute;rable de modifier simplement
votre directive <directive module="core">DocumentRoot</directive>, ou de
d&eacute;placer l'ensemble du contenu vers le r&eacute;pertoire sup&eacute;rieur, plut&ocirc;t que
de r&eacute;&eacute;crire les URLs.</p>
</dd>
</dl>

</section>

<section id="fallback-resource">
<title>Ressource par d&eacute;faut</title>

<dl>
<dt>Description :</dt>
<dd>Vous voulez qu'une seule ressource (disons un certain fichier tel
que index.php) soit servie pour toutes les requ&ecirc;tes &agrave; destination d'un
certain r&eacute;pertoire, sauf pour celles qui concernent une ressource
existant effectivement comme une image, ou un fichier css.</dd>

<dt>Solution :</dt>
<dd>
<p>Depuis la version 2.2.16, vous pouvez y parvenir via la directive
<directive module="mod_dir">FallbackResource</directive> :</p>

<highlight language="config">
&lt;Directory /var/www/my_blog&gt;
  FallbackResource index.php
&lt;/Directory&gt;
</highlight>

<p>Cependant, si vos besoins &eacute;taient plus complexes, vous pouviez, dans
les versions plus anciennes d'Apache, utiliser un jeu de r&egrave;gles du style
:</p>

<highlight language="config">
&lt;Directory /var/www/my_blog&gt;
  RewriteBase /my_blog

  RewriteCond /var/www/my_blog/%{REQUEST_FILENAME} !-f
  RewriteCond /var/www/my_blog/%{REQUEST_FILENAME} !-d
  RewriteRule ^ index.php [PT]
&lt;/Directory&gt;
</highlight>

<p>D'autre part, si vous voulez transmettre l'URI de la requ&ecirc;te en tant
que cha&icirc;ne de param&egrave;tres &agrave; index.php, vous pouvez remplacer cette r&egrave;gle
de r&eacute;&eacute;criture par :</p>

<highlight language="config">RewriteRule (.*) index.php?$1 [PT,QSA]</highlight>

<p>Notez que l'on peut utiliser ces jeux de r&egrave;gles aussi bien dans un
fichier <code>.htaccess</code> que dans une section
&lt;Directory&gt;.</p>

</dd>

</dl>

</section>

</manualpage>
