/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.movie;

import com.anotherbigidea.flash.interfaces.SWFActionBlock;
import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.movie.Actions;
import com.anotherbigidea.flash.movie.Movie;
import com.anotherbigidea.flash.movie.Symbol;
import com.anotherbigidea.flash.movie.Transform;
import com.anotherbigidea.flash.structs.AlphaTransform;
import com.anotherbigidea.flash.structs.ButtonRecord2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;

public class Button
extends Symbol {
    protected ArrayList actions = new ArrayList();
    protected ArrayList layers = new ArrayList();
    protected boolean trackAsMenu;

    public Button(boolean bl) {
        this.trackAsMenu = bl;
    }

    public boolean isTrackedAsMenu() {
        return this.trackAsMenu;
    }

    public void trackAsMenu(boolean bl) {
        this.trackAsMenu = bl;
    }

    public ArrayList getButtonLayers() {
        return this.layers;
    }

    public ArrayList getActions() {
        return this.actions;
    }

    public Layer addLayer(Symbol symbol, Transform transform, AlphaTransform alphaTransform, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Layer layer = new Layer(symbol, transform, alphaTransform, n, bl, bl2, bl3, bl4);
        this.layers.add(layer);
        return layer;
    }

    public Actions addActions(int n, int n2) {
        Actions actions = new Actions(n, n2);
        this.actions.add(actions);
        return actions;
    }

    protected int defineSymbol(Movie movie, SWFTagTypes sWFTagTypes, SWFTagTypes sWFTagTypes2) throws IOException {
        int n = this.getNextId(movie);
        Vector<ButtonRecord2> vector = new Vector<ButtonRecord2>();
        for (Object object : this.layers) {
            vector.addElement(((Layer)object).getRecord(movie, sWFTagTypes, sWFTagTypes2));
        }
        SWFActions sWFActions = sWFTagTypes2.tagDefineButton2(n, this.trackAsMenu, vector);
        for (Actions actions : this.actions) {
            SWFActionBlock sWFActionBlock = sWFActions.start(actions.getConditions());
            sWFActionBlock.blob(actions.bytes);
        }
        sWFActions.done();
        return n;
    }

    public static class Layer {
        protected Symbol symbol;
        protected Transform matrix;
        protected AlphaTransform cxform;
        protected int depth;
        protected boolean usedForHitArea;
        protected boolean usedForUp;
        protected boolean usedForDown;
        protected boolean usedForOver;

        public Symbol getSymbol() {
            return this.symbol;
        }

        public Transform getTransform() {
            return this.matrix;
        }

        public AlphaTransform getColoring() {
            return this.cxform;
        }

        public int getDepth() {
            return this.depth;
        }

        public boolean isUsedForHitArea() {
            return this.usedForHitArea;
        }

        public boolean isUsedForUp() {
            return this.usedForUp;
        }

        public boolean isUsedForDown() {
            return this.usedForDown;
        }

        public boolean isUsedForOver() {
            return this.usedForOver;
        }

        public void setSymbol(Symbol symbol) {
            this.symbol = symbol;
        }

        public void setTransform(Transform transform) {
            this.matrix = transform;
        }

        public void setColoring(AlphaTransform alphaTransform) {
            this.cxform = alphaTransform;
        }

        public void setDepth(int n) {
            this.depth = n;
        }

        public void usedForHitArea(boolean bl) {
            this.usedForHitArea = bl;
        }

        public void usedForUp(boolean bl) {
            this.usedForUp = bl;
        }

        public void usedForDown(boolean bl) {
            this.usedForDown = bl;
        }

        public void usedForOver(boolean bl) {
            this.usedForOver = bl;
        }

        public Layer(Symbol symbol, Transform transform, AlphaTransform alphaTransform, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            if (transform == null) {
                transform = new Transform();
            }
            if (alphaTransform == null) {
                alphaTransform = new AlphaTransform();
            }
            this.symbol = symbol;
            this.matrix = transform;
            this.cxform = alphaTransform;
            this.depth = n;
            this.usedForHitArea = bl;
            this.usedForUp = bl2;
            this.usedForDown = bl3;
            this.usedForOver = bl4;
        }

        protected ButtonRecord2 getRecord(Movie movie, SWFTagTypes sWFTagTypes, SWFTagTypes sWFTagTypes2) throws IOException {
            int n = this.symbol.define(movie, sWFTagTypes, sWFTagTypes2);
            int n2 = 0;
            if (this.usedForHitArea) {
                n2 |= 8;
            }
            if (this.usedForUp) {
                n2 |= 1;
            }
            if (this.usedForDown) {
                n2 |= 4;
            }
            if (this.usedForOver) {
                n2 |= 2;
            }
            return new ButtonRecord2(n, this.depth, this.matrix, this.cxform, n2);
        }
    }
}

