/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.video;

import com.anotherbigidea.flash.interfaces.SWFActionBlock;
import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.structs.Matrix;
import com.anotherbigidea.flash.video.ScreenVideoImageBlock;
import com.anotherbigidea.flash.writers.SWFWriter;
import com.anotherbigidea.flash.writers.TagWriter;
import com.anotherbigidea.io.InStream;
import com.anotherbigidea.io.OutStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class ScreenVideoPacket {
    private int imageWidth;
    private int imageHeight;
    private int blockWidth;
    private int blockHeight;
    private ScreenVideoImageBlock[] imageBlocks;

    public ScreenVideoPacket(int n, int n2, int n3, int n4, ScreenVideoImageBlock[] screenVideoImageBlockArray) {
        this.imageWidth = n;
        this.imageHeight = n2;
        this.blockWidth = n3;
        this.blockHeight = n4;
        this.imageBlocks = screenVideoImageBlockArray;
    }

    public ScreenVideoPacket(InStream inStream) throws IOException {
        this.blockWidth = (int)(inStream.readUBits(4) + 1L) * 16;
        this.imageWidth = (int)inStream.readUBits(12);
        this.blockHeight = (int)(inStream.readUBits(4) + 1L) * 16;
        this.imageHeight = (int)inStream.readUBits(12);
        ArrayList<ScreenVideoImageBlock> arrayList = new ArrayList<ScreenVideoImageBlock>();
        for (int i = 0; i < this.imageHeight; i += this.blockHeight) {
            for (int j = 0; j < this.imageWidth; j += this.blockWidth) {
                int n = Math.min(this.blockWidth, this.imageWidth - j);
                int n2 = Math.min(this.blockHeight, this.imageHeight - i);
                arrayList.add(new ScreenVideoImageBlock(inStream, n, n2));
            }
        }
        this.imageBlocks = arrayList.toArray(new ScreenVideoImageBlock[arrayList.size()]);
    }

    public int getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(int n) {
        this.blockHeight = n;
    }

    public int getBlockWidth() {
        return this.blockWidth;
    }

    public void setBlockWidth(int n) {
        this.blockWidth = n;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int n) {
        this.imageHeight = n;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int n) {
        this.imageWidth = n;
    }

    public ScreenVideoImageBlock[] getImageBlocks() {
        return this.imageBlocks;
    }

    public void setImageBlocks(ScreenVideoImageBlock[] screenVideoImageBlockArray) {
        this.imageBlocks = screenVideoImageBlockArray;
    }

    public void write(OutStream outStream) throws IOException {
        outStream.writeUBits(4, this.blockWidth / 16 - 1);
        outStream.writeUBits(12, this.imageWidth);
        outStream.writeUBits(4, this.blockHeight / 16 - 1);
        outStream.writeUBits(12, this.imageHeight);
        for (int i = 0; i < this.imageBlocks.length; ++i) {
            this.imageBlocks[i].write(outStream);
        }
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutStream outStream = new OutStream(byteArrayOutputStream);
        this.write(outStream);
        outStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static ScreenVideoPacket makeTestPattern() {
        int n;
        ScreenVideoImageBlock screenVideoImageBlock = ScreenVideoImageBlock.makeSquareOfSingleColor(255, 32);
        ScreenVideoImageBlock screenVideoImageBlock2 = ScreenVideoImageBlock.makeSquareOfSingleColor(0xFFFF00, 32);
        ScreenVideoImageBlock[] screenVideoImageBlockArray = new ScreenVideoImageBlock[72];
        for (n = 0; n < screenVideoImageBlockArray.length; n += 2) {
            screenVideoImageBlockArray[n] = screenVideoImageBlock2;
        }
        for (n = 1; n < screenVideoImageBlockArray.length; n += 2) {
            screenVideoImageBlockArray[n] = screenVideoImageBlock;
        }
        return new ScreenVideoPacket(288, 256, 32, 32, screenVideoImageBlockArray);
    }

    public static ScreenVideoPacket makeTestPatternDelta(int n) {
        ScreenVideoImageBlock screenVideoImageBlock = ScreenVideoImageBlock.makeSquareOfSingleColor(65280, 32);
        ScreenVideoImageBlock[] screenVideoImageBlockArray = new ScreenVideoImageBlock[72];
        for (int i = 0; i < screenVideoImageBlockArray.length; ++i) {
            screenVideoImageBlockArray[i] = i == n ? screenVideoImageBlock : ScreenVideoImageBlock.EMPTY_BLOCK;
        }
        return new ScreenVideoPacket(288, 256, 32, 32, screenVideoImageBlockArray);
    }

    public static void main(String[] stringArray) throws IOException {
        SWFWriter sWFWriter = new SWFWriter("ScreenVideoPacketTest.swf");
        TagWriter tagWriter = new TagWriter(sWFWriter);
        tagWriter.header(7, -1L, 16000, 12000, 12, -1);
        tagWriter.tagSetBackgroundColor(new Color(255, 0, 0));
        tagWriter.tagDefineVideoStream(1, 72, 288, 256, 0, 3);
        tagWriter.tagPlaceObject2(false, 0, 1, 1, new Matrix(), null, -1, null, 0);
        tagWriter.tagShowFrame();
        for (int i = 0; i < 72; ++i) {
            tagWriter.tagPlaceObject2(true, 0, 1, 0, null, null, i, null, 0);
            tagWriter.tagVideoFrame(1, i, i == 0 ? 1 : 2, 3, i == 0 ? ScreenVideoPacket.makeTestPattern().toBytes() : ScreenVideoPacket.makeTestPatternDelta(i - 1).toBytes());
            tagWriter.tagShowFrame();
        }
        SWFActions sWFActions = tagWriter.tagDoAction();
        SWFActionBlock sWFActionBlock = sWFActions.start(0);
        sWFActionBlock.end();
        sWFActions.done();
        tagWriter.tagShowFrame();
        tagWriter.tagEnd();
    }
}

