package org.richfaces.realworld.domain;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.hibernate.validator.Length;
import org.hibernate.validator.NotEmpty;
import org.hibernate.validator.NotNull;
import org.jboss.seam.annotations.Name;

@Entity
@Name("metaTag")
@Table(name = "metatags")
public class MetaTag implements Serializable{

	private static final long serialVersionUID = -9065024051468971330L;

	@Id
	@GeneratedValue
	@Column(name = "METATAG_ID")
	private Long id;
	
	@Column(length = 255, nullable = false)
    @NotNull
	@NotEmpty
    @Length(min=3)
	private String tag;
	
	@ManyToOne
    @JoinColumn(name="IMAGE_METATAG_ID",
    referencedColumnName="IMAGE_ID")
	private Image parent;

	public Long getId() {
		return id;
	}

	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}

	public Image getParent() {
		return parent;
	}

	public void setParent(Image image) {
		this.parent = image;
	}
}
