/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.realworld.fileupload;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import javax.faces.context.FacesContext;
import javax.imageio.ImageIO;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;

@Name("fileManager")
@Scope(ScopeType.CONVERSATION)
public class FileManager {

	private static final String UPLOAD_ROOT = "uploadRoot";
	private static final String FILE_SEPARATOR = "file.separator";
	private String uploadRoot;
	
	public String getUploadRoot() {
		return uploadRoot;
	}

	public void setUploadRoot(String uploadRoot) {
		this.uploadRoot = uploadRoot;
	}
	
	public FileManager(){
		FacesContext fc = FacesContext.getCurrentInstance();
		this.setUploadRoot(fc.getExternalContext().getInitParameter(UPLOAD_ROOT));
	}
	
	public String getFileSeparator() {
		return System.getProperty(FILE_SEPARATOR);
	}

	public boolean isDirectoryPresent(String directory) {
		String fullPath = getAbsolutePath(directory);
		File file = new File(fullPath);
		return file.exists() && file.isDirectory();
	}

	public void deleteDirectory(String directory) {
		String fullPath = getAbsolutePath(directory);
		File file = new File(fullPath);
		if(file.exists()){
			for(String f :file.list()){
				File temp = new File(fullPath+getFileSeparator()+f);
				temp.delete();
			}
			file.delete();
		}
	}

	public void renameDirectory(String directoryOld, String directoryNew){
		String fullPath = getAbsolutePath(directoryOld);
		File fileOld = new File(fullPath);
		File fileNew = new File(getUploadRoot() + directoryNew);
		createDirectoryIfNotExist(directoryNew);
		if(fileNew.exists())
			if( fileNew.isDirectory() ){
				//throw new Exception("exc");
			}else{
				fileNew.delete();
			}
		fileOld.renameTo(fileNew);
	}

	public void addDirectory(String directory) {
		String fullPath = getAbsolutePath(directory);
		File file = new File(fullPath);
		file.mkdirs();
	}

	public void addImage(String fileName, byte[] data) throws IOException {
		createDirectoryIfNotExist(fileName);
		writeFileTodisk(data, fileName, 0, 0, "" );
		writeFileTodisk(data, fileName, 50, 50, "_mini" );
		writeFileTodisk(data, fileName, 600, 400, "_medium" );
		//FileOutputStream b = new FileOutputStream(getUploadRoot() + fileName);
		//b.write(data);
		//b.close();
		/*InputStream inputStream = new ByteArrayInputStream(data);
		BufferedImage bsrc = ImageIO.read(inputStream);
		inputStream = new ByteArrayInputStream(data);
		bsrc = ImageIO.read(inputStream);
		ImageIO.write(bsrc, "JPG", new File(getUploadRoot() + fileName));
		int width = 50;
		int height = 50;
		BufferedImage bdest = new BufferedImage(width, height,
				BufferedImage.TYPE_INT_RGB);
		Graphics2D g = bdest.createGraphics();
		AffineTransform at = AffineTransform.getScaleInstance((double) width
				/ bsrc.getWidth(), (double) height / bsrc.getHeight());
		g.drawRenderedImage(bsrc, at);
		String dest = getUploadRoot() + transformPath(fileName, "_mini");
		ImageIO.write(bdest, "JPG", new File(dest));
		width = 600;
		height = 400;
		bdest = new BufferedImage(width, height,
				BufferedImage.TYPE_INT_RGB);
		g = bdest.createGraphics();
		at = AffineTransform.getScaleInstance((double) width
				/ bsrc.getWidth(), (double) height / bsrc.getHeight());
		g.drawRenderedImage(bsrc, at);
		dest = getUploadRoot() + transformPath(fileName, "_medium");
		ImageIO.write(bdest, "JPG", new File(dest));
		inputStream.close();*/
	}
	
	private void writeFileTodisk(byte[] data, String fileName, int width, int height, String format) throws IOException{
		InputStream inputStream = new ByteArrayInputStream(data);
		BufferedImage bsrc = ImageIO.read(inputStream);
		if(width == 0){
			String dest = getUploadRoot() + fileName;
			ImageIO.write(bsrc, "JPG", new File(dest));
			return;
		}
		BufferedImage bdest = new BufferedImage(width, height,
				BufferedImage.TYPE_INT_RGB);
		Graphics2D g = bdest.createGraphics();
		AffineTransform at = AffineTransform.getScaleInstance((double) width
				/ bsrc.getWidth(), (double) height / bsrc.getHeight());
		Map<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
		hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
		g.addRenderingHints(hints);
		g.drawRenderedImage(bsrc, at);
		
		String dest = getUploadRoot() + transformPath(fileName, format);
		ImageIO.write(bdest, "JPG", new File(dest));
		inputStream.close();
	}
	
	public String transformPath(String target, String substitute){
		String begin = target.substring(0, target.lastIndexOf("."));
		String end = target.substring(target.lastIndexOf("."));
		return begin + substitute + end;
	}

	public void deleteAllFromDirectory(String directory){
		String fullPath = getAbsolutePath(directory);
		File file = new File(fullPath);
		if(file.exists()){
			for(String f :file.list()){
				File temp = new File(fullPath+getFileSeparator()+f);
				temp.delete();
			}
		}else{
			file.mkdirs();
		}
	}
	
	public void deleteImage(String fileName) {
		String fullPath = getAbsolutePath(fileName);
		File file = new File(fullPath);
		if(file.exists()){
			file.delete();
		}
		file = new File(transformPath(fullPath, "_mini"));
		if(file.exists()){
			file.delete();
		}
		file = new File(transformPath(fullPath, "_medium"));
		if(file.exists()){
			file.delete();
		}
	}

	public void renameImage(String fileNameOld, String fileNameNew) {
		createDirectoryIfNotExist(fileNameNew);
		String fullPath = getAbsolutePath(fileNameOld);
		File fileOld = new File(fullPath);
		File fileNew = new File(getAbsolutePath(fileNameNew));
		if(fileNew.exists()){
			fileNew.delete();
		}
		fileOld.renameTo(fileNew);
		fileOld = new File(transformPath(fullPath, "_mini"));
		fileNew = new File(getAbsolutePath(transformPath(fileNameNew, "_mini")));
		if(fileNew.exists()){
			fileNew.delete();
		}
		fileOld.renameTo(fileNew);
		fileOld = new File(transformPath(fullPath, "_medium"));
		fileNew = new File(getAbsolutePath(transformPath(fileNameNew, "_medium")));
		if(fileNew.exists()){
			fileNew.delete();
		}
		fileOld.renameTo(fileNew);
	}

	private void createDirectoryIfNotExist(String fileNameNew) {
		int lastIndexOf = fileNameNew.lastIndexOf(getFileSeparator());
		if(lastIndexOf > 0){
			String directory = fileNameNew.substring(0, lastIndexOf);
			File file = new File(getUploadRoot()+directory);
			if(!file.exists()){
				file.mkdirs();
			}
		}
	}

	public boolean isImagePresent(String fileName) {
		String fullPath = getAbsolutePath(fileName);
		File file = new File(fullPath);
		return file.exists() && !file.isDirectory();
	}
	
	public File getImage(String fileName){
		if(isImagePresent(fileName)){
			return new File(getAbsolutePath(fileName));
		}
		return null;
	}

	private String getAbsolutePath(String fileName) {
		return getUploadRoot() + fileName;
	}
	
	public String transformToServerPath(String filename){
		String[] res = filename.split("/");
		StringBuilder sb = new StringBuilder();
		sb.append(res[0]);
		for(int i = 1; i < res.length; i++){
			sb.append(this.getFileSeparator() + res[i]);
		}
		String string = sb.toString();
		return string;
	}
}
