/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.realworld.manager;

import java.io.IOException;
import java.io.Serializable;

import javax.faces.application.FacesMessage;
import javax.faces.application.FacesMessage.Severity;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.End;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.log.Log;
import org.jboss.seam.security.Identity;
import org.richfaces.realworld.domain.User;
import org.richfaces.realworld.fileupload.AvatarUpload;
import org.richfaces.realworld.fileupload.FileManager;
import org.richfaces.realworld.navigation.NavigationEnum;
import org.richfaces.realworld.service.IUserAction;
import org.richfaces.realworld.util.SelectionHelper;

@Name("authenticator")
@Scope(ScopeType.CONVERSATION)
public class Authenticator implements Serializable
{

	@In("#{messages['user.exist']}") private String USER_WITH_THIS_LOGIN_ALREADY_EXIST;

	@In("#{messages['user.confirm.error']}") private String CONFIRM_PASSWORD_NOT_EQUALS_PASSWORD;

	private static final String REGISTER_LOGIN_NAME_ID = "register:loginName";

	private static final String REGISTER_CONFIRM_PASSWORD_ID = "register:confirmPassword";

	private static final String INDEX_OUTCOME = "index";

	private static final String ADMIN_ROLE = "admin";

	private static final String GUEST_ROLE = "guest";

	private static final String UPDATE_MAIN_AREA_EVENT = "updateMainArea";

	private static final long serialVersionUID = -4585673256547342140L;

	@Logger Log log;
    
    @In Identity identity;
	
    @In FacesMessages facesMessages;
    
    @In(create = true)
    IUserAction userAction;
    
    @In(create = true)
    FileManager fileManager;
    
    @In(create = true)
    AvatarUpload avatarUpload;
    
	@In(create=true) @Out
	private SelectionHelper selectionHelper;
    
    /* (non-Javadoc)
	 * @see org.richfaces.realworld.service.IAuthenticator#authenticate()
	 */
    public boolean authenticate()
    {
    	if(null == identity.getUsername() || identity.getUsername().equals("")){
    		identity.addRole(GUEST_ROLE);
        	Events.instance().raiseEvent(UPDATE_MAIN_AREA_EVENT, NavigationEnum.SEARCH);
        	userAction.loginAnonymous();
        	return true;
    	}
        try{
        	User user = userAction.login(identity.getUsername(), identity.getPassword());
        if(user != null){
        	identity.addRole(ADMIN_ROLE);
        	if(!fileManager.isDirectoryPresent(identity.getUsername())){
        		fileManager.addDirectory(identity.getUsername());
        	}
        	if(user.getChildAlbums().size() > 0){
        		selectionHelper.setSelectedAlbum(user.getChildAlbums().get(0));
        		//if(selectionHelper.getSelectedAlbum().getImages().size() > 0){
        			//selectionHelper.setSelectedImage(selectionHelper.getSelectedAlbum().getImages().get(0));
        		//}
        	}
        	Events.instance().raiseEvent(UPDATE_MAIN_AREA_EVENT, NavigationEnum.IMAGE_PREVIEW);
        	return true;
        }
        }catch(Exception nre){
        	facesMessages.add("Invalid login or password");
        	return false;
        }
        return false; 
    }
    
    @End
    public String register(User user){
    	boolean errorHappened = false;
    	if(!user.getPassword().equals(user.getConfirmPassword())){
    		UIComponent root = FacesContext.getCurrentInstance().getViewRoot();
    		UIComponent component = root.findComponent(REGISTER_CONFIRM_PASSWORD_ID);
			FacesContext.getCurrentInstance().addMessage(component.getClientId(FacesContext.getCurrentInstance()), new FacesMessage(
					FacesMessage.SEVERITY_ERROR, CONFIRM_PASSWORD_NOT_EQUALS_PASSWORD , CONFIRM_PASSWORD_NOT_EQUALS_PASSWORD));
			errorHappened = true;
    	}
    	if(userAction.isUserExist(user.getLogin())){
    		UIComponent root = FacesContext.getCurrentInstance().getViewRoot();
    		UIComponent component = root.findComponent(REGISTER_LOGIN_NAME_ID);
			FacesContext.getCurrentInstance().addMessage(component.getClientId(FacesContext.getCurrentInstance()), new FacesMessage(
					FacesMessage.SEVERITY_ERROR, USER_WITH_THIS_LOGIN_ALREADY_EXIST , USER_WITH_THIS_LOGIN_ALREADY_EXIST));
			errorHappened = true;
    	}
    	if(errorHappened){
    		return "";
    	}
    	userAction.register(user);
    	if(avatarUpload.getAvatarItem() != null){
    		user.setAvatarPath(avatarUpload.getAvatarItem().getImage().getName());
    		fileManager.deleteDirectory(user.getLogin() + fileManager.getFileSeparator() + "avatars");
    		fileManager.addDirectory(user.getLogin() + fileManager.getFileSeparator() + "avatars");
    		try {
				fileManager.addImage(user.getLogin() + fileManager.getFileSeparator() + "avatars" + fileManager.getFileSeparator() + user.getAvatarPath(), avatarUpload.getAvatarItem().getData());
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
    	}

		String messageTemplate = "You are successfully registered.";
		facesMessages.add(messageTemplate);
    	return INDEX_OUTCOME;
    }
}
