package org.richfaces.realworld.servlet;

public class WebUtil {

    public static String getFileName(String path) {
        // Path format is "/file_name.jpg"
        if (path != null && path.length() > 1) {
            String fileName = path.substring(1);
            int dotIndex = fileName.indexOf('.');
            String extention = fileName.substring(dotIndex + 1);
            if (extention.equals(Extention.jpg.getExtention())
                    || extention.equals(Extention.jpeg.getExtention()))
            {
                return fileName;
            }
        }
        return null;
    }

    enum Extention {
        jpg("jpg"), jpeg("jpeg");

        Extention(String extention) {
            this.extention = extention;
        }

        private String extention;

        String getExtention() {
            return this.extention;
        }
    }
}