/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.realworld.util;

import java.io.Serializable;
import java.util.Date;

import javax.faces.event.ActionEvent;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.richfaces.realworld.domain.Message;
import org.richfaces.realworld.domain.User;
import org.richfaces.realworld.manager.UserManager;

@Name("messagePanelHelper")
@Scope(ScopeType.CONVERSATION)
public class MessagePanelHelper implements Serializable{

	private static final long serialVersionUID = 2561824019376412988L;
	
	private boolean sendRequired;
	
	private boolean messageSelected;
	
	private boolean searchRequired = false;
	
	@In
	private User user; 
	
	@Out(required=false)
	private Message message;
	
	@In(create=true, required=true) @Out
	private UserManager userManager;
	
	public void closeMessage(){
		this.setMessageSelected(false);
	}
	
	public void initReMessage(boolean sendRequired, Message message){
		this.sendRequired = sendRequired;
		this.message = new Message();
		this.message.setTheme("Re:" + message.getTheme());
		this.message.setAuthor(user);
		this.message.setOwner(message.getAuthor());
		this.message.setReaded(false);
		this.searchRequired = false;
		this.setMessageSelected(true);
	}
	
	public void initMessage(boolean sendRequired, Message message, boolean userSearchRequired){
		this.sendRequired = sendRequired;
		this.searchRequired = userSearchRequired;
		this.message = new Message();
		this.message.setAuthor(user);
		this.message.setReaded(false);
		this.setMessageSelected(true);
	}
	
	public void initMessage(boolean sendRequired, Message message){
		this.sendRequired = sendRequired;
		this.message = message;
		this.message.setReaded(true);
		this.searchRequired = false;
		userManager.setCountUnreadedMessages(null);
		this.setMessageSelected(true);
	}
	
	public void initMessage(boolean sendRequired, User owner){
		this.sendRequired = sendRequired;
		this.message = new Message();
		this.message.setAuthor(user);
		this.message.setOwner(owner);
		this.message.setReaded(false);
		this.searchRequired = false;
		this.setMessageSelected(true);
	}
	
	public void initMessage(boolean sendRequired, User owner, String theme, String message){
		this.sendRequired = sendRequired;
		this.message = new Message();
		this.message.setAuthor(user);
		this.message.setOwner(owner);
		this.message.setReaded(false);
		this.message.setTheme(theme);
		this.message.setMessage(message);
		this.searchRequired = false;
		this.setMessageSelected(true);
	}
	
	public void initMessage(boolean sendRequired, User owner, String theme, String message, boolean friendshipRequest){
		this.sendRequired = sendRequired;
		this.message = new Message();
		this.message.setAuthor(user);
		this.message.setOwner(owner);
		this.message.setReaded(false);
		this.message.setTheme(theme);
		this.message.setMessage(message);
		this.message.setFriendshipRequest(friendshipRequest);
		this.searchRequired = false;
		this.setMessageSelected(true);
	}
	
	public void sendMessage(ActionEvent event){
		this.message.setDate(new Date());
		userManager.sendMessage(this.message);
		this.setMessageSelected(false);
	}

	public boolean isSendRequired() {
		return sendRequired;
	}

	public void setSendRequired(boolean sendRequired) {
		this.sendRequired = sendRequired;
	}

	public boolean isSearchRequired() {
		return searchRequired;
	}

	public void setSearchRequired(boolean searchRequired) {
		this.searchRequired = searchRequired;
	}

	public boolean isMessageSelected() {
		return messageSelected;
	}

	public void setMessageSelected(boolean messageSelected) {
		this.messageSelected = messageSelected;
	}
}
