/**
 * License Agreement.
 *
 * JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */ 
package org.richfaces.testng;

import org.ajax4jsf.template.Template;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InplaceSelectTest extends InplacesTest {
	
    @Test
    public void testInplaceSelectComponent(Template template) {
        renderPage(template);

        String parentId = getParentId() + "_form:";
        String inplaceSelectId = parentId + "inplaceSelect";
        String okButton = parentId + "inplaceSelect" + "ok";
        //String inplaceTmpValueElemId = parentId + "inplaceSelect" + "inplaceTmpValue";
        String cancelButton = parentId + "inplaceSelect" + "cancel";
        String popupId = "list" + inplaceSelectId;

        writeStatus("click the component");

        clickById(inplaceSelectId);
        Assert.assertFalse(isVisibleById(popupId), "Component pop-up should not show up on solitary click");

        writeStatus("double click the component");

        selenium.doubleClick(inplaceSelectId);
        Assert.assertTrue(isVisibleById(popupId), "Component pop-up should show up on double click");

        writeStatus("Check that controls buttons are present");

        Assert.assertTrue(isPresentById(okButton));
        Assert.assertTrue(isPresentById(cancelButton));

        writeStatus("Select second element"); //Birch

        selenium.mouseMove("xpath=//div[@id='list" + inplaceSelectId + "']/span[2]");
        selenium.mouseDown(okButton);

        writeStatus("Check that a new element is selected");

        AssertValueEquals(inplaceSelectId + "inplaceValue", "Birch");

        writeStatus("Select another element"); // Aspen

        selenium.doubleClick(inplaceSelectId);

        selenium.mouseMove("xpath=//div[@id='list" + inplaceSelectId + "']/span[3]");
        selenium.mouseDown(cancelButton);

        writeStatus("Cancel selected value.");
        AssertValueEquals(inplaceSelectId + "inplaceValue", "Birch", "A value has not to be changed");

        writeStatus("Verify javascript event triggering");

        runScript("theLatestEvent='undefined'");

        writeStatus("Double click the component");
        selenium.doubleClick(inplaceSelectId);

        Assert.assertEquals(runScript("theLatestEvent"), "editactivated", "editactivated event has not been triggered");

        writeStatus("Stop editing with ok");
        selenium.mouseDown(okButton);
        Assert.assertEquals(runScript("theLatestEvent"), "viewactivated", "viewactivated event has not been triggered");

        writeStatus("Stop editing with cancel");
        selenium.mouseDown(cancelButton);
        Assert.assertEquals(runScript("theLatestEvent"), "viewactivated", "viewactivated event has not been triggered");
    }

    protected void testJSApiSetValue() {
    	selenium.getEval("window.inplace.setValue(\"\", {itemValue: \"JSApi\", itemLabel : \"JSApi\"})");
        Assert.assertTrue("JSApi".equals(selenium.getEval("window.inplace.getValue()")));
    }
    
    @Override
	public void setTestUrl(String testUrl) {
		this.testUrl = "pages/inplaceSelect/" + testUrl;
	}
	
	public void initIds() {
		super.initIds();
		inplaceValuePrefix = "inplaceValue";
		inplaceId = formId + "ii";
		iTempValuePx = "inplaceTmpValue";
	}

	protected void setValue(String id, String newValue) {
		selenium.runScript("($('" + id + "')).component.setValue(\"\", {itemValue: \""+ newValue + "\", itemLabel : \"" + newValue + "\"})");
	}
}
