header
{
	package org.richfaces.antlr;
}

{	
	import org.jboss.seam.text.SeamTextParser.DefaultSanitizer;
	import org.jboss.seam.text.SeamTextParser.Sanitizer; 
}

class HtmlSeamTextParser extends Parser;

options
{
    k=4;
    defaultErrorHandler=false;
}

{	 
	
	
	public class HtmlRecognitionException extends RecognitionException {
		Token openingElement;
		RecognitionException wrappedException;

		public HtmlRecognitionException(Token openingElement, RecognitionException wrappedException) {
			this.openingElement = openingElement;
			this.wrappedException = wrappedException;
		}

		public Token getOpeningElement() {
			return openingElement;
		}

		public String getMessage() {
			return wrappedException.getMessage();
		}

		public Throwable getCause() {
			return wrappedException;
		}
	}
	
	    
    private final String  SEAMTEXT_MONOSPACE = "|";
    
    private final String  SEAMTEXT_TWIDDLE = "~";
    
    private final String  SEAMTEXT_HASH = "#";
    
    private final String  SEAMTEXT_HAT = "^";
    
    private final String  SEAMTEXT_PLUS = "+";
    
    private final String  SEAMTEXT_STAR = "*";
    
    private final String  SEAMTEXT_UNDERSCORE = "_";
    
    private final String  SEAMTEXT_EQ = "=";
    
    private final String  SEAMTEXT_BACKTICK = "`";
    
    private final String  BLANK_LINE = "\n\n";
    
    private final String  SEAM_DOUBLEQUOTE = "\"";
    
    private final String  SEAM_OPEN = "[";
    
    private final String  SEAM_CLOSE = "]";
    
    private final String  SEAM_GT = ">";
    
    public boolean preformatted = false;
    
    protected java.util.Set<String> seamTextSymbols = 	new java.util.HashSet(java.util.Arrays.asList(
		SEAMTEXT_MONOSPACE, SEAMTEXT_TWIDDLE, SEAMTEXT_HASH, SEAMTEXT_HAT, SEAMTEXT_PLUS, SEAMTEXT_STAR, 
		SEAMTEXT_UNDERSCORE, SEAMTEXT_EQ, SEAMTEXT_BACKTICK, BLANK_LINE, SEAM_DOUBLEQUOTE, SEAM_OPEN,
		SEAM_CLOSE, SEAM_GT 
	));
            
   	protected java.util.Set<String> htmlSeamTextElements = new java.util.HashSet(java.util.Arrays.asList(
		"del", "sup", "pre","p", "q" ,"h1" ,"h2" ,"h3" ,"h4" ,"ul" ,"ol" ,"li" ,"i" ,"tt" ,"u" ,"a","blockqoute"));
		
	protected java.util.Set<String> simpleHtmlSeamTextElements = new java.util.HashSet(java.util.Arrays.asList(
		"del", "sup", "pre", "q", "i" ,"tt" ,"u"));	
		
	protected 	java.util.Set<String> formattedHtmlSeamTextElements = new java.util.HashSet(java.util.Arrays.asList(
		"ul", "ol", "li", "h1", "h2", "h3", "h4", "a", "p", "blockqoute"));
		
	private Sanitizer sanitizer = new DefaultSanitizer();
	
	private java.util.Stack<Token> htmlElementStack = new java.util.Stack<Token>();
	
	private StringBuilder mainBuilder = new StringBuilder();
	
	private String linkHolder;
	
	private int newlines;
	
	private boolean isHeaderProcessed = false;
	
	private StringBuilder builder = mainBuilder;
	
	public StringBuilder valueCollector;
	
	
	public void setSanitizer(Sanitizer sanitizer) {
       this.sanitizer = sanitizer;
    }
	
	
	public String toString() {
        return builder.toString();
    }
	
	
	private void beginCapture() {
        builder = new StringBuilder();
    }
    
    
    private String endCapture() {
        String result = builder.toString();
        builder = mainBuilder;
        return result;
    }
	
	
	private void append(String... strings) {
        for (String string: strings) builder.append(string);
    }
    
   	    
   	public boolean isLink(Token token) {
   		String name = token.getText().toLowerCase();
   		return "a".equals(name);
   	}
   	 
   	   	
   	private String createSeamTextLink(String link, String value) {
   		
   		StringBuilder builder = new StringBuilder();
   		builder.append("[");
   		
   		if (value != null) {
   			builder.append(value.trim());
   		} 
   		   		  		
   		builder.append("=>");
   		builder.append(link);
   		builder.append("]");
   		
   		return builder.toString();
   		
   	}
   	
   	
   	public boolean isHeader(Token token) {
   		String name = token.getText().toLowerCase();
   		return ("h1".equals(name) || "h2".equals(name) || "h3".equals(name) || "h4".equals(name));  
   	}
   	
   	   	
   	public String createSeamTextHeader(Token token) throws SemanticException {
   		
   		String name = token.getText();
   		StringBuilder seamHeader = new StringBuilder(); 
 		
		if("h1".equals(name)) {
			seamHeader.append(BLANK_LINE).append(SEAMTEXT_PLUS);
   		} else if("h2".equals(name)) {
   			seamHeader.append(BLANK_LINE).append(SEAMTEXT_PLUS).append(SEAMTEXT_PLUS);
   		} else if("h3".equals(name)) {
   			seamHeader.append(BLANK_LINE).append(SEAMTEXT_PLUS).append(SEAMTEXT_PLUS).append(SEAMTEXT_PLUS);
   		} else if("h4".equals(name)) {
   			seamHeader.append(BLANK_LINE).append(SEAMTEXT_PLUS).append(SEAMTEXT_PLUS).append(SEAMTEXT_PLUS).append(SEAMTEXT_PLUS);
   		}
   		
   		return seamHeader.toString();
   	}
   	
   	public boolean isParagraph(Token token) {
		String name = token.getText().toLowerCase();
   		return "p".equals(name) ;  
	}
	
   	public String checkHeaderMarkup() throws TokenStreamException{
   		
   		int i = 0;
   		StringBuilder result = new StringBuilder();
   		Token  token;
   	
   		boolean containText = false; 
   	 	
	   	do {
			i++;
			token = LT(i);
			if (token.getType() == ALPHANUMERICWORD) {
			
				if (!isHeader(token)) {
					result.append("\n");
					containText = true;
				}   
				
				break;
			}
			   			   	 			
		} while ( token.getType() != EOF);
		
								
		if (!containText) {
			result.append("\n").append("<span></span>");
		} 
		return result.toString();
	}
	
	
		
		
	public String checkParagraphMarkup() throws TokenStreamException{
		int i = 0;
		Token token;
		do {
			i++;
			token = LT(i);
			if (token.getType() == ALPHANUMERICWORD) {
				if(!(isParagraph(token) || isHeader(token) || isList(token))) {
					return BLANK_LINE;
				}  
				break ;
			}	
			
		}while(token.getType() != EOF);
		return "";	
	}
   	
   	public String checkListMarkup() throws TokenStreamException {
  		int i = 0;
		Token token;
		do {
			i++;
			token = LT(i);
			if (token.getType() == ALPHANUMERICWORD) {
				if(!(isParagraph(token) || isHeader(token))) {
					return BLANK_LINE;
				}
				break;	
			
			}	
			
		}while(token.getType() != EOF);
		return "";
  	  		 		
   	}
   	
   	public String checkListItemMarkup() throws TokenStreamException {
   		int i = 0;
		Token token;
		do {
			i++;
			token = LT(i);
			if (token.getType() == ALPHANUMERICWORD) {
				if(isList(token)) {
					return "";
				} else if(isListItem(token)) {
					return "\n";
				}
				break;	
			}	
			
		}while(token.getType() != EOF);
		return "";
   	}
   	
   	public boolean isList(Token token){
    	String name = token.getText();
    	return ("ul".equals(name) || "ol".equals(name));
    }
    
   	  	
   	public boolean isListItem(Token token) {
   		String name = token.getText().toLowerCase();
   		return "li".equals(name);
   	}
   	
   	  	
   	public String createSeamTextList(Token token, java.util.Stack <Token> htmlElementStack) throws SemanticException {
		String seamText = null;
   		
   		Token parent = htmlElementStack.peek();
   		String parentName = parent.getText().toLowerCase();
		if(parentName.equals("ul")) {
			seamText = SEAMTEXT_EQ;
		} else if (parentName.equals("ol")){
			seamText = SEAMTEXT_HASH;
		} else {
			String message = "<li> must follow <ol> or <ul> not <" + parent.getText() + ">";
			throw new SemanticException( message, parent.getFilename(), parent.getLine(), parent.getColumn());
		}
   		
   		return seamText != null ? seamText : "";
   	}
   	
   	
   	public boolean isPlainHtmlRequired(Token name, java.util.Stack <Token> htmlElementStack) throws SemanticException {

   		if(!isSeamTextElement(name)) {
   			return true;
   		}
   		
   		if(isSimpleSeamTextElement(name)) {
   			return false;
   		}
   		
   		if(isHeader(name) && !htmlElementStack.isEmpty()) {
   			return true;
   		}
   		   		   		  		   		
   		if(!htmlElementStack.isEmpty() && !"a".equals(name.getText().toLowerCase()) && !"p".equals(name.getText().toLowerCase())) {
			for(Token token : htmlElementStack) {
				if(isHeader(token) || isListItem(token)) {
					return true;
				}
			}
		}
   		   		
   		return false;
   	}
    
     
   	
   	public String getSimpleSeamText(Token token) throws SemanticException,TokenStreamException{
    
    	String name = token.getText().toLowerCase();
		StringBuilder seamText = new StringBuilder();
	
		if("tt".equals(name)) {
			seamText.append(SEAMTEXT_MONOSPACE); 
		} else if("del".equals(name)) {
			seamText.append(SEAMTEXT_TWIDDLE);
		} else if("i".equals(name)) {
			seamText.append(SEAMTEXT_STAR); 
		} else if("sup".equals(name)) {
			seamText.append(SEAMTEXT_HAT); 
		} else if("u".equals(name)) {
			seamText.append(SEAMTEXT_UNDERSCORE);
		} else if("pre".equals(name)) {
			seamText.append(SEAMTEXT_BACKTICK);	
		} else if("q".equals(name)) {
			seamText.append(SEAM_DOUBLEQUOTE);
		} 						
		return seamText.toString();
	  	
    }
    
    
	public String escapeSeamText(Token token,  boolean preformatted) throws TokenStreamException {
   		
   		StringBuilder result = new StringBuilder();
		String tokenName = token.getText();
		
		if(preformatted) {
			if ("&lt;".equals(tokenName)) {
				result.append("<");
			} else if("&amp;".equals(tokenName)) {
				result.append("&");
			} else if ("&gt;".equals(tokenName)) {
				result.append(">");
			} else if("&quot;".equals(tokenName)){
				result.append("\"");
			} else if(seamTextSymbols.contains(tokenName)) {
				result.append(tokenName);
			}
				
		} else {
		
			if ("&lt;".equals(tokenName)) {
				result.append("\\<");
			} else if("&amp;".equals(tokenName)) {
				result.append("&");
			} else if ("&gt;".equals(tokenName)) {
				result.append("\\>");
			} else if("&quot;".equals(tokenName)){
				result.append("\"");
			} else if("\\".equals(tokenName)){
				result.append("\\\\");
			}else if(seamTextSymbols.contains(tokenName)) {
				result.append("\\").append(tokenName);
			}
		} 
		  		
   	 	return result.toString();	
	}
	    
        
    public boolean isSeamTextElement(Token element){
		String name = element.getText().toLowerCase();
		return htmlSeamTextElements.contains(name);
    }
	
	    
    public boolean isSimpleSeamTextElement(Token element){
		String name = element.getText().toLowerCase();
		return simpleHtmlSeamTextElements.contains(name);
    }
    
    
    public boolean isFormattedHtmlSeamTextElement(Token element) {
    	String name = element.getText().toLowerCase();
		return formattedHtmlSeamTextElements.contains(name);
    }
    
    
    public boolean isPreFormattedElement(Token element) {
    	String name = element.getText().toLowerCase();
    	return ("pre".equals(name) || "tt".equals(name));
    }
    
}


startRule: (NEWLINE)* (text eof)?
	;	
	

text: ((seamCharacters|plain|html|htmlSpecialChars) (NEWLINE 
	{
		Token token = LT(2);
		if(!isParagraph(token) && isHeaderProcessed) {
			isHeaderProcessed = false;
		} 

	}
	
	)*)+
	;

plain: (word|punctuation|space:SPACE {
	 	append(space.getText());}
		)

	{	
		Token token = LT(2);
		if(!isParagraph(token) && isHeaderProcessed) {
			isHeaderProcessed = false;
		} 		
	}	
	;

word: an:ALPHANUMERICWORD { append( an.getText() ); } | uc:UNICODEWORD { append( uc.getText() ); }
    ;

htmlSpecialChars: 
	 DOUBLEQUOTE { append("\""); } 
    | lt:ESCAPED_LT {append(escapeSeamText(lt, preformatted));}
    | gt:ESCAPED_GT {append(escapeSeamText(gt, preformatted));}
    | amp:ESCAPED_AMP {append(escapeSeamText(amp, preformatted));}
    | qout:ESCAPED_QOUT {append(escapeSeamText(qout, preformatted));}
    | nbsp:ESCAPED_NBSP {append(" ");}	  
     
    ;
eof: EOF;

punctuation: p:PUNCTUATION { append( p.getText() ); }
           | sq:SINGLEQUOTE { append( sq.getText() ); }
           | s:SLASH { append( s.getText() ); }
    ;

specialChars:
          st:STAR {append( st.getText() ); } 
        | b:BAR { append( b.getText() ); }
        | h:HAT { append( h.getText() ); }
        | p:PLUS { append( p.getText() ); }
        | eq:EQ { append( eq.getText() ); }
        | hh:HASH { append( hh.getText() ); }
        | e:ESCAPE { append( e.getText() ); }
        | t:TWIDDLE { append( t.getText() ); }
        | u:UNDERSCORE { append( u.getText() ); }
    ;


seamCharacters:  
				hat:HAT {append(escapeSeamText(hat, preformatted));}
			| 	hash:HASH {append(escapeSeamText(hash, preformatted));}
			|	open:OPEN {append(escapeSeamText(open, preformatted)) ;}
			|	close:CLOSE {append(escapeSeamText(close, preformatted));}
			|	twiddle:TWIDDLE {append(escapeSeamText(twiddle, preformatted));}
			|	bar:BAR {append(escapeSeamText(bar, preformatted));}
			|	eq:EQ {append(escapeSeamText(eq, preformatted));}
			|	plus:PLUS {append(escapeSeamText(plus, preformatted));}
			|	backtick:BACKTICK {append(escapeSeamText(backtick, preformatted));}
			|	st:STAR {append(escapeSeamText(st, preformatted));}
    	    | 	e:ESCAPE {append(escapeSeamText(e, preformatted));}	
			|	gt:GT {append(escapeSeamText(gt, preformatted));}
			;

space: s:SPACE { 
		if(!htmlElementStack.isEmpty()) {
			Token token = htmlElementStack.pop();
			if(isPlainHtmlRequired(token, htmlElementStack)) {
				append(s.getText());
			} 
			htmlElementStack.push(token);	
		} 
	}
    ;
    
newline: n:NEWLINE { if (preformatted && valueCollector!=null) valueCollector.append(n.getText());}
	;
	
newlineOrEof: newline | EOF
	;

html: openTag ( space | space attribute )* ( ( beforeBody body closeTagWithBody ) | closeTagWithNoBody)
	;

   
body: (

		
	(
	
	{	
		beginCapture();
		Token token = htmlElementStack.peek();
	} 
	
	
	(
	seamCharacters|plain|htmlSpecialChars 
	
		{
			if(isLink(token)) {
		 		String message = "Unexpected token " + "<" + token.getText() + ">";
				throw new SemanticException(message);
		 	}
		 		 	
		}
	 )	 
	
	  {	
	  	
	  	String plain = endCapture();
	 	if(valueCollector == null) {
	 		valueCollector = new StringBuilder();
	 	}
	 	if(!isList(token)) {
	 		
	 		valueCollector.append(plain);
	 	}
	 	
	   }
	 |html
	 	{
	 		 		 	
	 	if(valueCollector != null) {
	 		append(valueCollector.toString());
	 	}
	 	
	 	}
	 |newline
	 	)*) 
    ;

openTag:
      LT name:ALPHANUMERICWORD
      {
         sanitizer.validateHtmlElement(name);
                         
         Token token = null;
         
         if(isPreFormattedElement(name)) {
         	preformatted = true;
         } 
                  
         if(!isPlainHtmlRequired(name, htmlElementStack)) {
         	
         	if (isFormattedHtmlSeamTextElement(name)) {
         		
         		if(isLink(name) && valueCollector != null) {
         			append(valueCollector.toString());
         			valueCollector = null; 
         		}if(isList(name)) {
         			append(BLANK_LINE);
         		} else if (isListItem(name)) {
         			append(createSeamTextList(name, htmlElementStack));
	         	} else if (isHeader(name)) {
	         		append(createSeamTextHeader(name));
	         	}else if(isParagraph(name) && !isHeaderProcessed) {
	         		if(!isHeaderProcessed) {
	         			append(BLANK_LINE);
	         		}
	         	} 
	         	
         	} else if(isSimpleSeamTextElement(name)) {
         		if(valueCollector != null) {
					append(valueCollector.toString());
					valueCollector = null;
				} 
           		append(getSimpleSeamText(name));
         	}	
         	
         } else {
         	         	
         	if(valueCollector != null) {
        		append(valueCollector.toString());
         		valueCollector = null;
			}
			append("<");
			append(name.getText());
         }
 			
         htmlElementStack.push(name);
                   
      }
    ;
    exception 
        catch [RecognitionException ex] {
            if (htmlElementStack.isEmpty()) throw ex;
            Token tok = htmlElementStack.peek();
            if (tok != null) {
                throw new HtmlRecognitionException(tok, ex);
            } else {
                throw ex;
            }
        }


beforeBody: GT { 
		Token name = htmlElementStack.pop();
 		if((isPlainHtmlRequired(name,htmlElementStack))) {
			append(">");
		} else {
			Token token = LT(1);
			if((isListItem(name) || isHeader(name)) && (token.getType() != SPACE)) {
				append(" ");
			}
		}
		htmlElementStack.push(name);
	  }
    ;
    exception 
        catch [RecognitionException ex] {
            if (htmlElementStack.isEmpty()) throw ex;
            Token tok = htmlElementStack.peek();
            if (tok != null) {
                throw new HtmlRecognitionException(tok, ex);
            } else {
                throw ex;
            }
        }

closeTagWithBody:
      LT SLASH name:ALPHANUMERICWORD GT
      {	
      	 Token token = htmlElementStack.pop();
      	 if(!token.getText().equals(name.getText())) {
      	 	throw new RecognitionException("Can not convert to the Seam Text:  </" +token.getText() + ">" + " expected");
      	 }
      	 String value = "";
      	 if(valueCollector != null) {
      	 	value = valueCollector.toString();
      	 }
      	 
      	 if(!isPlainHtmlRequired(name, htmlElementStack)) {
      	 	if(isFormattedHtmlSeamTextElement(name)) {
      	 	 	if(isLink(name)){
					append(createSeamTextLink(linkHolder,value.trim()));				
				} else if(isParagraph(name)) {
							append(value);
							if(isHeaderProcessed) {
	         					isHeaderProcessed = false;
	         				} 
	         				append(checkParagraphMarkup());
	         				
					
				} else {
					append(value);
				}
	      	 	
				if(isList(name)) {
					append(checkListMarkup());
				} else if(isListItem(name)) {
					append(checkListItemMarkup());
				} else if(isHeader(name)) {
					append(checkHeaderMarkup());
					isHeaderProcessed = true;
				} 
	         	
      	 	} else if(isSimpleSeamTextElement(name)) {
	      	 	append(value.trim());
    	  	 	append(getSimpleSeamText(name));
      	 	}     	 
      	 } else {
      	 	append(value);
      	 	append("</");
         	append(name.getText());
         	append(">");
      	 }
      	 
         valueCollector = null;
         
         if(isPreFormattedElement(name)) {
         	preformatted = false;
         }
      }
    ;

closeTagWithNoBody:
      SLASH GT
      {  append("/>");
         htmlElementStack.pop();
      }
    ;

attribute: att:ALPHANUMERICWORD (space)* EQ (space)*
           DOUBLEQUOTE
           {
           	   Token token = htmlElementStack.pop(); 	 
               sanitizer.validateHtmlAttribute(token, att);
//               boolean isSeamTextProcessed = isSeamTextElement(token);
               boolean isPlainHtmlRequired = isPlainHtmlRequired(token, htmlElementStack);
              
               if (isPlainHtmlRequired) {
           	   		append(att.getText());
           	   		append("=\"");
               }
               beginCapture(); 
           }
           attributeValue
           {
           	   String attValue = endCapture();
			   sanitizer.validateHtmlAttributeValue(token, att, attValue);
                            
               if (isPlainHtmlRequired) {
               		append(attValue);
               } else if(isLink(token) && "href".equals(att.getText())) {
               		
               		linkHolder = attValue;               	
               }
                       
           }
           DOUBLEQUOTE { 
	           	if(isPlainHtmlRequired) {
	           		append("\"");
	           	}
	           	htmlElementStack.push(token);
        	}
    ;
    exception 
        catch [RecognitionException ex] {
            if (htmlElementStack.isEmpty()) throw ex;
            Token tok = htmlElementStack.peek();
            if (tok != null) {
                throw new HtmlRecognitionException(tok, ex);
            } else {
                throw ex;
            }
        }

attributeValue: ( AMPERSAND { append("&amp;"); } |
                an:ALPHANUMERICWORD { append( an.getText() ); } |
                p:PUNCTUATION { append( p.getText() ); } |
                s:SLASH { append( s.getText() ); } |
                space:SPACE{append(space.getText());}|specialChars )*
    ;
    exception 
        catch [RecognitionException ex] {
            if (htmlElementStack.isEmpty()) throw ex;
            Token tok = htmlElementStack.peek();
            if (tok != null) {
                throw new HtmlRecognitionException(tok, ex);
            } else {
                throw ex;
            }
        }

class HtmlSeamTextLexer extends Lexer;

options
{
   k=2;

   // Allow any char but \uFFFF (16 bit -1)
   charVocabulary='\u0000'..'\uFFFE';
}


// Unicode sets allowed:
// '\u00a0'..'\u00ff'  Latin 1 supplement (no control characters) http://www.unicode.org/charts/PDF/U0080.pdf
// '\u0100'..'\u017f'  Latin Extended A http://www.unicode.org/charts/PDF/U0100.pdf
// '\u0180'..'\u024f'  Latin Extended B http://www.unicode.org/charts/PDF/U0180.pdf
// '\u0250'..'\ufaff'  Various other languages, punctuation etc. (excluding "presentation forms")
// '\uff00'..'\uffef'  Halfwidth and Fullwidth forms (including CJK punctuation)

ALPHANUMERICWORD
    options {
        paraphrase = "letters or digits";
    }
    :   ('a'..'z'|'A'..'Z'|'0'..'9')+
    ;

UNICODEWORD
    options {
        paraphrase = "letters or digits";
    }
    : (
         '\u00a0'..'\u00ff' |
         '\u0100'..'\u017f' |
         '\u0180'..'\u024f' |
         '\u0250'..'\ufaff' |
         '\uff00'..'\uffef'
      )+
    ;

PUNCTUATION
    options {
        paraphrase = "a punctuation character";
    }
    : '-' | ';' | ':' | '(' | ')' | '{' | '}' | '?' | '!' | '@' | '%' | '.' | ',' | '$'
    ;
    
EQ
    options {
        paraphrase = "an equals '='";
    }
    : '='
    ;
    
PLUS
    options {
        paraphrase = "a plus '+'";
    }
    : '+'
    ;
    
UNDERSCORE
    options {
        paraphrase = "an underscore '_'";
    }
    : '_'
    ;

STAR
    options {
        paraphrase = "a star '*'";
    }
    : '*'
    ;

SLASH
    options {
        paraphrase = "a slash '/'";
    }

    : '/'
    ;

ESCAPE
    options {
        paraphrase = "the escaping blackslash '\'";
    }
    : '\\'
    ;
    
BAR
    options {
        paraphrase = "a bar or pipe '|'";
    }
    : '|'
    ;
    
BACKTICK
    options {
        paraphrase = "a backtick '`'";
    }
    : '`'
    ;
    
    
TWIDDLE
    options {
        paraphrase = "a tilde '~'";
    }
    : '~'
    ;

DOUBLEQUOTE
    options {
        paraphrase = "a doublequote \"";
    }
    : '"'
    ;

SINGLEQUOTE
    options {
        paraphrase = "a single quote '";
    }
    : '\''
    ;

OPEN
    options {
        paraphrase = "an opening square bracket '['";
    }
    : '['
    ;
    
CLOSE
    options {
        paraphrase = "a closing square bracket ']'";
    }
    : ']'
    ;

HASH
    options {
        paraphrase = "a hash '#'";
    }
    : '#'
    ;
    
HAT
    options {
        paraphrase = "a caret '^'";
    }
    : '^'
    ;
    
GT
    options {
        paraphrase = "a closing angle bracket '>'";
    }
    : '>'
    ;
    
LT
    options {
        paraphrase = "an opening angle bracket '<'";
    }
    : '<'
    ;

AMPERSAND
    options {
        paraphrase = "an ampersand '&'";
    }
    : '&'
    ;

SPACE
    options {
        paraphrase = "a space or tab";
    }
    : (' '|'\t')+
    ;
    
NEWLINE
    options {
        paraphrase = "a newline";
    }
    : "\r\n" | '\r' | '\n'
    ;

EOF
    options {
        paraphrase = "the end of the text";
    }
    : '\uFFFF'
    ;

ESCAPED_LT : "&lt;"
	;

ESCAPED_GT : "&gt;"
	;

ESCAPED_AMP : "&amp;"
	;

ESCAPED_QOUT : "&quot;"
	;

ESCAPED_NBSP : "&nbsp;"
	;









