package org.epistem.jsp;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.epistem.servlet.ResponseWrapper;

/**
 * This is the superclass for JSPs that can generate binary content.
 * The servlet response output stream is disconnected from the writer so that tags in the
 * JSP can write binary content to the output stream.
 * 
 * @author nick
 */
public abstract class BinaryCapableJSP extends BaseJSP  
{
    protected BinaryCapableJSP() {
    }
    
	/**
	 *  @see javax.servlet.Servlet#getServletInfo()
	 */
    public String getServletInfo(){
		return "Binary Capable JSP Page";
    }

	/**
	 *  @see javax.servlet.http.HttpServlet#service(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public final void service(	HttpServletRequest request, HttpServletResponse response ) 
		throws ServletException, IOException {		
		_jspService( request, new ResponseWrapper( response ) );
    }
}