/****************************************************************
 * Copyright (c) 2004, David N. Main, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the 
 * following conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 * copyright notice, this list of conditions and the following 
 * disclaimer. 
 * 
 * 2. Redistributions in binary form must reproduce the above 
 * copyright notice, this list of conditions and the following 
 * disclaimer in the documentation and/or other materials 
 * provided with the distribution.
 * 
 * 3. The name of the author may not be used to endorse or 
 * promote products derived from this software without specific 
 * prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************/
 
package org.javaswf.swf.model.tags;

import java.io.IOException;

import org.javaswf.swf.model.SWFTag;

import com.anotherbigidea.flash.interfaces.SWFTagTypes;

/**
 * A tag that has not been modeled, or is unknown.
 * 
 * @author Nick
 */
public class SWFOpaqueTag extends SWFTag {

    private int tagType;
    private byte[] tagData;
    
    /**
     * @param tagType the tag type
     * @param tagData the raw tag contents
     */
    public SWFOpaqueTag( int tagType, byte[] tagData ) {
        this.tagData = tagData;
        this.tagType = tagType;
    }
        
    /**
     * @return the tag contents.
     */
    public byte[] getTagData() {
        return tagData;
    }
    
    /**
     * @return the tag type.
     */
    public int getTagType() {
        return tagType;
    }
    
    /**
     * @see org.javaswf.swf.model.SWFTag#writeTag(com.anotherbigidea.flash.interfaces.SWFTagTypes)
     */
    public void writeTag( SWFTagTypes tagOutput ) throws IOException {
        tagOutput.tag( tagType, false, tagData ); 
    }
}
