/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.renderkit.AjaxEventOptions;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.HandlersChain;
import org.ajax4jsf.renderkit.RendererBase;
import org.richfaces.component.AbstractPush;
import org.richfaces.resource.PushResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js")})
public class AjaxPushRenderer
extends RendererBase {
    public static final String COMPONENT_FAMILY = "org.richfaces.Push";
    public static final String RENDERER_TYPE = "org.richfaces.PushRenderer";
    public static final String PUSH_INTERVAL_PARAMETER = "A4J.AJAX.Push.INTERVAL";
    public static final String PUSH_WAIT_PARAMETER = "A4J.AJAX.Push.WAIT";
    @Deprecated
    public static final String PUSH_URL_PARAMETER = "A4J.AJAX.Push.URL";
    public static final int DEFAULT_PUSH_INTERVAL = 1000;
    public static final int DEFAULT_PUSH_WAIT = Integer.MIN_VALUE;
    private static final String AJAX_PUSH_FUNCTION = "A4J.AJAX.Push";

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        AbstractPush push = (AbstractPush)component;
        writer.startElement("span", component);
        writer.writeAttribute("style", (Object)"display:none;", null);
        this.getUtils().encodeId(context, component);
        this.getUtils().encodeBeginFormIfNessesary(context, component);
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        StringBuffer script = new StringBuffer("\n");
        if (push.isEnabled()) {
            String handler;
            JSFunction function = new JSFunction("RichFaces.startPush", new Object[0]);
            HashMap<String, Object> options = new HashMap<String, Object>();
            int interval = push.getInterval();
            if (!this.getUtils().shouldRenderAttribute((Object)interval)) {
                String intervalInitParameter = context.getExternalContext().getInitParameter(PUSH_INTERVAL_PARAMETER);
                interval = null != intervalInitParameter ? Integer.parseInt(intervalInitParameter) : 1000;
            }
            options.put("interval", interval);
            options.put("pushResourceUrl", new PushResource().getRequestPath());
            options.put("pushId", push.getListenerId(context));
            options.put("clientId", component.getClientId(context));
            HandlersChain handlersChain = new HandlersChain((UIComponent)push);
            handlersChain.addInlineHandlerFromAttribute(context, "ondataavailable");
            handlersChain.addBehaviors(context, "dataAvailable");
            if (!handlersChain.hasSubmittingBehavior()) {
                JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction((FacesContext)context, (UIComponent)push, (String)"RichFaces.ajax");
                AjaxEventOptions eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)push);
                if (!eventOptions.isEmpty()) {
                    ajaxFunction.addParameter((Object)eventOptions);
                }
                handlersChain.addInlineHandlerAsValue(context, ajaxFunction.toScript());
            }
            if ((handler = handlersChain.toScript()) != null) {
                JSFunctionDefinition dataAvailableHandler = new JSFunctionDefinition(new Object[]{JSReference.EVENT});
                dataAvailableHandler.addToBody((Object)handler);
                options.put("ondataavailable", dataAvailableHandler);
            }
            function.addParameter(options);
            script.append(function.toScript());
        } else {
            script.append("RichFaces.stopPush('").append(push.getListenerId(context)).append("')");
        }
        script.append(";\n");
        writer.writeText((Object)script.toString(), null);
        writer.endElement("script");
        this.getUtils().encodeEndFormIfNessesary(context, component);
        writer.endElement("span");
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractPush.class;
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        Map requestParameterMap;
        super.doDecode(context, component);
        AbstractPush push = (AbstractPush)component;
        if (push.isEnabled() && ((requestParameterMap = context.getExternalContext().getRequestParameterMap()).get(push.getClientId(context)) != null || push.isHasActiveBehavior())) {
            new ActionEvent((UIComponent)push).queue();
        }
    }
}

