/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.QueueRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js"), @ResourceDependency(name="richfaces-queue.js")})
public class QueueResourceComponentRenderer
extends Renderer {
    private static final String FUNCTION_NAME = "RichFaces.queue.setQueueOptions";
    private final RendererUtils utils = RendererUtils.getInstance();

    private void appendOptions(UIComponent queue, Map<String, Object> optionsHash) {
        Map attributes = queue.getAttributes();
        for (QueueOptions option : QueueOptions.values()) {
            String optionName = option.name();
            Object value = attributes.get(optionName);
            this.utils.addToScriptHash(optionsHash, optionName, value);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        QueueRegistry registry = QueueRegistry.getInstance(context);
        if (registry != null && registry.hasQueuesToEncode()) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("script", component);
            writer.writeAttribute("id", (Object)context.getExternalContext().encodeNamespace("org.richfaces.queue"), null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeText((Object)FUNCTION_NAME, null);
            writer.writeText((Object)"({", null);
            LinkedHashMap<String, Object> queueOptionsMap = new LinkedHashMap<String, Object>();
            boolean isFirst = true;
            Map<String, UIComponent> registeredQueues = registry.getRegisteredQueues();
            for (Map.Entry<String, UIComponent> queueEntry : registeredQueues.entrySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    writer.writeText((Object)",", null);
                }
                queueOptionsMap.clear();
                String queueName = queueEntry.getKey();
                UIComponent queue = queueEntry.getValue();
                this.appendOptions(queue, queueOptionsMap);
                ScriptUtils.writeToStream((ResponseWriter)writer, (Object)queueName);
                writer.writeText((Object)":", null);
                ScriptUtils.writeToStream((ResponseWriter)writer, queueOptionsMap);
            }
            writer.writeText((Object)"});", null);
            writer.endElement("script");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum QueueOptions {
        onbeforedomupdate,
        oncomplete,
        onerror,
        onevent,
        onrequestdequeue,
        onrequestqueue,
        onsubmit,
        requestDelay,
        timeout,
        status,
        queueId,
        ignoreDupResponses,
        requestGroupingId;

    }
}

