/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.request;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.richfaces.request.FileUploadResource;

final class FileUploadDiscResource
extends FileUploadResource {
    private File file;
    private FileOutputStream fos;

    public FileUploadDiscResource(String name, String uploadLocation) {
        super(name, uploadLocation);
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public long getSize() {
        return this.file.length();
    }

    public void write(String fileName) throws IOException {
        boolean writeResult = this.file.renameTo(this.getOutputFile(fileName));
        if (!writeResult) {
            throw new IOException(MessageFormat.format("Write to disc resource {0} failed", fileName));
        }
    }

    public void delete() throws IOException {
        this.complete();
        if (this.file == null || !this.file.exists()) {
            return;
        }
        boolean deleteResult = this.file.delete();
        if (!deleteResult) {
            throw new IOException("File delete failed");
        }
    }

    public void create() throws IOException {
        this.file = File.createTempFile("richfaces_uploaded_file_", null, this.getOutputFile(null));
        this.file.deleteOnExit();
        this.fos = new FileOutputStream(this.file);
    }

    public void handle(byte[] bytes, int length) throws IOException {
        this.fos.write(bytes, 0, length);
    }

    public void complete() {
        Closeables.closeQuietly((Closeable)this.fos);
        this.fos = null;
    }
}

