/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.spdy;

import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.spdy.DefaultSpdyGoAwayFrame;
import org.jboss.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import org.jboss.netty.handler.codec.spdy.SpdyDataFrame;
import org.jboss.netty.handler.codec.spdy.SpdyGoAwayFrame;
import org.jboss.netty.handler.codec.spdy.SpdyHeadersFrame;
import org.jboss.netty.handler.codec.spdy.SpdyPingFrame;
import org.jboss.netty.handler.codec.spdy.SpdyProtocolException;
import org.jboss.netty.handler.codec.spdy.SpdyRstStreamFrame;
import org.jboss.netty.handler.codec.spdy.SpdySession;
import org.jboss.netty.handler.codec.spdy.SpdySettingsFrame;
import org.jboss.netty.handler.codec.spdy.SpdyStreamStatus;
import org.jboss.netty.handler.codec.spdy.SpdySynReplyFrame;
import org.jboss.netty.handler.codec.spdy.SpdySynStreamFrame;

public class SpdySessionHandler
extends SimpleChannelUpstreamHandler
implements ChannelDownstreamHandler {
    private static final SpdyProtocolException PROTOCOL_EXCEPTION = new SpdyProtocolException();
    private final SpdySession spdySession = new SpdySession();
    private volatile int lastGoodStreamID;
    private volatile int remoteConcurrentStreams;
    private volatile int localConcurrentStreams;
    private volatile int maxConcurrentStreams;
    private final AtomicInteger pings = new AtomicInteger();
    private volatile boolean sentGoAwayFrame;
    private volatile boolean receivedGoAwayFrame;
    private volatile ChannelFuture closeSessionFuture;
    private final boolean server;

    public SpdySessionHandler(boolean server) {
        this.server = server;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (msg instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)msg;
            int streamID = spdyDataFrame.getStreamID();
            if (this.spdySession.isRemoteSideClosed(streamID)) {
                if (!this.sentGoAwayFrame) {
                    this.issueStreamError(ctx, e, streamID, SpdyStreamStatus.INVALID_STREAM);
                }
                return;
            }
            if (!this.isRemoteInitiatedID(streamID) && !this.spdySession.hasReceivedReply(streamID)) {
                this.issueStreamError(ctx, e, streamID, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            if (spdyDataFrame.isLast()) {
                this.halfCloseStream(streamID, true);
            }
        } else if (msg instanceof SpdySynStreamFrame) {
            boolean localSideClosed;
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)msg;
            int streamID = spdySynStreamFrame.getStreamID();
            if (spdySynStreamFrame.isInvalid() || !this.isRemoteInitiatedID(streamID) || this.spdySession.isActiveStream(streamID)) {
                this.issueStreamError(ctx, e, streamID, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            if (streamID < this.lastGoodStreamID) {
                this.issueSessionError(ctx, e.getChannel(), e.getRemoteAddress());
                return;
            }
            boolean remoteSideClosed = spdySynStreamFrame.isLast();
            if (!this.acceptStream(streamID, remoteSideClosed, localSideClosed = spdySynStreamFrame.isUnidirectional())) {
                this.issueStreamError(ctx, e, streamID, SpdyStreamStatus.REFUSED_STREAM);
                return;
            }
        } else if (msg instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)msg;
            int streamID = spdySynReplyFrame.getStreamID();
            if (spdySynReplyFrame.isInvalid() || this.isRemoteInitiatedID(streamID) || this.spdySession.isRemoteSideClosed(streamID)) {
                this.issueStreamError(ctx, e, streamID, SpdyStreamStatus.INVALID_STREAM);
                return;
            }
            if (this.spdySession.hasReceivedReply(streamID)) {
                this.issueStreamError(ctx, e, streamID, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            this.spdySession.receivedReply(streamID);
            if (spdySynReplyFrame.isLast()) {
                this.halfCloseStream(streamID, true);
            }
        } else if (msg instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)msg;
            this.removeStream(spdyRstStreamFrame.getStreamID());
        } else if (msg instanceof SpdySettingsFrame) {
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)msg;
            this.updateConcurrentStreams(spdySettingsFrame, true);
        } else if (msg instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)msg;
            if (this.isRemoteInitiatedID(spdyPingFrame.getID())) {
                Channels.write(ctx, Channels.future(e.getChannel()), spdyPingFrame, e.getRemoteAddress());
                return;
            }
            if (this.pings.get() == 0) {
                return;
            }
            this.pings.getAndDecrement();
        } else if (msg instanceof SpdyGoAwayFrame) {
            this.receivedGoAwayFrame = true;
        } else if (msg instanceof SpdyHeadersFrame) {
            SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)msg;
            int streamID = spdyHeadersFrame.getStreamID();
            if (spdyHeadersFrame.isInvalid()) {
                this.issueStreamError(ctx, e, streamID, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            if (this.spdySession.isRemoteSideClosed(streamID)) {
                this.issueStreamError(ctx, e, streamID, SpdyStreamStatus.INVALID_STREAM);
                return;
            }
        }
        super.messageReceived(ctx, e);
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        ChannelEvent e;
        if (evt instanceof ChannelStateEvent) {
            e = (ChannelStateEvent)evt;
            switch (e.getState()) {
                case OPEN: 
                case CONNECTED: 
                case BOUND: {
                    if (!Boolean.FALSE.equals(e.getValue()) && e.getValue() != null) break;
                    this.sendGoAwayFrame(ctx, (ChannelStateEvent)e);
                    return;
                }
            }
        }
        if (!(evt instanceof MessageEvent)) {
            ctx.sendDownstream(evt);
            return;
        }
        e = (MessageEvent)evt;
        Object msg = e.getMessage();
        if (msg instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)msg;
            int streamID = spdyDataFrame.getStreamID();
            if (this.spdySession.isLocalSideClosed(streamID)) {
                e.getFuture().setFailure(PROTOCOL_EXCEPTION);
                return;
            }
            if (spdyDataFrame.isLast()) {
                this.halfCloseStream(streamID, false);
            }
        } else if (msg instanceof SpdySynStreamFrame) {
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)msg;
            boolean remoteSideClosed = spdySynStreamFrame.isUnidirectional();
            boolean localSideClosed = spdySynStreamFrame.isLast();
            if (!this.acceptStream(spdySynStreamFrame.getStreamID(), remoteSideClosed, localSideClosed)) {
                e.getFuture().setFailure(PROTOCOL_EXCEPTION);
                return;
            }
        } else if (msg instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)msg;
            int streamID = spdySynReplyFrame.getStreamID();
            if (!this.isRemoteInitiatedID(streamID) || this.spdySession.isLocalSideClosed(streamID)) {
                e.getFuture().setFailure(PROTOCOL_EXCEPTION);
                return;
            }
            if (spdySynReplyFrame.isLast()) {
                this.halfCloseStream(streamID, false);
            }
        } else if (msg instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)msg;
            this.removeStream(spdyRstStreamFrame.getStreamID());
        } else if (msg instanceof SpdySettingsFrame) {
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)msg;
            this.updateConcurrentStreams(spdySettingsFrame, false);
        } else if (msg instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)msg;
            if (this.isRemoteInitiatedID(spdyPingFrame.getID())) {
                e.getFuture().setFailure(new IllegalArgumentException("invalid PING ID: " + spdyPingFrame.getID()));
                return;
            }
            this.pings.getAndIncrement();
        } else {
            SpdyHeadersFrame spdyHeadersFrame;
            int streamID;
            if (msg instanceof SpdyGoAwayFrame) {
                e.getFuture().setFailure(PROTOCOL_EXCEPTION);
                return;
            }
            if (msg instanceof SpdyHeadersFrame && this.spdySession.isLocalSideClosed(streamID = (spdyHeadersFrame = (SpdyHeadersFrame)msg).getStreamID())) {
                e.getFuture().setFailure(PROTOCOL_EXCEPTION);
                return;
            }
        }
        ctx.sendDownstream(evt);
    }

    private void issueSessionError(ChannelHandlerContext ctx, Channel channel, SocketAddress remoteAddress) {
        ChannelFuture future = this.sendGoAwayFrame(ctx, channel, remoteAddress);
        future.addListener(ChannelFutureListener.CLOSE);
    }

    private void issueStreamError(ChannelHandlerContext ctx, MessageEvent e, int streamID, SpdyStreamStatus status) {
        this.removeStream(streamID);
        DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamID, status);
        Channels.write(ctx, Channels.future(e.getChannel()), spdyRstStreamFrame, e.getRemoteAddress());
    }

    private boolean isServerID(int ID) {
        return ID % 2 == 0;
    }

    private boolean isRemoteInitiatedID(int ID) {
        boolean serverID = this.isServerID(ID);
        return this.server && !serverID || !this.server && serverID;
    }

    private synchronized void updateConcurrentStreams(SpdySettingsFrame settings, boolean remote) {
        int newConcurrentStreams = settings.getValue(4);
        if (remote) {
            this.remoteConcurrentStreams = newConcurrentStreams;
        } else {
            this.localConcurrentStreams = newConcurrentStreams;
        }
        if (this.localConcurrentStreams == this.remoteConcurrentStreams) {
            this.maxConcurrentStreams = this.localConcurrentStreams;
            return;
        }
        if (this.localConcurrentStreams == 0) {
            this.maxConcurrentStreams = this.remoteConcurrentStreams;
            return;
        }
        if (this.remoteConcurrentStreams == 0) {
            this.maxConcurrentStreams = this.localConcurrentStreams;
            return;
        }
        this.maxConcurrentStreams = this.localConcurrentStreams > this.remoteConcurrentStreams ? this.remoteConcurrentStreams : this.localConcurrentStreams;
    }

    private synchronized boolean acceptStream(int streamID, boolean remoteSideClosed, boolean localSideClosed) {
        if (this.receivedGoAwayFrame || this.sentGoAwayFrame) {
            return false;
        }
        if (this.maxConcurrentStreams != 0 && this.spdySession.numActiveStreams() >= this.maxConcurrentStreams) {
            return false;
        }
        this.spdySession.acceptStream(streamID, remoteSideClosed, localSideClosed);
        if (this.isRemoteInitiatedID(streamID)) {
            this.lastGoodStreamID = streamID;
        }
        return true;
    }

    private void halfCloseStream(int streamID, boolean remote) {
        if (remote) {
            this.spdySession.closeRemoteSide(streamID);
        } else {
            this.spdySession.closeLocalSide(streamID);
        }
        if (this.closeSessionFuture != null && this.spdySession.noActiveStreams()) {
            this.closeSessionFuture.setSuccess();
        }
    }

    private void removeStream(int streamID) {
        this.spdySession.removeStream(streamID);
        if (this.closeSessionFuture != null && this.spdySession.noActiveStreams()) {
            this.closeSessionFuture.setSuccess();
        }
    }

    private void sendGoAwayFrame(ChannelHandlerContext ctx, ChannelStateEvent e) {
        if (!e.getChannel().isConnected()) {
            ctx.sendDownstream(e);
            return;
        }
        ChannelFuture future = this.sendGoAwayFrame(ctx, e.getChannel(), null);
        if (this.spdySession.noActiveStreams()) {
            future.addListener(new ClosingChannelFutureListener(ctx, e));
        } else {
            this.closeSessionFuture = Channels.future(e.getChannel());
            this.closeSessionFuture.addListener(new ClosingChannelFutureListener(ctx, e));
        }
    }

    private synchronized ChannelFuture sendGoAwayFrame(ChannelHandlerContext ctx, Channel channel, SocketAddress remoteAddress) {
        if (!this.sentGoAwayFrame) {
            this.sentGoAwayFrame = true;
            ChannelFuture future = Channels.future(channel);
            Channels.write(ctx, future, new DefaultSpdyGoAwayFrame(this.lastGoodStreamID));
            return future;
        }
        return Channels.succeededFuture(channel);
    }

    private static final class ClosingChannelFutureListener
    implements ChannelFutureListener {
        private final ChannelHandlerContext ctx;
        private final ChannelStateEvent e;

        ClosingChannelFutureListener(ChannelHandlerContext ctx, ChannelStateEvent e) {
            this.ctx = ctx;
            this.e = e;
        }

        public void operationComplete(ChannelFuture sentGoAwayFuture) throws Exception {
            if (!(sentGoAwayFuture.getCause() instanceof ClosedChannelException)) {
                Channels.close(this.ctx, this.e.getFuture());
            } else {
                this.e.getFuture().setSuccess();
            }
        }
    }
}

