/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.EventName;
import org.richfaces.event.FileUploadListener;
import org.richfaces.renderkit.RenderKitUtils;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public abstract class AbstractFileUpload
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "org.richfaces.FileUpload";
    public static final String COMPONENT_FAMILY = "org.richfaces.FileUpload";

    @Attribute
    public abstract String getAcceptedTypes();

    @Attribute
    public abstract String getMaxFilesQuantity();

    @Attribute(defaultValue="false")
    public abstract boolean isDisabled();

    @Attribute(defaultValue="false")
    public abstract boolean isNoDuplicate();

    @Attribute(events={@EventName(value="filesubmit")})
    public abstract String getOnfilesubmit();

    @Attribute(events={@EventName(value="typerejected")})
    public abstract String getOntyperejected();

    @Attribute(events={@EventName(value="uploadcomplete")})
    public abstract String getOnuploadcomplete();

    @Attribute(events={@EventName(value="clear")})
    public abstract String getOnclear();

    @Attribute
    public abstract String getAddLabel();

    @Attribute
    public abstract String getUploadLabel();

    @Attribute
    public abstract String getClearAllLabel();

    @Attribute
    public abstract String getDoneLabel();

    @Attribute
    public abstract String getSizeExceededLabel();

    @Attribute
    public abstract String getServerErrorLabel();

    @Attribute
    public abstract String getClearLabel();

    @Attribute
    public abstract String getDeleteLabel();

    @Attribute(defaultValue="210px")
    public abstract String getListHeight();

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        super.processEvent(event);
        FacesContext context = this.getFacesContext();
        Map facets = this.getFacets();
        UIComponent component = (UIComponent)facets.get("progress");
        if (component == null) {
            try {
                component = context.getApplication().createComponent(context, "org.richfaces.ProgressBar", "org.richfaces.ProgressBarRenderer");
            }
            catch (FacesException e) {
                // empty catch block
            }
            if (component != null) {
                component.setId(this.getId() + "_pb");
                facets.put("progress", component);
            }
        }
        if (component != null) {
            String resourcePath = RenderKitUtils.getResourcePath((FacesContext)context, (String)"org.richfaces", (String)"fileUploadProgress");
            component.getAttributes().put("resource", resourcePath);
        }
    }

    public void addFileUploadListener(FileUploadListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public FileUploadListener[] getFileUploadListeners() {
        return (FileUploadListener[])this.getFacesListeners(FileUploadListener.class);
    }

    public void removeFileUploadListener(FileUploadListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }
}

