/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.renderkit.AjaxEventOptions;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.HandlersChain;
import org.ajax4jsf.renderkit.RendererBase;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js")})
public abstract class AjaxCommandRendererBase
extends RendererBase {
    private static final Logger LOG = RichfacesLogger.RENDERKIT.getLogger();

    protected void doDecode(FacesContext facesContext, UIComponent uiComponent) {
        if (this.isSubmitted(facesContext, uiComponent)) {
            new ActionEvent(uiComponent).queue();
        }
    }

    protected boolean isSubmitted(FacesContext facesContext, UIComponent uiComponent) {
        boolean submitted;
        if (this.getUtils().isBooleanAttribute(uiComponent, "disabled")) {
            return false;
        }
        String clientId = uiComponent.getClientId(facesContext);
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        Object value = paramMap.get(clientId);
        boolean bl = submitted = null != value;
        if (submitted && LOG.isDebugEnabled()) {
            LOG.debug("Decode submit of the Ajax component " + clientId);
        }
        return submitted;
    }

    public String getOnClick(FacesContext context, UIComponent component) {
        StringBuffer onClick = new StringBuffer();
        if (!this.getUtils().isBooleanAttribute(component, "disabled")) {
            String handlerScript;
            HandlersChain handlersChain = new HandlersChain(component);
            handlersChain.addInlineHandlerFromAttribute(context, "onclick");
            handlersChain.addBehaviors(context, "click", "action");
            if (!handlersChain.hasSubmittingBehavior()) {
                JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction((FacesContext)context, (UIComponent)component, (String)"RichFaces.ajax");
                AjaxEventOptions eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)component);
                if (!eventOptions.isEmpty()) {
                    ajaxFunction.addParameter((Object)eventOptions);
                }
                handlersChain.addInlineHandlerAsValue(context, ajaxFunction.toScript());
            }
            if ((handlerScript = handlersChain.toScript()) != null) {
                onClick.append(handlerScript);
            }
            if (!"reset".equals(component.getAttributes().get("type"))) {
                onClick.append(";return false;");
            }
        } else {
            onClick.append("return false;");
        }
        return onClick.toString();
    }
}

