/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.org.sonatype.aether.connector.file;

import java.util.Collection;
import java.util.Collections;
import org.sonatype.aether.ant.org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.ant.org.sonatype.aether.connector.file.FileRepositoryWorker;
import org.sonatype.aether.ant.org.sonatype.aether.connector.file.ParallelRepositoryConnector;
import org.sonatype.aether.ant.org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.ant.org.sonatype.aether.spi.connector.ArtifactDownload;
import org.sonatype.aether.ant.org.sonatype.aether.spi.connector.ArtifactUpload;
import org.sonatype.aether.ant.org.sonatype.aether.spi.connector.MetadataDownload;
import org.sonatype.aether.ant.org.sonatype.aether.spi.connector.MetadataUpload;
import org.sonatype.aether.ant.org.sonatype.aether.spi.connector.RepositoryConnector;
import org.sonatype.aether.ant.org.sonatype.aether.spi.io.FileProcessor;
import org.sonatype.aether.ant.org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.ant.org.sonatype.aether.spi.log.NullLogger;
import org.sonatype.aether.ant.org.sonatype.aether.transfer.NoRepositoryConnectorException;
import org.sonatype.aether.ant.org.sonatype.aether.util.concurrency.RunnableErrorForwarder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRepositoryConnector
extends ParallelRepositoryConnector
implements RepositoryConnector {
    private RemoteRepository repository;
    private RepositorySystemSession session;
    private Logger logger = NullLogger.INSTANCE;
    private FileProcessor fileProcessor;

    public FileRepositoryConnector(RepositorySystemSession session, RemoteRepository repository, FileProcessor fileProcessor, Logger logger) throws NoRepositoryConnectorException {
        if (!"default".equals(repository.getContentType())) {
            throw new NoRepositoryConnectorException(repository);
        }
        this.session = session;
        this.repository = repository;
        this.fileProcessor = fileProcessor;
        this.logger = logger;
        this.initExecutor(session.getConfigProperties());
    }

    @Override
    public void get(Collection<? extends ArtifactDownload> artifactDownloads, Collection<? extends MetadataDownload> metadataDownloads) {
        FileRepositoryWorker worker;
        this.checkClosed();
        artifactDownloads = this.notNull(artifactDownloads);
        metadataDownloads = this.notNull(metadataDownloads);
        RunnableErrorForwarder errorForwarder = new RunnableErrorForwarder();
        for (ArtifactDownload artifactDownload : artifactDownloads) {
            worker = new FileRepositoryWorker(artifactDownload, this.repository, this.session);
            worker.setLogger(this.logger);
            worker.setFileProcessor(this.fileProcessor);
            this.executor.execute(errorForwarder.wrap(worker));
        }
        for (MetadataDownload metadataDownload : metadataDownloads) {
            worker = new FileRepositoryWorker(metadataDownload, this.repository, this.session);
            worker.setLogger(this.logger);
            worker.setFileProcessor(this.fileProcessor);
            this.executor.execute(errorForwarder.wrap(worker));
        }
        errorForwarder.await();
    }

    private <E> Collection<E> notNull(Collection<E> col) {
        return col == null ? Collections.emptyList() : col;
    }

    @Override
    public void put(Collection<? extends ArtifactUpload> artifactUploads, Collection<? extends MetadataUpload> metadataUploads) {
        FileRepositoryWorker worker;
        this.checkClosed();
        artifactUploads = this.notNull(artifactUploads);
        metadataUploads = this.notNull(metadataUploads);
        RunnableErrorForwarder errorForwarder = new RunnableErrorForwarder();
        for (ArtifactUpload artifactUpload : artifactUploads) {
            worker = new FileRepositoryWorker(artifactUpload, this.repository, this.session);
            worker.setLogger(this.logger);
            worker.setFileProcessor(this.fileProcessor);
            this.executor.execute(errorForwarder.wrap(worker));
        }
        for (MetadataUpload metadataUpload : metadataUploads) {
            worker = new FileRepositoryWorker(metadataUpload, this.repository, this.session);
            worker.setLogger(this.logger);
            worker.setFileProcessor(this.fileProcessor);
            this.executor.execute(errorForwarder.wrap(worker));
        }
        errorForwarder.await();
    }

    public String toString() {
        return String.valueOf(this.repository);
    }
}

