/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileUtils;
import org.jacoco.core.instr.Instrumenter;
import org.jacoco.core.runtime.OfflineInstrumentationAccessGenerator;

public class InstrumentTask
extends Task {
    private File destdir;
    private final Union files = new Union();

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public void addConfigured(ResourceCollection resources) {
        this.files.add(resources);
    }

    public void execute() throws BuildException {
        if (this.destdir == null) {
            throw new BuildException("Destination directory must be supplied", this.getLocation());
        }
        int total = 0;
        Instrumenter instrumenter = new Instrumenter(new OfflineInstrumentationAccessGenerator());
        for (Resource resource : this.files) {
            if (resource.isDirectory()) continue;
            total += this.instrument(instrumenter, resource);
        }
        this.log(String.format("Instrumented %s classes to %s", total, this.destdir.getAbsolutePath()));
    }

    private int instrument(Instrumenter instrumenter, Resource resource) {
        int n;
        InputStream input = null;
        FileOutputStream output = null;
        File file = new File(this.destdir, resource.getName());
        file.getParentFile().mkdirs();
        try {
            input = resource.getInputStream();
            output = new FileOutputStream(file);
            n = instrumenter.instrumentAll(input, output);
        }
        catch (Exception e) {
            try {
                file.delete();
                throw new BuildException(String.format("Error while instrumenting %s", resource), (Throwable)e, this.getLocation());
            }
            catch (Throwable throwable) {
                FileUtils.close((InputStream)input);
                FileUtils.close(output);
                throw throwable;
            }
        }
        FileUtils.close((InputStream)input);
        FileUtils.close((OutputStream)output);
        return n;
    }
}

