/*
 * Copyright 2021 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.kogito.taskassigning.auth.mp;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

import io.quarkus.oidc.client.OidcClient;
import io.quarkus.oidc.client.Tokens;
import io.smallrye.mutiny.Uni;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.Mockito.doReturn;

@ExtendWith(MockitoExtension.class)
class OidcClientTokenManagerTest {

    @Mock
    private OidcClient oidcClient;

    @Mock
    private Tokens tokens;

    @Test
    void getAccessTokenString() {
        String accessToken = "ACCESS_TOKEN";
        doReturn(accessToken).when(tokens).getAccessToken();
        Uni<Tokens> tokensUni = Uni.createFrom().item(tokens);
        doReturn(tokensUni).when(oidcClient).getTokens();
        OidcClientTokenManager tokenManager = new OidcClientTokenManager(oidcClient);
        assertThat(tokenManager.getAccessTokenString()).isEqualTo(accessToken);
    }
}
