/*
 * Copyright 2022 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.kogito.quarkus.workflows;

import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;

import static io.restassured.RestAssured.given;
import static org.hamcrest.CoreMatchers.is;

/**
 * Handle integration tests for OpenAPI Spec Interface generation for SW projects.
 */
@QuarkusIntegrationTest
public class OpenAPIInterfaceGenIT {

    @BeforeAll
    static void init() {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }

    @Test
    void verifyOperationIdIsGeneratedByDefault() {
        given()
                .accept(ContentType.JSON)
                .when()
                .get("/q/openapi?format=json")
                .then()
                .statusCode(200)
                // verifies the get path in the helloworld SW
                .body("paths.'/helloworld'.get.operationId", is("getResources_helloworld"))
                // verifies the CE listener (knative addressable interface)
                .body("paths.'/'.post.operationId", is("cloudEventListener"));
    }

}
