# Trusty Service 

Within the TrustyAI initiative, the trusty service is the main service that aims to collect tracing events emitted by one or more kogito-runtime application and to provide explainability on top of the decisions that have been by the application. 

## Architecture 

The architecture looks like the following: 

![trusty-architecture_enterprise](https://user-images.githubusercontent.com/18282531/89585961-167c3700-d83f-11ea-8fdc-ab840442bb62.png)

In particular we have: 
1) A kogito-runtime application with the `tracing` addon activated.
2) A kafka broker and an infinispan instance.
3) The trusty service (this module).
4) The explainability service
5) The auditUI 

Descriptions and instructions for every single component are provided in the next subsections. 

### The kogito-runtime application 

The kogito-runtime application is a standard kogito application that has imported the `tracing-addon` as dependency 

```xml
      <dependency>
        <groupId>org.kie.kogito</groupId>
        <artifactId>tracing</artifactId>
      </dependency>
```

and that is using one or more DMN models. In addition to that, the application needs to know the address of the kafka broker. For example, if you are using Quarkus, you can 
set it with an enviroment variable
```bash
export KAFKA_BOOTSTRAP_SERVERS=localhost:9092
```
This is needed because every time a decision is evaluated for a dmn model, a trace event is generated and emitted. This event contains all the information needed to provide explainability and accountability on the decision that has been taken. 

If you are new to kogito, we recommend to start with https://kogito.kie.org/get-started/ . 

### The kafka broker and the infinispan instance

You will have to provide a kafka instance as well as an infinispan instance. At the end of this readme, there is a link that contains a full end to end example. 

### The Trusty service

The Trusty service consumes tracing events generated by the kogito-runtime application. A tracing event is a bunch of data that contains 
the request that has been made to the kogito endpoint, the result, the outcomes of all the dmn nodes (decisions and BKM for example), and error messages if any.
The responsability of this service is to store all the information about the decision and to interact with the explainability service to retrieve the analysis of the decision. 
The trusty service depends of course on kafka, but also on infinispan to persist the tracing information. 
Enviroment variables can be used to set the information needed to connect to kafka and infinispan, for example

```bash
export KAFKA_BOOTSTRAP_SERVERS=localhost:9092
export QUARKUS_INFINISPAN_CLIENT_SERVER_LIST=localhost:11222
export QUARKUS_INFINISPAN_CLIENT_AUTH_USERNAME=myuser
export QUARKUS_INFINISPAN_CLIENT_AUTH_PASSWORD=mypassword
```

#### Handling failures

The Trusty service by default is configured so that if a connection exception occurs during the processing of a kafka event, the message is not acked and the application is set in an unhealthy status. It's responsability of the underlying orchestrator to redeploy the service until the infrastructural issue is fixed. 
If you are not using any orchestrator, we suggest you to set up the following ENV variable so to disable this behaviour. With the following variables
```bash
export KAFKA_APPLICATION_FAILURE_STRATEGY=ignore
```
the application discards all the events even if it would be possible to recover them in a second moment. This prevents the trusty service to stay in an unhealthy status waiting for redeployment.

In addition to that, if you would like to ignore the type of the exception and nack the message if **any** exception is raised, you can set the variable
```bash
export TRUSTY_MESSAGING_NACK_ON_ANY_EXCEPTION=true
```

### Explainability service

The explainability service provides local and global explaination. 
- The local explanation aims to find the most relevant features that contributed to take that particular decision. In order to do that, the explainability service interacts with the kogito-runtime application to re-execute the decision with perturbed features. At the moment, the communication between explainability service and the kogito application is performed via HTTP calls. 
- The global explainability is still under development. 

As a consequence, the dependencies of the explainability service are Kafka and the availability of the kogito application. 

## An example project

A sample end to end project is provided [here](https://github.com/kiegroup/kogito-examples/tree/main/dmn-tracing-quarkus).
