/*
 * Copyright 2021 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { TaskFormChannelApi, TaskFormDriver } from '../api';
import { CustomForm } from '../types';

export class EmbeddedTaskFormChannelApiImpl implements TaskFormChannelApi {
  constructor(private readonly driver: TaskFormDriver) {}

  taskForm__doSubmit(phase?: string, payload?: any): Promise<any> {
    return this.driver.doSubmit(phase, payload);
  }

  taskForm__getTaskFormSchema(): Promise<Record<string, any>> {
    return this.driver.getTaskFormSchema();
  }

  taskForm__getCustomForm(): Promise<CustomForm> {
    return this.driver.getCustomForm();
  }
}
