# Kogito Events Add-on

The Kogito Events add-on adds the capability to handle use cases with events on Kogito projects. See the following documentation sections to find out more.

- [Kogito runtime events](https://docs.jboss.org/kogito/release/latest/html_single/#con-kogito-runtime-events_kogito-configuring)
- [Travel agency tutorial for Kogito services on OpenShift](https://docs.jboss.org/kogito/release/latest/html_single/#con-kogito-travel-agency_kogito-deploying-on-openshift)
- [Kogito Data Index Service](https://docs.jboss.org/kogito/release/latest/html_single/#con-data-index-service_kogito-configuring)
- [Kogito Trusty Service and Explainability Service](https://docs.jboss.org/kogito/release/latest/html_single/#con-trusty-service_kogito-configuring)


## Examples

See the following examples to explore more about this capability.

### DMN Event Driven

- [dmn-event-driven-quarkus](https://github.com/kiegroup/kogito-examples/tree/stable/kogito-quarkus-examples/dmn-event-driven-quarkus)
- [dmn-event-driven-springboot](https://github.com/kiegroup/kogito-examples/tree/stable/kogito-springboot-examples/dmn-event-driven-springboot)

### PMML Event Driven

- [pmml-event-driven-quarkus](https://github.com/kiegroup/kogito-examples/tree/stable/kogito-quarkus-examples/pmml-event-driven-quarkus)
- [pmml-event-driven-springboot](https://github.com/kiegroup/kogito-examples/tree/stable/kogito-springboot-examples/pmml-event-driven-springboot)

### Rules Event Driven

- [ruleunit-event-driven-quarkus](https://github.com/kiegroup/kogito-examples/tree/stable/kogito-quarkus-examples/ruleunit-event-driven-quarkus)
- [ruleunit-event-driven-springboot](https://github.com/kiegroup/kogito-examples/tree/stable/kogito-springboot-examples/ruleunit-event-driven-springboot)

### Quarkus Smallrye

- [kogito-travel-agency](https://github.com/kiegroup/kogito-examples/tree/stable/kogito-quarkus-examples/kogito-travel-agency)
- [process-mongodb-persistence-quarkus](https://github.com/kiegroup/kogito-examples/tree/stable/kogito-quarkus-examples/process-mongodb-persistence-quarkus)
- [process-quarkus-example](https://github.com/kiegroup/kogito-examples/tree/stable/kogito-quarkus-examples/process-quarkus-example)
- [process-usertasks-quarkus-with-console](https://github.com/kiegroup/kogito-examples/tree/stable/kogito-quarkus-examples/process-usertasks-quarkus-with-console)
- [process-usertasks-timer-quarkus-with-console](https://github.com/kiegroup/kogito-examples/tree/stable/kogito-quarkus-examples/process-usertasks-timer-quarkus-with-console)
- [process-usertasks-with-security-oidc-quarkus-with-console](https://github.com/kiegroup/kogito-examples/tree/stable/kogito-quarkus-examples/process-usertasks-with-security-oidc-quarkus-with-console)

### Spring Boot Kafka

- [process-mongodb-persistence-springboot](https://github.com/kiegroup/kogito-examples/tree/stable/kogito-springboot-examples/process-mongodb-persistence-springboot)
- [process-springboot-example](https://github.com/kiegroup/kogito-examples/tree/stable/kogito-springboot-examples/process-springboot-example)
- [process-usertasks-springboot-with-console](https://github.com/kiegroup/kogito-examples/tree/stable/kogito-springboot-examples/process-usertasks-springboot-with-console)
- [process-usertasks-with-security-oidc-springboot-with-console](https://github.com/kiegroup/kogito-examples/tree/stable/kogito-springboot-examples/process-usertasks-with-security-oidc-springboot-with-console)
