/*
 * Copyright 2022 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.kogito.persistence.springboot;

import org.kie.kogito.persistence.postgresql.AbstractProcessInstancesFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import io.vertx.pgclient.PgPool;

@Component
public class PostgresqlProcessInstancesFactory extends AbstractProcessInstancesFactory {

    @Autowired
    public PostgresqlProcessInstancesFactory(@Qualifier("kogito") PgPool client,
            @Value("${kogito.persistence.query.timeout.millis:10000}") Long queryTimeout,
            @Value("${kogito.persistence.optimistic.lock:false}") Boolean lock) {
        super(client, queryTimeout, lock);
    }

    protected PostgresqlProcessInstancesFactory() {
        super();
    }

}
