/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.drools.core.reteoo;

import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.PropagationContext;

public interface RightTuple extends Tuple {

    LeftTuple getBlocked();
    void setBlocked( LeftTuple leftTuple );
    void addBlocked( LeftTuple leftTuple );
    void removeBlocked( LeftTuple leftTuple );

    LeftTuple getTempBlocked();
    void setTempBlocked( LeftTuple tempBlocked );

    RightTuple getTempNextRightTuple();
    void setTempNextRightTuple( RightTuple tempNextRightTuple );

    InternalFactHandle getFactHandleForEvaluation();

    void retractTuple( PropagationContext context, ReteEvaluator reteEvaluator );

    void setExpired( ReteEvaluator reteEvaluator, PropagationContext pctx );
}