### DMN Marshaller backend compatibility tester

The scope of this module is to provide a reliable scripting mechanism that tests DMN Files generated by the `dmn-marshaller` package against the backend counterpart code that lives in the drools repository.
The scripts are based on [JBang!](https://www.jbang.dev/) which provides an out-of-the-box library to be consumed in NodeJs.

At the moment of writing, two scripts are available:

- DMN Validation, which can validate a DMN file (and its imported DMN assets) using the [KIE DMN Validator](https://github.com/apache/incubator-kie-drools/tree/main/kie-dmn/kie-dmn-validation) back-end module.
- DMN Semantic Comparison, which compares two DMN files (and their imported DMN assets) using a Backend logic that relies on KIE DMN Engine core code.

Every script is defined in a single Java class. Inside those, you can find a list of fields (marked with `@Option` annotation) that represent the commands and their required parameters to run the scripts.

An abstract class is defined as the parent class of all defined scripts. That class holds all the Dependencies required by all the Java class scripts that implement it. This is required to enable a dependency fetching mechanism useful for:

- Avoid issues when launching several JBang instances. This case may lead to issues with internal JBang caching.
- In CI/CD, it's sometimes required to download all the required dependencies in an earlier phase and then build the project.
  To run the dependency fetching mechanism, you can just launch the jbang command passing that Abstract class location (no args).
  To keep this mechanism consistent, please always declare all the required dependencies in the abstract superclass.
  The dependency fetching mechanism can be called externally from a `package.json` script using the `dependenciesFetch.js` file, using the following command:
  `node dist/dependenciesFetch.js`.
  It's not possible to directly call JBang in the package.json script because when the JBang NPM library installs JBang in the local machine with the preinstall hook, it requires a new Shell for changes to take effect.

### Usage

The entry point of this module is the `index.js` file that exports:

- `executeJBangScript` that requires as parameters: the Script to execute (see below) and its required args.
- The enumeration of the currently available Script
  That represents all the required elements for consuming this module externally.

To execute a specific JBang script present in this module you must:

- Import the `"@kie-tools/dmn-marshaller-backend-compatibility-tester"` dependency;
- Import the required function (eg.`executeDMNValidation` or `executeDMNSemanticComparison`) in your JS/TS file;
- Call one of the above function passing its required parameters.
- For the precise args list, please check inside the Java Class Script of your interest and take note of all `@Option` annotated fields.
