# Kogito SCESIM Marshaller

This module manages **marshalling** (i.e. converting from a XML file to a JSInterop file)
and **unmarshalling** (i.e. converting from JSInterop file to a XML file) operation for Scenario Simulation
Kogito project.

Basically, the module uses jaxb _maven-jaxb2-plugin_ plugin and its sub plugin _gwt-jsonix-schema-compiler_
to generate all required classes to support the marshall and unmarshall processes. The inputs of the process are
_bindings.xjb_ and _scesim.xsd_ files, which represent the schema of a current \*.scesim

In details, the modules provides:

Under **java** package

- **Model JSInterp classes**: The model JSInterop classes a for a which are automatically generated by
  _maven-jaxb2-plugin_ plugin in _js/model_ package
- **Callbacks**: Callbacks to be called during a marshall/unmarshall call. Automatically generated by
  _maven-jaxb2-plugin_ plugin in _js/callbacks_ package
- **SCESIMMainJS**: JSInterop adapter to use for marshalling/unmarshalling, which refers to _SCESIMMainJS.js_,
  its javascript representation. Basically, this automatically generated java class is the entrypoint
  for marshalling/unmarshalling processes.
- **Mapper**: It contains automatically generated Utils classes _JsUtils_ and _JSIName_

Under **resources** package

- **Jsonix-all.js** automatically generated JS file which represents Jsonix engine. Do not contains specific
  SCESIM files. Required to be imported in the HTML page which wants to use this marshaller.
- **SCESIM.js** automatically generated JS file which represents the SCESIM "schema" in JSON format.
- **SCESIMMainJs.js** It wraps the Jsonix engine into SCESIM context.
  Required to be imported in the HTML page which wants to use this marshaller.
- **jre folder**: It's a container for GWT "super source" files where GWT does not provide an emulation of JRE classes.
