<!--
   Licensed to the Apache Software Foundation (ASF) under one
   or more contributor license agreements.  See the NOTICE file
   distributed with this work for additional information
   regarding copyright ownership.  The ASF licenses this file
   to you under the Apache License, Version 2.0 (the
   "License"); you may not use this file except in compliance
   with the License.  You may obtain a copy of the License at
     http://www.apache.org/licenses/LICENSE-2.0
   Unless required by applicable law or agreed to in writing,
   software distributed under the License is distributed on an
   "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
   KIND, either express or implied.  See the License for the
   specific language governing permissions and limitations
   under the License.
-->

# incubator-kie-runtime-tools-consoles-helm-chart

![Version: 0.0.0](https://img.shields.io/badge/Version-0.0.0-informational?style=flat-square) ![Type: application](https://img.shields.io/badge/Type-application-informational?style=flat-square) ![AppVersion: 0.0.0](https://img.shields.io/badge/AppVersion-0.0.0-informational?style=flat-square)

A Helm chart to deploy Runtime Tools Consoles on Kubernetes

## Requirements

| Repository | Name               | Version |
| ---------- | ------------------ | ------- |
|            | management-console | 0.0.0   |
|            | task-console       | 0.0.0   |

## Values

| Key                                          | Type   | Default                                                                                                                                                                                                                                                 | Description                                                                                                                                      |
| -------------------------------------------- | ------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------ |
| global.dataIndexUrl                          | string | `""`                                                                                                                                                                                                                                                    | Set the URL that points to the Data Index service                                                                                                |
| global.environment                           | string | `"DEV"`                                                                                                                                                                                                                                                 | If want to enable Keycloak integration set it to PROD, otherwise set it to DEV                                                                   |
| global.ingressSource                         | string | `""`                                                                                                                                                                                                                                                    | Which ingress source is being used (none/"minikube"/"kubernetes"/"openshift") Obs.: For NOTES generation only                                    |
| global.keycloakClientId                      | string | `""`                                                                                                                                                                                                                                                    | If using environment = PROD, set the KeyCloak client id                                                                                          |
| global.keycloakHealthCheck                   | bool   | `false`                                                                                                                                                                                                                                                 | If using environment = PROD, enable or disable Keycloak health check                                                                             |
| global.keycloakHealthCheckUrl                | string | `""`                                                                                                                                                                                                                                                    | If using environment = PROD, set the KeyCloak health check url                                                                                   |
| global.keycloakRealm                         | string | `""`                                                                                                                                                                                                                                                    | If using environment = PROD, set the KeyCloak realm name                                                                                         |
| global.keycloakTokenValidity                 | string | `""`                                                                                                                                                                                                                                                    | If using environment = PROD, set the KeyCloak token validity                                                                                     |
| global.keycloakUrl                           | string | `""`                                                                                                                                                                                                                                                    | If using environment = PROD, set the KeyCloak auth url                                                                                           |
| global.kubernetesClusterDomain               | string | `""`                                                                                                                                                                                                                                                    | If using Minikube or Kubernetes, set the cluster domain                                                                                          |
| global.kubernetesIngressClass                | string | `""`                                                                                                                                                                                                                                                    | If using Minikube or Kubernetes, set the Ingress class (i.e: nginx)                                                                              |
| global.openshiftRouteDomain                  | string | `""`                                                                                                                                                                                                                                                    | If using OpenShift Routes, set the Route domain                                                                                                  |
| fullnameOverride                             | string | `""`                                                                                                                                                                                                                                                    | Overrides charts full name                                                                                                                       |
| nameOverride                                 | string | `""`                                                                                                                                                                                                                                                    | Overrides charts name                                                                                                                            |
| management-console.appNameOverride           | string | `""`                                                                                                                                                                                                                                                    | Overrides the deployed application name                                                                                                          |
| management-console.appVersionOverride        | string | `""`                                                                                                                                                                                                                                                    | Overrides the deployed application version                                                                                                       |
| management-console.autoscaling               | object | `{"enabled":false,"maxReplicas":100,"minReplicas":1,"targetCPUUtilizationPercentage":80}`                                                                                                                                                               | Management Console HorizontalPodAutoscaler configuration (https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/)            |
| management-console.enabled                   | bool   | `true`                                                                                                                                                                                                                                                  | Enable or disable Management Console installation                                                                                                |
| management-console.fullnameOverride          | string | `""`                                                                                                                                                                                                                                                    | Overrides charts full name                                                                                                                       |
| management-console.image                     | object | `{"account":"apache","name":"incubator-kie-kogito-management-console","pullPolicy":"IfNotPresent","registry":"docker.io","tag":"main"}`                                                                                                                 | Image source configuration for the Management Console image                                                                                      |
| management-console.imagePullSecrets          | list   | `[]`                                                                                                                                                                                                                                                    | Pull secrets used when pulling Management Console image                                                                                          |
| management-console.ingress                   | object | `{"annotations":{},"className":"{{ .Values.global.kubernetesIngressClass }}","enabled":false,"hosts":[{"host":"management-console.{{ .Values.global.kubernetesClusterDomain }}","paths":[{"path":"/","pathType":"ImplementationSpecific"}]}],"tls":[]}` | Management Console Ingress configuration (https://kubernetes.io/docs/concepts/services-networking/ingress/)                                      |
| management-console.name                      | string | `"management-console"`                                                                                                                                                                                                                                  | Component name                                                                                                                                   |
| management-console.nameOverride              | string | `""`                                                                                                                                                                                                                                                    | Overrides charts name                                                                                                                            |
| management-console.nodeSelector              | object | `{}`                                                                                                                                                                                                                                                    |                                                                                                                                                  |
| management-console.openshiftRoute            | object | `{"annotations":{},"enabled":false,"host":"management-console.{{ .Values.global.openshiftRouteDomain }}","tls":{"insecureEdgeTerminationPolicy":"None","termination":"edge"}}`                                                                          | Management Console OpenShift Route configuration (https://docs.openshift.com/container-platform/4.14/networking/routes/route-configuration.html) |
| management-console.service                   | object | `{"nodePort":"","port":8081,"targetPort":8080,"type":"ClusterIP"}`                                                                                                                                                                                      | Management Console Service configuration (https://kubernetes.io/docs/concepts/services-networking/service/)                                      |
| management-console.serviceAccount            | object | `{"annotations":{},"create":true,"name":""}`                                                                                                                                                                                                            | Management Console ServiceAccount configuration (https://kubernetes.io/docs/concepts/security/service-accounts/)                                 |
| task-console.appNameOverride                 | string | `""`                                                                                                                                                                                                                                                    | Overrides the deployed application name                                                                                                          |
| task-console.appTaskActiveStatesListOverride | string | `""`                                                                                                                                                                                                                                                    | Overrides the Task Console active states list                                                                                                    |
| task-console.appTaskStatesListOverride       | string | `""`                                                                                                                                                                                                                                                    | Overrides the Task Console states list                                                                                                           |
| task-console.appVersionOverride              | string | `""`                                                                                                                                                                                                                                                    | Overrides the deployed application version                                                                                                       |
| task-console.autoscaling                     | object | `{"enabled":false,"maxReplicas":100,"minReplicas":1,"targetCPUUtilizationPercentage":80}`                                                                                                                                                               | Task Console HorizontalPodAutoscaler configuration (https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/)                  |
| task-console.enabled                         | bool   | `true`                                                                                                                                                                                                                                                  | Enable or disable Task Console installation                                                                                                      |
| task-console.fullnameOverride                | string | `""`                                                                                                                                                                                                                                                    | Overrides charts full name                                                                                                                       |
| task-console.image                           | object | `{"account":"apache","name":"incubator-kie-kogito-task-console","pullPolicy":"IfNotPresent","registry":"docker.io","tag":"main"}`                                                                                                                       | Image source configuration for the Management Console image                                                                                      |
| task-console.imagePullSecrets                | list   | `[]`                                                                                                                                                                                                                                                    | Pull secrets used when pulling Management Console image                                                                                          |
| task-console.ingress                         | object | `{"annotations":{},"className":"{{ .Values.global.kubernetesIngressClass }}","enabled":false,"hosts":[{"host":"task-console.{{ .Values.global.kubernetesClusterDomain }}","paths":[{"path":"/","pathType":"ImplementationSpecific"}]}],"tls":[]}`       | Task Console Ingress configuration (https://kubernetes.io/docs/concepts/services-networking/ingress/)                                            |
| task-console.name                            | string | `"task-console"`                                                                                                                                                                                                                                        | Component name                                                                                                                                   |
| task-console.nameOverride                    | string | `""`                                                                                                                                                                                                                                                    | Overrides charts name                                                                                                                            |
| task-console.openshiftRoute                  | object | `{"annotations":{},"enabled":false,"host":"task-console.{{ .Values.global.openshiftRouteDomain }}","tls":{"insecureEdgeTerminationPolicy":"None","termination":"edge"}}`                                                                                | Task Console OpenShift Route configuration (https://docs.openshift.com/container-platform/4.14/networking/routes/route-configuration.html)       |
| task-console.service                         | object | `{"nodePort":"","port":8080,"targetPort":8080,"type":"ClusterIP"}`                                                                                                                                                                                      | Task Console Service configuration (https://kubernetes.io/docs/concepts/services-networking/service/)                                            |
| task-console.serviceAccount                  | object | `{"annotations":{},"create":true,"name":""}`                                                                                                                                                                                                            | Task Console ServiceAccount configuration (https://kubernetes.io/docs/concepts/security/service-accounts/)                                       |

---

Autogenerated from chart metadata using [helm-docs v1.13.1](https://github.com/norwoodj/helm-docs/releases/v1.13.1)
