/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
module.exports = {
  ProcessInstanceData: [
    {
      id: "e995b0d2-078a-488f-8346-0176ed8d5033",
      processId: "service",
      processName: "Hello Service",
      businessKey: null,
      parentProcessInstanceId: null,
      parentProcessInstance: null,
      roles: [],
      variables: {
        workflowdata: {
          name: "test",
          result: true,
        },
      },
      state: "COMPLETED",
      start: "2024-05-30T11:09:06.133Z",
      lastUpdate: "2024-05-30T11:09:26.859Z",
      end: "2024-05-30T11:09:26.858Z",
      addons: ["source-files", "cloudevents", "knative-eventing", "jobs-management"],
      endpoint: "http://localhost:4000/service",
      serviceUrl: "http://localhost:4000",
      source:
        '{\n  "id": "service",\n  "specVersion": "0.8.0",\n  "name": "Hello Service",\n  "start": "Service",\n  "dataInputSchema": "specs/workflow-service-schema.json",\n  "functions": [\n    {\n      "name": "isWinner",\n      "operation": "specs/workflow-service-openapi.json#isWinner",\n      "type": "rest"\n    }\n  ],\n  "states": [\n    {\n      "name": "Service",\n      "type": "operation",\n      "actions": [\n        {\n          "name": "CallService",\n          "functionRef": {\n            "refName": "isWinner",\n            "arguments": {}\n          }\n        }\n      ],\n      "end": true\n    }\n  ]\n}',
      error: null,
      childProcessInstances: [],
      nodes: [
        {
          id: "497b304c-8e32-4a24-8bb6-c0dbd6109693",
          nodeId: "2",
          name: "End",
          enter: "2024-05-30T11:09:26.858Z",
          exit: "2024-05-30T11:09:26.858Z",
          type: "EndNode",
          definitionId: "_jbpm-unique-28",
          __typename: "NodeInstance",
        },
        {
          id: "24449104-ed61-4a28-bb5c-55911184feae",
          nodeId: "3",
          name: "Service",
          enter: "2024-05-30T11:09:06.135Z",
          exit: "2024-05-30T11:09:26.857Z",
          type: "CompositeContextNode",
          definitionId: "_jbpm-unique-29",
          __typename: "NodeInstance",
        },
        {
          id: "fd699046-64ba-415f-9362-ddb6a09e172c",
          nodeId: "8",
          name: "EmbeddedEnd",
          enter: "2024-05-30T11:09:26.857Z",
          exit: "2024-05-30T11:09:26.857Z",
          type: "EndNode",
          definitionId: "_jbpm-unique-33",
          __typename: "NodeInstance",
        },
        {
          id: "6099f2af-0170-4a0b-a5eb-0ea212573876",
          nodeId: "7",
          name: "Script",
          enter: "2024-05-30T11:09:26.857Z",
          exit: "2024-05-30T11:09:26.857Z",
          type: "ActionNode",
          definitionId: "_jbpm-unique-32",
          __typename: "NodeInstance",
        },
        {
          id: "4ce7a05d-da28-45ec-a326-3a27cb2da2d6",
          nodeId: "6",
          name: "isWinner",
          enter: "2024-05-30T11:09:06.137Z",
          exit: "2024-05-30T11:09:26.857Z",
          type: "WorkItemNode",
          definitionId: "_jbpm-unique-31",
          __typename: "NodeInstance",
        },
        {
          id: "92fe7466-d562-46be-a709-88e9564343da",
          nodeId: "4",
          name: "EmbeddedStart",
          enter: "2024-05-30T11:09:06.136Z",
          exit: "2024-05-30T11:09:06.136Z",
          type: "StartNode",
          definitionId: "_jbpm-unique-30",
          __typename: "NodeInstance",
        },
        {
          id: "e30f54f0-773d-472e-90b7-4a36ce73ce38",
          nodeId: "1",
          name: "Start",
          enter: "2024-05-30T11:09:06.134Z",
          exit: "2024-05-30T11:09:06.134Z",
          type: "StartNode",
          definitionId: "_jbpm-unique-27",
          __typename: "NodeInstance",
        },
      ],
      milestones: [],
      __typename: "ProcessInstance",
    },
    {
      id: "30c5ac5a-a310-48eb-b820-01939a7bd606",
      processId: "yamlgreet",
      processName: "Greeting workflow",
      businessKey: null,
      parentProcessInstanceId: null,
      parentProcessInstance: null,
      roles: [],
      variables: {
        workflowdata: {
          name: "Robert",
          greeting: "Hello from YAML Workflow, ",
          language: "English",
        },
      },
      state: "ERROR",
      start: "2024-05-30T11:08:49.509Z",
      lastUpdate: "2024-05-30T11:08:49.533Z",
      end: "2024-05-30T11:08:49.531Z",
      addons: ["source-files", "cloudevents", "knative-eventing", "jobs-management"],
      endpoint: "http://localhost:4000/yamlgreet",
      serviceUrl: "http://localhost:4000",
      source:
        "id: yamlgreet\nversion: '1.0'\nname: Greeting workflow\ndescription: YAML based greeting workflow\nexpressionLang: jsonpath\nstart: ChooseOnLanguage\nfunctions:\n  - name: greetFunction\n    type: custom\n    operation: sysout\nstates:\n  - name: ChooseOnLanguage\n    type: switch\n    dataConditions:\n      - condition: \"${$.[?(@.language  == 'English')]}\"\n        transition: GreetInEnglish\n      - condition: \"${$.[?(@.language  == 'Spanish')]}\"\n        transition: GreetInSpanish\n    defaultCondition:\n      transition: GreetInEnglish\n  - name: GreetInEnglish\n    type: inject\n    data:\n      greeting: 'Hello from YAML Workflow, '\n    transition: GreetPerson\n  - name: GreetInSpanish\n    type: inject\n    data:\n      greeting: 'Saludos desde YAML Workflow, '\n    transition: GreetPerson\n  - name: GreetPerson\n    type: operation\n    actions:\n      - name: greetAction\n        functionRef:\n          refName: greetFunction\n          arguments:\n            message: \"$.greeting $.name\"\n    end:\n      terminate: true\n",
      error: null,
      childProcessInstances: [],
      nodes: [
        {
          id: "533b19ed-10e5-42d1-a03a-f227c2a387ea",
          nodeId: "2",
          name: "End",
          enter: "2024-05-30T11:08:49.531Z",
          exit: "2024-05-30T11:08:49.531Z",
          type: "EndNode",
          definitionId: "_jbpm-unique-13",
          __typename: "NodeInstance",
        },
        {
          id: "4f4b4e08-14ea-483f-a16c-fdcffa6f4f8d",
          nodeId: "6",
          name: "GreetPerson",
          enter: "2024-05-30T11:08:49.529Z",
          exit: "2024-05-30T11:08:49.531Z",
          type: "CompositeContextNode",
          definitionId: "_jbpm-unique-17",
          __typename: "NodeInstance",
        },
        {
          id: "41c669d5-2491-491b-95a2-315a8aa94f6a",
          nodeId: "11",
          name: "EmbeddedEnd",
          enter: "2024-05-30T11:08:49.531Z",
          exit: "2024-05-30T11:08:49.531Z",
          type: "EndNode",
          definitionId: "_jbpm-unique-21",
          __typename: "NodeInstance",
        },
        {
          id: "7ccb8991-0825-4ec3-9b97-ec8a6158c940",
          nodeId: "10",
          name: "Script",
          enter: "2024-05-30T11:08:49.53Z",
          exit: "2024-05-30T11:08:49.53Z",
          type: "ActionNode",
          definitionId: "_jbpm-unique-20",
          __typename: "NodeInstance",
        },
        {
          id: "4507ef41-2e4a-4646-80a5-6d9c8d1f42d7",
          nodeId: "9",
          name: "greetFunction",
          enter: "2024-05-30T11:08:49.53Z",
          exit: "2024-05-30T11:08:49.53Z",
          type: "ActionNode",
          definitionId: "_jbpm-unique-19",
          __typename: "NodeInstance",
        },
        {
          id: "f61359dc-ae09-45d8-912f-dfde81758d33",
          nodeId: "7",
          name: "EmbeddedStart",
          enter: "2024-05-30T11:08:49.529Z",
          exit: "2024-05-30T11:08:49.529Z",
          type: "StartNode",
          definitionId: "_jbpm-unique-18",
          __typename: "NodeInstance",
        },
        {
          id: "4029f68f-d1b8-4337-ad2f-9df8c6132d3c",
          nodeId: "13",
          name: "Join-GreetPerson",
          enter: "2024-05-30T11:08:49.529Z",
          exit: "2024-05-30T11:08:49.529Z",
          type: "Join",
          definitionId: "_jbpm-unique-23",
          __typename: "NodeInstance",
        },
        {
          id: "382aac0d-743f-4183-bd0a-ea23eb1fbd13",
          nodeId: "4",
          name: "GreetInEnglish",
          enter: "2024-05-30T11:08:49.528Z",
          exit: "2024-05-30T11:08:49.528Z",
          type: "ActionNode",
          definitionId: "_jbpm-unique-15",
          __typename: "NodeInstance",
        },
        {
          id: "70478aa1-fa54-4c17-a76a-4fd567fb9d96",
          nodeId: "12",
          name: "Join-GreetInEnglish",
          enter: "2024-05-30T11:08:49.527Z",
          exit: "2024-05-30T11:08:49.527Z",
          type: "Join",
          definitionId: "_jbpm-unique-22",
          __typename: "NodeInstance",
        },
        {
          id: "08da8e80-5790-488d-a228-fe79a1a40b7d",
          nodeId: "3",
          name: "ChooseOnLanguage",
          enter: "2024-05-30T11:08:49.51Z",
          exit: "2024-05-30T11:08:49.527Z",
          type: "Split",
          definitionId: "3",
          __typename: "NodeInstance",
        },
        {
          id: "e7ca942d-984a-4822-8e59-fef3409e03f2",
          nodeId: "1",
          name: "Start",
          enter: "2024-05-30T11:08:49.509Z",
          exit: "2024-05-30T11:08:49.51Z",
          type: "StartNode",
          definitionId: "_jbpm-unique-12",
          __typename: "NodeInstance",
        },
      ],
      milestones: [],
      __typename: "ProcessInstance",
    },
    {
      id: "c154e49a-2e7a-4a88-83b2-4a9116dd152f",
      processId: "jsongreet",
      processName: "Greeting workflow",
      businessKey: null,
      parentProcessInstanceId: null,
      parentProcessInstance: null,
      roles: [],
      variables: {
        workflowdata: {
          name: "Fabrizio",
          greeting: "Saludos desde JSON Workflow, ",
          language: "Spanish",
        },
      },
      state: "COMPLETED",
      start: "2024-05-30T11:08:23.348Z",
      lastUpdate: "2024-05-30T11:08:23.355Z",
      end: "2024-05-30T11:08:23.353Z",
      addons: ["source-files", "cloudevents", "knative-eventing", "jobs-management"],
      endpoint: "http://localhost:4000/jsongreet",
      serviceUrl: "http://localhost:4000",
      source:
        '{\n  "id": "jsongreet",\n  "version": "1.0",\n  "name": "Greeting workflow",\n  "description": "JSON based greeting workflow",\n  "start": "ChooseOnLanguage",\n  "functions": [\n    {\n      "name": "greetFunction",\n      "type": "custom",\n      "operation": "sysout"\n    }\n  ],\n  "states": [\n    {\n      "name": "ChooseOnLanguage",\n      "type": "switch",\n      "dataConditions": [\n        {\n          "condition": "${ .language == \\"English\\" }",\n          "transition": "GreetInEnglish"\n        },\n        {\n          "condition": "${ .language == \\"Spanish\\" }",\n          "transition": "GreetInSpanish"\n        }\n      ],\n      "defaultCondition": {\n        "transition": "GreetInEnglish"\n      }\n    },\n    {\n      "name": "GreetInEnglish",\n      "type": "inject",\n      "data": {\n        "greeting": "Hello from JSON Workflow, "\n      },\n      "transition": "GreetPerson"\n    },\n    {\n      "name": "GreetInSpanish",\n      "type": "inject",\n      "data": {\n        "greeting": "Saludos desde JSON Workflow, "\n      },\n      "transition": "GreetPerson"\n    },\n    {\n      "name": "GreetPerson",\n      "type": "operation",\n      "actions": [\n        {\n          "name": "greetAction",\n          "functionRef": {\n            "refName": "greetFunction",\n            "arguments": {\n              "message": ".greeting+.name"\n            }\n          }\n        }\n      ],\n      "end": true\n    }\n  ]\n}\n',
      error: null,
      childProcessInstances: [],
      nodes: [
        {
          id: "08db72d0-3edd-419c-8338-40960e378e67",
          nodeId: "2",
          name: "End",
          enter: "2024-05-30T11:08:23.353Z",
          exit: "2024-05-30T11:08:23.353Z",
          type: "EndNode",
          definitionId: "_jbpm-unique-1",
          __typename: "NodeInstance",
        },
        {
          id: "64f78cad-d8e5-4cfb-9361-6ba01f5e4053",
          nodeId: "6",
          name: "GreetPerson",
          enter: "2024-05-30T11:08:23.351Z",
          exit: "2024-05-30T11:08:23.352Z",
          type: "CompositeContextNode",
          definitionId: "_jbpm-unique-5",
          __typename: "NodeInstance",
        },
        {
          id: "129ebf4e-b7e5-4eef-9942-46fdfd9af692",
          nodeId: "11",
          name: "EmbeddedEnd",
          enter: "2024-05-30T11:08:23.352Z",
          exit: "2024-05-30T11:08:23.352Z",
          type: "EndNode",
          definitionId: "_jbpm-unique-9",
          __typename: "NodeInstance",
        },
        {
          id: "6936a361-ba14-4a8b-9f5c-7ea3cf5085c9",
          nodeId: "10",
          name: "Script",
          enter: "2024-05-30T11:08:23.352Z",
          exit: "2024-05-30T11:08:23.352Z",
          type: "ActionNode",
          definitionId: "_jbpm-unique-8",
          __typename: "NodeInstance",
        },
        {
          id: "c3700476-a24b-49b4-bf71-2cd4b9b24dbe",
          nodeId: "9",
          name: "greetFunction",
          enter: "2024-05-30T11:08:23.352Z",
          exit: "2024-05-30T11:08:23.352Z",
          type: "ActionNode",
          definitionId: "_jbpm-unique-7",
          __typename: "NodeInstance",
        },
        {
          id: "b97d84c4-b532-4416-9582-31892a6618e1",
          nodeId: "7",
          name: "EmbeddedStart",
          enter: "2024-05-30T11:08:23.352Z",
          exit: "2024-05-30T11:08:23.352Z",
          type: "StartNode",
          definitionId: "_jbpm-unique-6",
          __typename: "NodeInstance",
        },
        {
          id: "313e29e6-6712-4013-b0b0-bd2ac1206c42",
          nodeId: "13",
          name: "Join-GreetPerson",
          enter: "2024-05-30T11:08:23.351Z",
          exit: "2024-05-30T11:08:23.351Z",
          type: "Join",
          definitionId: "_jbpm-unique-11",
          __typename: "NodeInstance",
        },
        {
          id: "4f548748-8b66-43ca-b41e-674c5125d65d",
          nodeId: "5",
          name: "GreetInSpanish",
          enter: "2024-05-30T11:08:23.349Z",
          exit: "2024-05-30T11:08:23.351Z",
          type: "ActionNode",
          definitionId: "_jbpm-unique-4",
          __typename: "NodeInstance",
        },
        {
          id: "474f3db4-eb79-4879-acf7-a6f4c7b9910f",
          nodeId: "3",
          name: "ChooseOnLanguage",
          enter: "2024-05-30T11:08:23.349Z",
          exit: "2024-05-30T11:08:23.349Z",
          type: "Split",
          definitionId: "3",
          __typename: "NodeInstance",
        },
        {
          id: "58bb6572-0864-4952-9893-88f042e7e71e",
          nodeId: "1",
          name: "Start",
          enter: "2024-05-30T11:08:23.349Z",
          exit: "2024-05-30T11:08:23.349Z",
          type: "StartNode",
          definitionId: "_jbpm-unique-0",
          __typename: "NodeInstance",
        },
      ],
      milestones: [],
      __typename: "ProcessInstance",
    },
    {
      id: "2bf6fac3-b06a-49a8-abd8-ac1a44ca9750",
      processId: "hello",
      processName: "Hello World",
      businessKey: null,
      parentProcessInstanceId: null,
      parentProcessInstance: null,
      roles: [],
      variables: {
        workflowdata: {
          message: "Hello World",
        },
      },
      state: "COMPLETED",
      start: "2024-05-30T11:07:57.536Z",
      lastUpdate: "2024-05-30T11:07:57.541Z",
      end: "2024-05-30T11:07:57.538Z",
      addons: ["source-files", "cloudevents", "knative-eventing", "jobs-management"],
      endpoint: "http://localhost:4000/hello",
      serviceUrl: "http://localhost:4000",
      source:
        '{\n  "id": "hello",\n  "specVersion": "0.8.0",\n  "name": "Hello World",\n  "start": "HelloWorld",\n  "states": [\n    {\n      "name": "HelloWorld",\n      "type": "inject",\n      "data": {\n        "message": "Hello World"\n      },\n      "end": true\n    }\n  ]\n}',
      error: null,
      childProcessInstances: [],
      nodes: [
        {
          id: "5ac4532b-3323-480e-a0e0-f5c5821780c8",
          nodeId: "2",
          name: "End",
          enter: "2024-05-30T11:07:57.538Z",
          exit: "2024-05-30T11:07:57.538Z",
          type: "EndNode",
          definitionId: "_jbpm-unique-25",
          __typename: "NodeInstance",
        },
        {
          id: "2031aaac-635c-448b-b372-044fd408268e",
          nodeId: "3",
          name: "HelloWorld",
          enter: "2024-05-30T11:07:57.537Z",
          exit: "2024-05-30T11:07:57.538Z",
          type: "ActionNode",
          definitionId: "_jbpm-unique-26",
          __typename: "NodeInstance",
        },
        {
          id: "17d1a632-b5c7-4a28-84a9-d381e296c812",
          nodeId: "1",
          name: "Start",
          enter: "2024-05-30T11:07:57.536Z",
          exit: "2024-05-30T11:07:57.537Z",
          type: "StartNode",
          definitionId: "_jbpm-unique-24",
          __typename: "NodeInstance",
        },
      ],
      milestones: [],
      __typename: "ProcessInstance",
    },
  ],
  ProcessDefinitionData: [
    {
      id: "service",
      endpoint: "http://localhost:4000/service",
      serviceUrl: "http://localhost:4000",
      __typename: "ProcessDefinition",
    },
    {
      id: "systout",
      endpoint: "http://localhost:4000/systout",
      serviceUrl: "http://localhost:4000",
      __typename: "ProcessDefinition",
    },
    {
      id: "jsongreet",
      endpoint: "http://localhost:4000/jsongreet",
      serviceUrl: "http://localhost:4000",
      __typename: "ProcessDefinition",
    },
    {
      id: "hello",
      endpoint: "http://localhost:4000/hello",
      serviceUrl: "http://localhost:4000",
      __typename: "ProcessDefinition",
    },
    {
      id: "order",
      endpoint: "http://localhost:4000/order",
      serviceUrl: "http://localhost:4000",
      __typename: "ProcessDefinition",
    },
    {
      id: "yamlgreet",
      endpoint: "http://localhost:4000/yamlgreet",
      serviceUrl: "http://localhost:4000",
      __typename: "ProcessDefinition",
    },
    {
      id: "formError",
      endpoint: "http://localhost:4000/formError",
      serviceUrl: "http://localhost:4000",
      __typename: "ProcessDefinition",
    },
  ],
  JobsData: [],
};
