/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.Flags;
import com.google.jstestdriver.PathResolver;
import com.google.jstestdriver.Plugin;
import com.google.jstestdriver.browser.DocType;
import com.google.jstestdriver.config.Configuration;
import com.google.jstestdriver.config.ConfigurationException;
import com.google.jstestdriver.config.ResolvedConfiguration;
import com.google.jstestdriver.model.HandlerPathPrefix;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedConfiguration
implements Configuration {
    private final Set<FileInfo> filesList;
    private final String server;
    private final List<Plugin> plugins;
    private final Set<FileInfo> excludedFiles;
    private final long testTimeout;
    private final List<FileInfo> tests;
    private final File basePath;
    private final JsonArray gatewayConfig;
    private final DocType doctype;

    public ParsedConfiguration(Set<FileInfo> filesList, Set<FileInfo> excludedFiles, List<Plugin> plugins, String server, long testTimeout, File basePath, List<FileInfo> tests, JsonArray gatewayConfig, DocType doctype) {
        this.filesList = filesList;
        this.excludedFiles = excludedFiles;
        this.plugins = plugins;
        this.server = server;
        this.testTimeout = testTimeout;
        this.basePath = basePath;
        this.tests = tests;
        this.gatewayConfig = gatewayConfig;
        this.doctype = doctype;
    }

    @Override
    public Set<FileInfo> getFilesList() {
        LinkedHashSet<FileInfo> finalList = new LinkedHashSet<FileInfo>(this.filesList);
        finalList.removeAll(this.excludedFiles);
        return finalList;
    }

    @Override
    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    @Override
    public String getServer(String flagValue, int port, HandlerPathPrefix handlerPrefix) {
        if (flagValue != null && flagValue.length() != 0) {
            return handlerPrefix.suffixServer(flagValue);
        }
        if (this.server.length() > 0) {
            return handlerPrefix.suffixServer(this.server);
        }
        if (port == -1) {
            throw new ConfigurationException("Oh Snap! No server defined!");
        }
        return handlerPrefix.suffixServer(String.format("http://%s:%d", "127.0.0.1", port));
    }

    @Override
    public String getCaptureAddress(String server, String captureAddress, HandlerPathPrefix prefix) {
        if (captureAddress != null && !captureAddress.isEmpty()) {
            return prefix.suffixServer(captureAddress);
        }
        return server;
    }

    @Override
    public Configuration resolvePaths(PathResolver resolver, Flags flags) {
        Set<FileInfo> resolvedFiles = resolver.resolve(this.filesList);
        Set<FileInfo> testFiles = resolver.resolve(Sets.newLinkedHashSet(this.tests));
        Set<FileInfo> resolvedExcluded = resolver.resolve(this.excludedFiles);
        resolvedFiles.removeAll(resolvedExcluded);
        testFiles.removeAll(resolvedExcluded);
        return new ResolvedConfiguration(resolvedFiles, resolver.resolve(this.plugins), this.getServer(flags.getServer(), flags.getPort(), flags.getServerHandlerPrefix()), this.testTimeout, this.basePath, Lists.newArrayList(testFiles), this.gatewayConfig);
    }

    @Override
    public long getTestSuiteTimeout() {
        return this.testTimeout;
    }

    @Override
    public List<FileInfo> getTests() {
        return this.tests;
    }

    @Override
    public File getBasePath() {
        return this.basePath;
    }

    @Override
    public JsonArray getGatewayConfiguration() {
        return this.gatewayConfig;
    }

    @Override
    public DocType getDocType() {
        return this.doctype;
    }
}

