/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.model;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.hooks.ResourcePreProcessor;
import com.google.jstestdriver.model.JstdTestCaseFactory;
import com.google.jstestdriver.model.RunData;
import com.google.jstestdriver.util.StopWatch;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunDataFactory {
    private final Set<FileInfo> fileSet;
    private final Set<ResourcePreProcessor> processors;
    private final List<FileInfo> tests;
    private final JstdTestCaseFactory testCaseFactory;
    private final List<FileInfo> plugins;
    private final StopWatch stopWatch;

    @Inject
    public RunDataFactory(@Named(value="fileSet") Set<FileInfo> fileSet, @Named(value="tests") List<FileInfo> tests, Set<ResourcePreProcessor> processors, @Named(value="plugins") List<FileInfo> plugins, JstdTestCaseFactory testCaseFactory, StopWatch stopWatch) {
        this.fileSet = fileSet;
        this.tests = tests;
        this.processors = processors;
        this.plugins = plugins;
        this.testCaseFactory = testCaseFactory;
        this.stopWatch = stopWatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunData get() {
        this.stopWatch.start("Create RunData", new Object[0]);
        try {
            List<FileInfo> processedDependencies = Lists.newLinkedList(this.fileSet);
            List<FileInfo> processedPlugins = Lists.newLinkedList(this.plugins);
            List<FileInfo> processedTests = Lists.newLinkedList(this.tests);
            for (ResourcePreProcessor processor : this.processors) {
                this.stopWatch.start(processor.toString(), new Object[0]);
                processedPlugins = processor.processPlugins(processedPlugins);
                processedTests = processor.processTests(processedTests);
                processedDependencies = processor.processDependencies(processedDependencies);
                this.stopWatch.stop(processor.toString(), new Object[0]);
            }
            RunData runData = new RunData(Collections.<ResponseStream>emptyList(), this.testCaseFactory.createCases(processedPlugins, processedDependencies, processedTests), this.testCaseFactory);
            return runData;
        }
        finally {
            this.stopWatch.stop("Create RunData", new Object[0]);
        }
    }
}

