/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.FailureException;
import com.google.jstestdriver.FileUploader;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.Server;
import com.google.jstestdriver.StreamMessage;
import com.google.jstestdriver.browser.BrowserPanicException;
import com.google.jstestdriver.model.JstdTestCase;
import com.google.jstestdriver.util.StopWatch;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandTask {
    private static final Logger logger = LoggerFactory.getLogger(CommandTask.class);
    private final Gson gson = new Gson();
    private final ResponseStream stream;
    private final String baseUrl;
    private final Server server;
    private final Map<String, String> params;
    private final boolean upload;
    private final StopWatch stopWatch;
    private final FileUploader fileUploader;

    public CommandTask(ResponseStream stream, String baseUrl, Server server, Map<String, String> params, boolean upload, StopWatch stopWatch, FileUploader uploader) {
        this.stream = stream;
        this.baseUrl = baseUrl;
        this.server = server;
        this.params = params;
        this.upload = upload;
        this.stopWatch = stopWatch;
        this.fileUploader = uploader;
    }

    private void checkBrowser() {
        String alive = this.server.fetch(this.baseUrl + "/heartbeat?id=" + this.params.get("id"));
        if (!alive.equals("OK")) {
            throw new FailureException(String.format("Browser is not available\n %s \n for\n %s", alive, this.params));
        }
    }

    private BrowserInfo getBrowser(String id) {
        Collection browsers = (Collection)this.gson.fromJson(this.server.fetch(this.baseUrl + "/cmd?listBrowsers"), new TypeToken<Collection<BrowserInfo>>(){}.getType());
        for (BrowserInfo browser : browsers) {
            if (!id.equals(String.valueOf(browser.getId()))) continue;
            return browser;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(JstdTestCase testCase) {
        this.stopWatch.start("run %s", testCase.getId());
        String browserId = this.params.get("id");
        this.stopWatch.start("checkBrowser %s", browserId);
        this.checkBrowser();
        this.stopWatch.stop("checkBrowser %s", browserId);
        logger.debug("Starting upload for {}", (Object)browserId);
        if (this.upload) {
            this.fileUploader.uploadToTheBrowser(browserId, this.stream, this.fileUploader.determineBrowserFileSet(browserId, testCase, this.stream), this.getBrowser(browserId).getUploadSize());
        }
        logger.debug("Finished upload for {}", (Object)browserId);
        this.stopWatch.start("post %s", this.params);
        this.server.post(this.baseUrl + "/cmd", this.params);
        this.stopWatch.stop("post %s", this.params);
        try {
            logger.debug("Starting {} for {}", (Object)this.params.get("data"), (Object)browserId);
            this.stopWatch.start("execution %s", this.params.get("data"));
            StreamMessage streamMessage = null;
            do {
                String response = this.server.fetch(this.baseUrl + "/cmd?id=" + browserId);
                try {
                    streamMessage = this.gson.fromJson(response, StreamMessage.class);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error deserializing: " + response, e);
                }
                Response resObj = streamMessage.getResponse();
                if (Response.ResponseType.BROWSER_PANIC.equals((Object)resObj.getResponseType())) {
                    throw new BrowserPanicException(resObj.getBrowser(), resObj.getResponse());
                }
                this.stream.stream(resObj);
            } while (!streamMessage.isLast());
            logger.debug("finished {} for {} with {}", new Object[]{this.params.get("data"), browserId, streamMessage.getResponse().getResponseType()});
        }
        catch (Throwable throwable) {
            this.stopWatch.stop("execution %s", this.params.get("data"));
            logger.debug("finished {} for {}", (Object)this.params.get("data"), (Object)browserId);
            this.stopWatch.stop("run %s", testCase.getId());
            throw throwable;
        }
        this.stopWatch.stop("execution %s", this.params.get("data"));
        logger.debug("finished {} for {}", (Object)this.params.get("data"), (Object)browserId);
        this.stopWatch.stop("run %s", testCase.getId());
    }
}

