/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.jstestdriver.Plugin;
import com.google.jstestdriver.config.CmdLineFlag;
import com.google.jstestdriver.config.CmdLineFlagMetaData;
import com.google.jstestdriver.config.ConfigurationSource;
import com.google.jstestdriver.config.DefaultConfigurationSource;
import com.google.jstestdriver.config.UserConfigurationSource;
import com.google.jstestdriver.runner.RunnerMode;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdFlags {
    private static final Map<String, CmdLineFlagMetaData> PREPARSE_FLAGS = ImmutableMap.builder().put("--plugins", new CmdLineFlagMetaData("--plugins", "VAL[,VAL]", "Comma separated list of paths to plugin jars.")).put("--config", new CmdLineFlagMetaData("--config", "VAL", "Path to configuration file.")).put("--basePath", new CmdLineFlagMetaData("--basePath", "VAL", "Override the base path in the configuration file. Defaults to the parent directory of the configuration file.")).put("--runnerMode", new CmdLineFlagMetaData("--runnerMode", "VAL", "The configuration of the logging and frequency that the runner reports actions: DEBUG, DEBUG_NO_TRACE, DEBUG_OBSERVE, PROFILE, QUIET (default), INFO")).build();
    private final List<CmdLineFlag> flags;

    public CmdFlags(List<CmdLineFlag> flags) {
        this.flags = flags;
    }

    public List<Plugin> getPlugins() throws IOException {
        for (CmdLineFlag cmdLineFlag : this.flags) {
            if (!"--plugins".equals(cmdLineFlag.flag)) continue;
            LinkedList<Plugin> plugins = Lists.newLinkedList();
            for (String pluginPath : cmdLineFlag.valuesList()) {
                plugins.add(new Plugin(null, new File(this.getBasePath(), pluginPath).getAbsolutePath(), null, Collections.<String>emptyList()));
            }
            return plugins;
        }
        return Collections.emptyList();
    }

    private String getConfigPathNoDefault() {
        for (CmdLineFlag cmdLineFlag : this.flags) {
            if (!"--config".equals(cmdLineFlag.flag)) continue;
            return cmdLineFlag.safeValue();
        }
        return null;
    }

    private String getBasePathNoDefault() throws IOException {
        for (CmdLineFlag cmdLineFlag : this.flags) {
            if (!"--basePath".equals(cmdLineFlag.flag)) continue;
            return new File(cmdLineFlag.safeValue()).getCanonicalPath();
        }
        return null;
    }

    public ConfigurationSource getConfigurationSource() throws IOException {
        String configPath = this.getConfigPathNoDefault();
        if (configPath != null) {
            return new UserConfigurationSource(new File(configPath).getAbsoluteFile());
        }
        return new DefaultConfigurationSource();
    }

    public File getBasePath() throws IOException {
        String basePath = this.getBasePathNoDefault();
        if (basePath != null) {
            return new File(basePath);
        }
        return this.getConfigurationSource().getParentFile();
    }

    public RunnerMode getRunnerMode() {
        for (CmdLineFlag cmdLineFlag : this.flags) {
            if (!"--runnerMode".equals(cmdLineFlag.flag)) continue;
            return RunnerMode.valueOf(cmdLineFlag.safeValue());
        }
        return RunnerMode.QUIET;
    }

    public String[] getUnusedFlagsAsArgs() {
        ArrayList<String> args = Lists.newArrayList();
        for (CmdLineFlag flag : this.flags) {
            if (PREPARSE_FLAGS.containsKey(flag.flag)) continue;
            flag.addToArgs(args);
        }
        return args.toArray(new String[args.size()]);
    }

    public static void printUsage(PrintStream out) {
        for (CmdLineFlagMetaData meta : PREPARSE_FLAGS.values()) {
            try {
                meta.printUsage(out);
                out.write(10);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

