/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.collect.Sets;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.FileLoader;
import com.google.jstestdriver.JsTestDriverServer;
import com.google.jstestdriver.JsTestDriverServerImpl;
import com.google.jstestdriver.ObservableAction;
import com.google.jstestdriver.URLRewriter;
import com.google.jstestdriver.URLTranslator;
import com.google.jstestdriver.config.ExecutionType;
import com.google.jstestdriver.hooks.FileInfoScheme;
import com.google.jstestdriver.hooks.ServerListener;
import com.google.jstestdriver.model.JstdTestCase;
import com.google.jstestdriver.model.NullPathPrefix;
import com.google.jstestdriver.model.RunData;
import com.google.jstestdriver.server.JstdTestCaseStore;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerStartupAction
implements ObservableAction {
    private static final Logger logger = LoggerFactory.getLogger(ServerStartupAction.class);
    private final int port;
    private final int sslPort;
    private final JstdTestCaseStore testCaseStore;
    private JsTestDriverServer server;
    private List<Observer> observerList = new LinkedList<Observer>();
    private final boolean preloadFiles;
    private final FileLoader fileLoader;
    private final JsTestDriverServer.Factory serverFactory;

    @Deprecated
    public ServerStartupAction(int port, int sslPort, CapturedBrowsers capturedBrowsers, JstdTestCaseStore testCaseStore, URLTranslator urlTranslator, URLRewriter urlRewriter) {
        this(port, sslPort, testCaseStore, false, null, new DefaultServerFactory(capturedBrowsers, 30000L, new NullPathPrefix()));
    }

    public ServerStartupAction(int port, int sslPort, JstdTestCaseStore testCaseStore, boolean preloadFiles, FileLoader fileLoader, JsTestDriverServer.Factory serverFactory) {
        this.port = port;
        this.sslPort = sslPort;
        this.testCaseStore = testCaseStore;
        this.preloadFiles = preloadFiles;
        this.fileLoader = fileLoader;
        this.serverFactory = serverFactory;
    }

    public JsTestDriverServer getServer() {
        return this.server;
    }

    @Override
    public RunData run(RunData runData) {
        logger.info("Starting server on {}, ssl on {}", this.port, (Object)this.sslPort);
        if (this.preloadFiles) {
            logger.debug("Preloading files...");
            for (JstdTestCase testCase : runData.getTestCases()) {
                this.testCaseStore.addCase(testCase.applyDelta(testCase.createUnloadedDelta().loadFiles(this.fileLoader)));
            }
        }
        this.server = this.serverFactory.create(this.port, this.sslPort, this.testCaseStore);
        if (!this.observerList.isEmpty()) {
            throw new RuntimeException("Observers not supported during the transition to listeners.");
        }
        try {
            this.server.start();
            for (int i = 1; i < 31; ++i) {
                if (this.server.isHealthy()) {
                    return runData;
                }
                Thread.sleep(1000L);
                if (i % 6 != 0) continue;
                logger.warn("Stopping unhealthy server and trying again.");
                this.server.stop();
                this.server.start();
            }
            throw new ServerStartupException("Server never healthy on " + this.port);
        }
        catch (Exception e) {
            throw new ServerStartupException("Error starting the server on " + this.port, e);
        }
    }

    @Override
    public void addObservers(List<Observer> observers) {
        this.observerList.addAll(observers);
    }

    public static class ServerStartupException
    extends RuntimeException {
        private static final long serialVersionUID = -6070989642608849122L;

        public ServerStartupException(String msg) {
            super(msg);
        }

        public ServerStartupException(String msg, Exception e) {
            super(msg, e);
        }
    }

    private static final class DefaultServerFactory
    implements JsTestDriverServer.Factory {
        private final CapturedBrowsers capturedBrowsers;
        private final long timeout;
        private final NullPathPrefix nullPathPrefix;

        public DefaultServerFactory(CapturedBrowsers capturedBrowsers, long timeout, NullPathPrefix nullPathPrefix) {
            this.capturedBrowsers = capturedBrowsers;
            this.timeout = timeout;
            this.nullPathPrefix = nullPathPrefix;
        }

        public JsTestDriverServer create(int port, int sslPort, JstdTestCaseStore testCaseStore) {
            return new JsTestDriverServerImpl(port, sslPort, testCaseStore, this.capturedBrowsers, this.timeout, this.nullPathPrefix, Sets.<ServerListener>newHashSet(), Collections.<FileInfoScheme>emptySet(), ExecutionType.INTERACTIVE);
        }
    }
}

