/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers;

import com.google.inject.Inject;
import com.google.jstestdriver.FilesCache;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import com.google.jstestdriver.server.JstdTestCaseStore;
import com.google.jstestdriver.server.handlers.StaticResourceHandler;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TestResourceHandler
implements RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(TestResourceHandler.class);
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final JstdTestCaseStore store;

    @Inject
    public TestResourceHandler(HttpServletRequest request, HttpServletResponse response, JstdTestCaseStore store) {
        this.request = request;
        this.response = response;
        this.store = store;
    }

    public void handleIt() throws IOException {
        String fileName = this.request.getPathInfo().substring(1);
        this.service(fileName, this.response.getWriter());
    }

    public void service(String fileName, PrintWriter writer) throws IOException {
        try {
            String fileContent = this.store.getFileContent(fileName);
            String mimeType = this.parseMimeType(fileName);
            if (mimeType != null) {
                this.response.setContentType(mimeType);
            } else {
                this.response.setHeader("Content-Type", "text/plain");
            }
            writer.write(fileContent);
            writer.flush();
        }
        catch (FilesCache.MissingFileException e) {
            this.response.sendError(404);
        }
    }

    private String parseMimeType(String fileName) {
        int extension = fileName.lastIndexOf(".");
        if (extension == -1) {
            return null;
        }
        return StaticResourceHandler.MIME_TYPE_MAP.get(fileName.substring(extension + 1));
    }
}

