
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'RethrowError')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].RethrowError AS RETURN')
END
GO

ALTER PROCEDURE RethrowError AS
    /* Return if there is no error information to retrieve. */
    IF ERROR_NUMBER() IS NULL
        RETURN;

    DECLARE
        @ErrorMessage    NVARCHAR(4000),
        @ErrorNumber     INT,
        @ErrorSeverity   INT,
        @ErrorState      INT,
        @ErrorLine       INT,
        @ErrorProcedure  NVARCHAR(200); 

    /* Assign variables to error-handling functions that
       capture information for RAISERROR. */

    SELECT
        @ErrorNumber = ERROR_NUMBER(),
        @ErrorSeverity = ERROR_SEVERITY(),
        @ErrorState = ERROR_STATE(),
        @ErrorLine = ERROR_LINE(),
        @ErrorProcedure = ISNULL(ERROR_PROCEDURE(), '-'); 

    /* Building the message string that will contain original
       error information. */

    SELECT @ErrorMessage = 
        N'Error %d, Level %d, State %d, Procedure %s, Line %d, ' + 
         'Message: '+ ERROR_MESSAGE(); 

    /* Raise an error: msg_str parameter of RAISERROR will contain
	   the original error information. */

    RAISERROR(@ErrorMessage, @ErrorSeverity, 1,
        @ErrorNumber,    /* parameter: original error number. */
        @ErrorSeverity,  /* parameter: original error severity. */
        @ErrorState,     /* parameter: original error state. */
        @ErrorProcedure, /* parameter: original error procedure name. */
        @ErrorLine       /* parameter: original error line number. */
        );

GO

----------------------------------------------------------------
-- [dbo].[tags_vm_pool_map] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Inserttags_vm_pool_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Inserttags_vm_pool_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Inserttags_vm_pool_map]
    @tag_id uniqueidentifier,  
 @vm_pool_id uniqueidentifier  
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[tags_vm_pool_map] ([tag_id], [vm_pool_id])
	VALUES (@tag_id, @vm_pool_id)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updatetags_vm_pool_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Updatetags_vm_pool_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updatetags_vm_pool_map]
    @tag_id int,
	@vm_pool_id int
AS
BEGIN

	--The [dbo].[tags_vm_pool_map] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Concurrent update error. Updated aborted.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletetags_vm_pool_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletetags_vm_pool_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletetags_vm_pool_map]
  @tag_id uniqueidentifier,  
 @vm_pool_id uniqueidentifier  
AS
BEGIN
	SET NOCOUNT ON
	
    DELETE FROM [dbo].[tags_vm_pool_map]
	WHERE [tag_id]=@tag_id AND [vm_pool_id]=@vm_pool_id
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromtags_vm_pool_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromtags_vm_pool_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromtags_vm_pool_map]    
AS
BEGIN
	SET NOCOUNT ON
	
	SELECT
	[tags_vm_pool_map].[tag_id] AS 'tag_id',
	[tags_vm_pool_map].[vm_pool_id] AS 'vm_pool_id'
FROM [dbo].[tags_vm_pool_map] [tags_vm_pool_map]

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Gettags_vm_pool_mapBytag_idAndByvm_pool_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Gettags_vm_pool_mapBytag_idAndByvm_pool_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Gettags_vm_pool_mapBytag_idAndByvm_pool_id] 
 @tag_id uniqueidentifier,  
 @vm_pool_id uniqueidentifier  
AS
BEGIN

	SET NOCOUNT ON
	
	SELECT
	[tags_vm_pool_map].[tag_id] AS 'tag_id',
	[tags_vm_pool_map].[vm_pool_id] AS 'vm_pool_id'
	FROM [dbo].[tags_vm_pool_map] [tags_vm_pool_map]
	WHERE [tag_id]=@tag_id AND [vm_pool_id]=@vm_pool_id

	SET NOCOUNT OFF
END

GO


--The GetByFK stored procedure cannot be created because the [dbo].[tags_vm_pool_map] table doesn't have at least one foreign key column or the foreign keys are also primary keys.


----custom
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetTagsByVmpoolId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetTagsByVmpoolId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetTagsByVmpoolId] 
	@vm_pool_ids nvarchar(max)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		distinct([tags_vm_pool_map_view].[tag_id]) AS 'tag_id',
		[tags_vm_pool_map_view].[tag_name] AS 'tag_name',
		[tags_vm_pool_map_view].[parent_id] AS 'parent_id',
		[tags_vm_pool_map_view].[readonly] AS 'readonly',
		[tags_vm_pool_map_view].[type] AS 'type'
		FROM [dbo].[tags_vm_pool_map_view] [tags_vm_pool_map_view]
		WHERE [vm_pool_id] in (select id from fnSplitter(@vm_pool_ids))
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END
GO

